/*
 * Decompiled with CFR 0.152.
 */
package pnuts.compiler;

import pnuts.compiler.Frame;
import pnuts.compiler.LocalInfo;

final class SymbolSet
implements Cloneable {
    SymbolSet parent;
    String[] keys = new String[4];
    LocalInfo[] info = new LocalInfo[4];
    int count = 0;

    SymbolSet() {
    }

    SymbolSet(SymbolSet parent) {
        this.parent = parent;
    }

    void add(String sym, int map) {
        this.add(sym, map, 0);
    }

    void add(String sym, int map, Frame frame) {
        this.add(sym, new LocalInfo(sym, map, frame));
    }

    void add(String sym, int map, int idx) {
        this.ensureCapacity(this.count + 1);
        this.keys[this.count] = sym = sym.intern();
        this.info[this.count] = new LocalInfo(sym, map, idx, false);
        ++this.count;
    }

    void add(String sym, LocalInfo i) {
        this.ensureCapacity(this.count + 1);
        this.keys[this.count] = sym;
        this.info[this.count] = i;
        ++this.count;
    }

    void ensureCapacity(int size) {
        if (size > this.keys.length) {
            String[] newKeys = new String[this.keys.length + size];
            System.arraycopy(this.keys, 0, newKeys, 0, this.keys.length);
            this.keys = newKeys;
            LocalInfo[] newInfo = new LocalInfo[this.info.length + size];
            System.arraycopy(this.info, 0, newInfo, 0, this.info.length);
            this.info = newInfo;
        }
    }

    LocalInfo assoc(String key) {
        return this._assoc(key.intern());
    }

    LocalInfo _assoc(String key) {
        for (int i = 0; i < this.count; ++i) {
            if (this.keys[i] != key) continue;
            return this.info[i];
        }
        if (this.parent != null) {
            return this.parent._assoc(key);
        }
        return null;
    }

    public Object clone() {
        try {
            SymbolSet ss = (SymbolSet)super.clone();
            ss.keys = new String[this.keys.length];
            System.arraycopy(ss.keys, 0, this.keys, 0, this.keys.length);
            ss.info = new LocalInfo[this.info.length];
            System.arraycopy(ss.info, 0, this.info, 0, this.info.length);
            return ss;
        }
        catch (Throwable t) {
            throw new InternalError();
        }
    }
}

