/*
 * Decompiled with CFR 0.152.
 */
package tratz.runpipe.impl.annotators.parse;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import tratz.jwni.WordNet;
import tratz.parse.NLParser;
import tratz.parse.featgen.ParseFeatureGenerator;
import tratz.parse.ml.ParseModel;
import tratz.parse.transform.VchTransformer;
import tratz.parse.types.Arc;
import tratz.parse.types.Parse;
import tratz.runpipe.Annotation;
import tratz.runpipe.Annotator;
import tratz.runpipe.InitializationException;
import tratz.runpipe.ProcessException;
import tratz.runpipe.TextDocument;
import tratz.runpipe.annotations.Sentence;
import tratz.runpipe.annotations.Token;
import tratz.runpipe.util.RunpipeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TratzParserAnnotator
implements Annotator {
    public static final String PARAM_MODEL_FILE = "ModelFile";
    public static final String PARAM_WORDNET_LOCATION = "WordNetDir";
    public static final String PARAM_ENABLE_VCH_TRANSFORM = "VchTransform";
    private NLParser mNlParser;
    private boolean mVchTransform = false;

    @Override
    public void initialize(Map<String, String> args) throws InitializationException {
        try {
            String enableVchTransformParam;
            System.err.print("Loading model...");
            long startTime = System.currentTimeMillis();
            String modelFile = args.get(PARAM_MODEL_FILE);
            FilterInputStream is = new BufferedInputStream(new FileInputStream(modelFile));
            if (modelFile.endsWith(".gz")) {
                is = new GZIPInputStream(is);
            }
            ObjectInputStream ois = new ObjectInputStream(is);
            ParseModel model = (ParseModel)ois.readObject();
            ParseFeatureGenerator featGen = (ParseFeatureGenerator)ois.readObject();
            ois.close();
            System.err.println("loaded");
            System.err.println("Model loading took: " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds.");
            this.mNlParser = new NLParser(model, featGen);
            String wnLocation = args.get(PARAM_WORDNET_LOCATION);
            if (wnLocation != null) {
                new WordNet(new File(wnLocation));
            }
            if ((enableVchTransformParam = args.get(PARAM_ENABLE_VCH_TRANSFORM)) != null) {
                this.mVchTransform = Boolean.parseBoolean(enableVchTransformParam);
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new InitializationException(cnfe);
        }
        catch (IOException ioe) {
            throw new InitializationException(ioe);
        }
    }

    @Override
    public void process(TextDocument doc) throws ProcessException {
        List<? extends Annotation> sentences = doc.getAnnotationList(Sentence.class);
        List<? extends Annotation> tokens = doc.getAnnotationList(Token.class);
        try {
            if (sentences != null && tokens != null) {
                VchTransformer vchTransform = new VchTransformer();
                for (Sentence sentence : sentences) {
                    List<? extends Annotation> sentenceTokens = RunpipeUtils.getSublist(sentence, tokens);
                    ArrayList<tratz.parse.types.Token> parserTokens = new ArrayList<tratz.parse.types.Token>();
                    int numTokens = sentenceTokens.size();
                    for (int i = 0; i < numTokens; ++i) {
                        Token tok = (Token)sentenceTokens.get(i);
                        tratz.parse.types.Token parseToken = new tratz.parse.types.Token(tok.getAnnotText(), i + 1);
                        parseToken.setPos(tok.getPos());
                        parserTokens.add(parseToken);
                    }
                    tratz.parse.types.Sentence inputSentence = new tratz.parse.types.Sentence(parserTokens);
                    Parse parse = this.mNlParser.parseSentence(inputSentence);
                    if (parse == null) continue;
                    if (this.mVchTransform) {
                        vchTransform.performTransformation(parse);
                    }
                    for (tratz.parse.types.Token parseToken : parserTokens) {
                        List toChildren = parse.getDependentArcLists()[parseToken.getIndex()];
                        Token parent = (Token)sentenceTokens.get(parseToken.getIndex() - 1);
                        if (toChildren == null) continue;
                        for (Arc childArc : toChildren) {
                            Token child = (Token)sentenceTokens.get(childArc.getChild().getIndex() - 1);
                            Token.Arc depArc = new Token.Arc(parent, child, childArc.getDependency());
                            child.setParentArc(depArc);
                            parent.addDependent(depArc);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ProcessException(e);
        }
    }
}

