/*
 * Decompiled with CFR 0.152.
 */
package Jet.Util;

import Jet.Lisp.FeatureSet;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.ExternalDocument;
import Jet.Tipster.Span;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AceUtils {
    private static final String TEXT_SEGMENT_TAG_NAME = "TEXT";
    private static final DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
    private static final Map<String, String> typeMap;
    private static final Map<String, NameAnnotator> annotators;

    public static Document loadAnnotatedDocument(File file) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder documentBuilder = builderFactory.newDocumentBuilder();
        documentBuilder.setEntityResolver(new ACEEntityResolver());
        Element element = documentBuilder.parse(file).getDocumentElement();
        File file2 = AceUtils.getSourceFile(file.getParentFile(), element);
        ExternalDocument externalDocument = new ExternalDocument("sgml", file2.getPath());
        externalDocument.setAllTags(true);
        if (!externalDocument.open()) {
            throw new IOException();
        }
        DocumentType documentType = element.getOwnerDocument().getDoctype();
        NameAnnotator nameAnnotator = annotators.get(documentType.getSystemId());
        if (nameAnnotator == null) {
            throw new RuntimeException("DOCTYPE " + documentType.getSystemId() + " is not supported.");
        }
        nameAnnotator.annotate(externalDocument, element);
        return externalDocument;
    }

    public static Collection<Document> loadAnnotatedDocumentsFromDirectory(File file) throws ParserConfigurationException, SAXException, IOException {
        ArrayList<Document> arrayList = new ArrayList<Document>();
        for (File file2 : file.listFiles()) {
            if (!file2.getName().toLowerCase().endsWith(".apf.xml")) continue;
            arrayList.add(AceUtils.loadAnnotatedDocument(file2));
        }
        return arrayList;
    }

    private static File getSourceFile(File file, Element element) {
        File file2 = new File(file, element.getAttribute("URI"));
        if (file2.exists()) {
            return file2;
        }
        String string = AceUtils.getChild(element, "document").getAttribute("DOCID");
        file2 = new File(file, string + ".sgm");
        if (file2.exists()) {
            return file2;
        }
        return null;
    }

    public static void writeNamedEntities(Document document, Writer writer) throws ParserConfigurationException, TransformerFactoryConfigurationError, TransformerException {
        Object object;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        org.w3c.dom.Document document2 = documentBuilder.newDocument();
        String string = document.normalizedText(document.annotationsOfType("DOCNO").get(0));
        Element element = document2.createElement("source_file");
        document2.appendChild(element);
        element.setAttribute("TYPE", "text");
        element.setAttribute("VERSION", "1.2");
        element.setAttribute("URI", string);
        Element element2 = document2.createElement("document");
        element.appendChild(element2);
        element2.setAttribute("DOCID", string);
        Vector<Annotation> vector = document.annotationsOfType("ENAMEX");
        int n = 1;
        for (Annotation object22 : vector) {
            object = document2.createElement("entity");
            element2.appendChild((Node)object);
            object.setAttribute("ID", string + "-" + n);
            Element element3 = document2.createElement("entity_type");
            object.appendChild(element3);
            element3.appendChild(document2.createTextNode((String)object22.get("TYPE")));
            Element element4 = document2.createElement("entity_mention");
            object.appendChild(element4);
            element4.setAttribute("TYPE", "NAME");
            Element element5 = document2.createElement("head");
            element4.appendChild(element5);
            element5.appendChild(AceUtils.createCharseqElement(document2, document, object22.span()));
            Element element6 = document2.createElement("extent");
            element4.appendChild(element6);
            element6.appendChild(AceUtils.createCharseqElement(document2, document, object22.span()));
            ++n;
        }
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        DOMSource dOMSource = new DOMSource(document2);
        object = new StreamResult(writer);
        transformer.transform(dOMSource, (Result)object);
    }

    private static Element createCharseqElement(org.w3c.dom.Document document, Document document2, Span span) {
        int n;
        int n2 = span.start();
        for (n = span.end() - 1; n > 0 && Character.isWhitespace(document2.charAt(n)); --n) {
        }
        Element element = document.createElement("charseq");
        Element element2 = document.createElement("start");
        element.appendChild(element2);
        element2.appendChild(document.createTextNode(Integer.toString(n2)));
        Element element3 = document.createElement("end");
        element.appendChild(element3);
        element3.appendChild(document.createTextNode(Integer.toString(n)));
        return element;
    }

    private static final int skipWhitespace(Document document, Span span, int n) {
        int n2 = span.end();
        while (n < n2 && Character.isWhitespace(document.charAt(n))) {
            ++n;
        }
        return n;
    }

    private static List<Element> getChildren(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element2 = (Element)node;
            if (string != null && !string.equals(element2.getTagName())) continue;
            arrayList.add(element2);
        }
        return arrayList;
    }

    private static Element getChild(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !(element2 = (Element)node).getTagName().equals(string)) continue;
            return element2;
        }
        return null;
    }

    public static void main(String[] stringArray) throws Exception {
        File file = new File("../corpus/test");
        Collection<Document> collection = AceUtils.loadAnnotatedDocumentsFromDirectory(file);
        for (Document document : collection) {
            document.setSGMLwrapMargin(0);
            System.out.println(document.writeSGML(null));
        }
    }

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("GSP", "GPE");
        hashMap.put("PER", "PERSON");
        hashMap.put("ORG", "ORGANIZATION");
        hashMap.put("LOC", "LOCATION");
        hashMap.put("FAC", "FACILITY");
        typeMap = Collections.unmodifiableMap(hashMap);
        HashMap<String, NameAnnotator> hashMap2 = new HashMap<String, NameAnnotator>();
        hashMap2.put("apf.v5.1.1.dtd", Ace2005and2004NameAnnotator.getInstance());
        hashMap2.put("apf.v4.0.1.dtd", Ace2005and2004NameAnnotator.getInstance());
        hashMap2.put("ace-rdc.v2.0.1.dtd", Ace2003NameAnnotator.getInstance());
        hashMap2.put("ace-pilot-ref.dtd", Ace2001NameAnnotator.getInstance());
        annotators = Collections.unmodifiableMap(hashMap2);
    }

    private static class ACEEntityResolver
    implements EntityResolver {
        private ACEEntityResolver() {
        }

        public InputSource resolveEntity(String string, String string2) {
            String string3;
            ClassLoader classLoader = this.getClass().getClassLoader();
            InputStream inputStream = classLoader.getResourceAsStream(string3 = "Jet/Util/dtd/" + ACEEntityResolver.basename(string2));
            if (inputStream == null) {
                System.out.println("not found");
                return null;
            }
            return new InputSource(inputStream);
        }

        private static String basename(String string) {
            int n = string.lastIndexOf("/");
            if (n >= 0) {
                return string.substring(n + 1);
            }
            return string;
        }
    }

    private static class Ace2001NameAnnotator
    implements NameAnnotator {
        private static final Ace2001NameAnnotator instance = new Ace2001NameAnnotator();

        private Ace2001NameAnnotator() {
        }

        public static Ace2001NameAnnotator getInstance() {
            return instance;
        }

        public void annotate(Document document, Element element) {
            Vector<Annotation> vector = document.annotationsOfType(AceUtils.TEXT_SEGMENT_TAG_NAME);
            assert (vector != null);
            assert (vector.size() == 1);
            Annotation annotation = (Annotation)vector.get(0);
            Element element2 = AceUtils.getChild(element, "document");
            List list = AceUtils.getChildren(element2, "entity");
            for (Element element3 : list) {
                String string = AceUtils.getChild(element3, "entity_type").getTextContent();
                if (typeMap.containsKey(string)) {
                    string = (String)typeMap.get(string);
                }
                List list2 = AceUtils.getChildren(element3, "entity_mention");
                for (Element element4 : list2) {
                    String string2 = element4.getAttribute("TYPE");
                    if (!string2.equals("NAME")) continue;
                    Element element5 = AceUtils.getChild(element4, "head");
                    Element element6 = AceUtils.getChild(element5, "charseq");
                    String string3 = AceUtils.getChild(element6, "start").getTextContent();
                    String string4 = AceUtils.getChild(element6, "end").getTextContent();
                    int n = Integer.parseInt(string3);
                    int n2 = Integer.parseInt(string4) + 1;
                    n2 = AceUtils.skipWhitespace(document, annotation.span(), n2);
                    FeatureSet featureSet = new FeatureSet();
                    featureSet.put("TYPE", string);
                    document.annotate("ENAMEX", new Span(n, n2), featureSet);
                }
            }
        }
    }

    private static class Ace2003NameAnnotator
    implements NameAnnotator {
        private static Ace2003NameAnnotator instance = new Ace2003NameAnnotator();

        private Ace2003NameAnnotator() {
        }

        public static Ace2003NameAnnotator getInstance() {
            return instance;
        }

        public void annotate(Document document, Element element) {
            Element element2 = AceUtils.getChild(element, "document");
            List list = AceUtils.getChildren(element2, "entity");
            Vector<Annotation> vector = document.annotationsOfType(AceUtils.TEXT_SEGMENT_TAG_NAME);
            Annotation annotation = (Annotation)vector.get(0);
            for (Element element3 : list) {
                String string = AceUtils.getChild(element3, "entity_type").getTextContent();
                if (typeMap.containsKey(string)) {
                    string = (String)typeMap.get(string);
                }
                List list2 = AceUtils.getChildren(element3, "entity_mention");
                for (Element element4 : list2) {
                    String string2 = element4.getAttribute("TYPE");
                    if (!string2.equals("NAME")) continue;
                    Element element5 = AceUtils.getChild(element4, "head");
                    Element element6 = AceUtils.getChild(element5, "charseq");
                    String string3 = AceUtils.getChild(element6, "start").getTextContent();
                    String string4 = AceUtils.getChild(element6, "end").getTextContent();
                    int n = Integer.parseInt(string3);
                    int n2 = Integer.parseInt(string4) + 1;
                    n2 = AceUtils.skipWhitespace(document, annotation.span(), n2);
                    FeatureSet featureSet = new FeatureSet();
                    featureSet.put("TYPE", string);
                    document.annotate("ENAMEX", new Span(n, n2), featureSet);
                }
            }
        }
    }

    private static class Ace2005and2004NameAnnotator
    implements NameAnnotator {
        private static Ace2005and2004NameAnnotator instance = new Ace2005and2004NameAnnotator();

        private Ace2005and2004NameAnnotator() {
        }

        public static Ace2005and2004NameAnnotator getInstance() {
            return instance;
        }

        public void annotate(Document document, Element element) {
            Element element2 = AceUtils.getChild(element, "document");
            List list = AceUtils.getChildren(element2, "entity");
            Vector<Annotation> vector = document.annotationsOfType(AceUtils.TEXT_SEGMENT_TAG_NAME);
            Annotation annotation = (Annotation)vector.get(0);
            for (Element element3 : list) {
                String string = element3.getAttribute("TYPE");
                if (typeMap.containsKey(string)) {
                    string = (String)typeMap.get(string);
                }
                List list2 = AceUtils.getChildren(element3, "entity_mention");
                for (Element element4 : list2) {
                    String string2 = element4.getAttribute("TYPE");
                    if (!string2.equals("NAM")) continue;
                    Element element5 = AceUtils.getChild(element4, "head");
                    Element element6 = AceUtils.getChild(element5, "charseq");
                    int n = Integer.parseInt(element6.getAttribute("START"));
                    int n2 = Integer.parseInt(element6.getAttribute("END"));
                    n2 = AceUtils.skipWhitespace(document, annotation.span(), n2 + 1);
                    FeatureSet featureSet = new FeatureSet();
                    featureSet.put("TYPE", string);
                    document.annotate("ENAMEX", new Span(n, n2), featureSet);
                }
            }
        }
    }

    private static interface NameAnnotator {
        public void annotate(Document var1, Element var2);
    }
}

