/*
 * Decompiled with CFR 0.152.
 */
package Jet.NE;

import Jet.NE.ChangeRule;
import Jet.NE.ChangeType;
import Jet.NE.ClassHierarchyResolver;
import Jet.NE.MatchRuleItem;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import java.util.Set;

public class TransformRule {
    private MatchRuleItem[] ruleItems;
    private ChangeRule[] changeRules;
    private ChangeType changeType;

    public void setMatchRules(MatchRuleItem[] matchRuleItemArray) {
        this.ruleItems = matchRuleItemArray;
    }

    public void setChangeRule(ChangeType changeType, ChangeRule[] changeRuleArray) {
        this.changeType = changeType;
        this.changeRules = changeRuleArray;
    }

    public int getPatternTokenCount() {
        return this.ruleItems.length;
    }

    public boolean accept(Document document, Annotation[] annotationArray, int n, ClassHierarchyResolver classHierarchyResolver) {
        if (n + this.ruleItems.length > annotationArray.length) {
            return false;
        }
        for (int i = 0; i < this.ruleItems.length; ++i) {
            if (this.ruleItems[i].accept(document, annotationArray, n + i, classHierarchyResolver)) continue;
            return false;
        }
        return true;
    }

    public void transform(Document document, Annotation[] annotationArray, int n) {
        if (!this.canApplyChangeRule(document, annotationArray, n)) {
            return;
        }
        for (ChangeRule changeRule : this.changeRules) {
            int n2 = changeRule.getIndex();
            Set set = (Set)annotationArray[n + n2].get("categories");
            set.clear();
            set.add(changeRule.getNamedEntity());
        }
    }

    private boolean canApplyChangeRule(Document document, Annotation[] annotationArray, int n) {
        if (this.changeType == ChangeType.FORCE) {
            return true;
        }
        for (ChangeRule changeRule : this.changeRules) {
            int n2 = changeRule.getIndex();
            Set set = (Set)annotationArray[n + n2].get("categories");
            if (set.size() <= 0) continue;
            return false;
        }
        return true;
    }
}

