/*
 * Decompiled with CFR 0.152.
 */
package Jet.NE;

import AceJet.AceDocument;
import AceJet.AceEntity;
import AceJet.AceEntityMention;
import Jet.HMM.HMMNameTagger;
import Jet.HMM.HMMTagger;
import Jet.HMM.WordFeatureHMMemitter;
import Jet.Lex.Tokenizer;
import Jet.Lisp.FeatureSet;
import Jet.NE.NameAnnotator;
import Jet.NE.RuleFormatException;
import Jet.NE.TrieDictionary;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.Span;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Evaluate {
    private File inputDir;
    private File outputDir;
    private HMMTagger hmmTagger;
    private HMMNameTagger hmmNameTagger;
    private NameAnnotator annotator = new NameAnnotator();
    private String format;
    private String target;
    private int countOfExtracted;
    private int countOfGold;
    private int countOfExactMatch;
    private int countOfPositionMatch;

    public Evaluate(String string, String string2, Properties properties) throws IOException, RuleFormatException {
        this.inputDir = new File(string);
        this.outputDir = new File(string2);
        if (!this.inputDir.isDirectory()) {
            throw new IllegalArgumentException("inputDirectory must be directory");
        }
        if (this.outputDir.exists()) {
            if (!this.outputDir.isDirectory()) {
                throw new IllegalArgumentException("inputDirectory must be directory");
            }
        } else {
            this.outputDir.mkdirs();
        }
        this.init(properties);
    }

    private void init(Properties properties) throws IOException, RuleFormatException {
        String[] stringArray;
        String string = properties.getProperty("ne.dict.trie");
        String string2 = properties.getProperty("ne.dict.cdb");
        String string3 = properties.getProperty("ne.hierarchy");
        String string4 = properties.getProperty("hmm.model.pos");
        String string5 = properties.getProperty("hmm.model.ne");
        String string6 = properties.getProperty("ne.rule");
        String string7 = properties.getProperty("ne.map");
        this.target = properties.getProperty("target");
        this.format = properties.getProperty("format");
        for (String string8 : stringArray = new String[]{"ne.dict.trie", "ne.dict.cdb", "ne.hierarchy", "hmm.model.pos", "ne.rule", "format", "target"}) {
            String string9 = properties.getProperty(string8);
            if (string9 != null && string9.trim().length() != 0) continue;
            String string10 = string8 + " must be specified";
            throw new RuntimeException(string10);
        }
        TrieDictionary trieDictionary = new TrieDictionary(string, string2);
        this.annotator.setDictionary(trieDictionary);
        this.hmmTagger = new HMMTagger();
        this.hmmTagger.load(string4);
        if (string5 != null) {
            this.hmmNameTagger = new HMMNameTagger(WordFeatureHMMemitter.class);
            this.hmmNameTagger.load(string5);
            this.hmmNameTagger.nameHMM.newDocument();
        }
        this.annotator.loadRules(new File(string6));
        this.annotator.loadClassHierarchy(new File(string3));
        if (string7 != null) {
            Map<String, String> map = this.loadNamedEntityMap(string7);
            this.annotator.setAliasMap(map);
        }
    }

    public void run() throws IOException {
        this.countOfGold = 0;
        this.countOfExtracted = 0;
        this.countOfExactMatch = 0;
        this.countOfPositionMatch = 0;
        for (File file : this.inputDir.listFiles()) {
            String string = file.getPath();
            if (!string.endsWith(".sgm") && !string.endsWith(".sgml")) continue;
            Document document = null;
            if (this.format.equalsIgnoreCase("sgml")) {
                document = this.readSGML(file);
            } else if (this.format.equalsIgnoreCase("sgml+apf")) {
                File file2 = new File(file.getParent(), file.getName() + ".apf.xml");
                document = this.readSGMLAndAPF(file, file2);
            } else {
                throw new RuntimeException("Illegal format : " + this.format);
            }
            this.processDocument(document, file);
        }
        System.out.println("total (exactMatch) :");
        System.out.printf("recall    : %.2f", this.percentage(this.countOfExactMatch, this.countOfGold));
        System.out.println();
        System.out.printf("precision : %.2f", this.percentage(this.countOfExactMatch, this.countOfExtracted));
        System.out.println();
        System.out.println("total: (positionMatch)");
        System.out.printf("recall    : %.2f", this.percentage(this.countOfPositionMatch, this.countOfGold));
        System.out.println();
        System.out.printf("precision : %.2f", this.percentage(this.countOfPositionMatch, this.countOfExtracted));
        System.out.println();
        System.out.println();
    }

    private double percentage(int n, int n2) {
        return (double)n / (double)n2 * 100.0;
    }

    private void processDocument(Document document, File file) throws IOException {
        Document document2 = new Document(document.text());
        document2.annotateWithTag(this.target);
        Vector<Annotation> vector = document2.annotationsOfType(this.target);
        for (Annotation object2 : vector) {
            Tokenizer.tokenize(document2, object2.span());
            this.hmmTagger.tagJet(document2, object2.span());
            if (this.hmmNameTagger != null) {
                this.hmmNameTagger.tag(document2, object2.span());
            }
            this.annotator.annotate(document2, object2.span());
        }
        SortedMap<Span, String> sortedMap = this.extractEntities(document);
        SortedMap<Span, String> sortedMap2 = this.extractEntities(document2);
        File file2 = new File(this.outputDir, file.getName() + ".gold");
        File file3 = new File(this.outputDir, file.getName() + ".out");
        this.writeEntities(document, sortedMap, new PrintStream(file2));
        this.writeEntities(document2, sortedMap2, new PrintStream(file3));
        int n = 0;
        int n2 = 0;
        for (Map.Entry<Span, String> entry : sortedMap2.entrySet()) {
            String string = (String)sortedMap.get(entry.getKey());
            if (string == null) continue;
            ++n2;
            if (!entry.getValue().equals(string)) continue;
            ++n;
        }
        System.out.println(file.getName() + " (exactMatch) :");
        System.out.printf("recall:    %.2f", this.percentage(n, sortedMap.size()));
        System.out.println();
        System.out.printf("precision: %.2f", this.percentage(n, sortedMap2.size()));
        System.out.println();
        System.out.println(file.getName() + " (positionMatch) :");
        System.out.printf("recall:    %.2f", this.percentage(n2, sortedMap.size()));
        System.out.println();
        System.out.printf("precision: %.2f", this.percentage(n2, sortedMap2.size()));
        System.out.println();
        this.countOfGold += sortedMap.size();
        this.countOfExactMatch += n;
        this.countOfExtracted += sortedMap2.size();
        this.countOfPositionMatch += n2;
    }

    private void writeEntities(Document document, SortedMap<Span, String> sortedMap, PrintStream printStream) {
        for (Map.Entry<Span, String> entry : sortedMap.entrySet()) {
            String string = document.normalizedText(entry.getKey()).replaceAll("\\s+", " ");
            String string2 = entry.getValue();
            printStream.print(string);
            printStream.print(' ');
            printStream.print(string2);
            printStream.println();
        }
    }

    private Document readSGML(File file) throws IOException {
        Object object;
        String string;
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        fileInputStream = new FileInputStream(file);
        bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "ISO-8859-1"));
        StringBuilder stringBuilder = new StringBuilder();
        while ((string = bufferedReader.readLine()) != null) {
            stringBuilder.append(string);
            stringBuilder.append('\n');
        }
        Pattern pattern = this.makeTargetTagPattern(this.target);
        Matcher matcher = pattern.matcher(stringBuilder);
        Pattern pattern2 = Pattern.compile("<(.*?)>(\\s*)(.*?)</\\1>(\\s*)", 32);
        Matcher matcher2 = pattern2.matcher(stringBuilder);
        StringBuilder stringBuilder2 = new StringBuilder();
        TreeMap<Span, Object> treeMap = new TreeMap<Span, Object>();
        int n = 0;
        while (matcher.find()) {
            stringBuilder2.append(stringBuilder, n, matcher.start(1));
            matcher2.region(matcher.start(), matcher.end(1));
            int n2 = matcher.start();
            while (matcher2.find()) {
                stringBuilder2.append(stringBuilder, n2, matcher2.start());
                String string2 = matcher2.group(1);
                String object2 = matcher2.group(2);
                object = matcher2.group(3);
                String string3 = matcher2.group(4);
                int n3 = stringBuilder2.length() + object2.length();
                int n4 = n3 + ((String)object).length() + string3.length();
                treeMap.put(new Span(n3, n4), string2);
                stringBuilder2.append(object2);
                stringBuilder2.append((String)object);
                stringBuilder2.append(string3);
                n2 = matcher2.end();
            }
            stringBuilder2.append(stringBuilder, n2, matcher.end());
            n = matcher.end();
        }
        stringBuilder2.append(stringBuilder, n, stringBuilder.length());
        Document document = new Document(stringBuilder2.toString());
        for (Map.Entry entry : treeMap.entrySet()) {
            object = new FeatureSet();
            ((FeatureSet)object).put("TYPE", entry.getValue());
            document.annotate("ENAMEX", (Span)entry.getKey(), (FeatureSet)object);
        }
        return document;
    }

    private Document readSGMLAndAPF(File file, File file2) {
        AceDocument.ace2004 = false;
        AceDocument.ace2005 = true;
        AceDocument aceDocument = new AceDocument(file.getPath(), file2.getPath());
        Document document = aceDocument.JetDocument();
        ArrayList<AceEntity> arrayList = aceDocument.entities;
        String string = aceDocument.JetDocument().text();
        int[] nArray = this.computeOffsetMap(string);
        for (AceEntity aceEntity : arrayList) {
            for (AceEntityMention aceEntityMention : aceEntity.mentions) {
                if (!aceEntityMention.type.equals("NAME")) continue;
                int n = nArray[aceEntityMention.getJetHead().start()];
                int n2 = nArray[aceEntityMention.getJetHead().end()];
                FeatureSet featureSet = new FeatureSet();
                featureSet.put("TYPE", aceEntity.type);
                Span span = new Span(n, n2);
                document.annotate("ENAMEX", span, featureSet);
            }
        }
        return document;
    }

    private int[] computeOffsetMap(CharSequence charSequence) {
        int n = charSequence.length();
        int[] nArray = new int[n];
        boolean bl = false;
        int n2 = 0;
        block4: for (int i = 0; i < n; ++i) {
            switch (charSequence.charAt(i)) {
                case '<': {
                    bl = true;
                    continue block4;
                }
                case '>': {
                    bl = false;
                    continue block4;
                }
                default: {
                    if (bl) continue block4;
                    nArray[n2++] = i;
                }
            }
        }
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }

    private SortedMap<Span, String> extractEntities(Document document) {
        Vector<Annotation> vector = document.annotationsOfType("ENAMEX");
        TreeMap<Span, String> treeMap = new TreeMap<Span, String>();
        if (vector != null) {
            for (Annotation annotation : vector) {
                String string = (String)annotation.get("TYPE");
                treeMap.put(annotation.span(), string);
            }
        }
        return treeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> loadNamedEntityMap(String string) throws IOException {
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            String string2;
            fileInputStream = new FileInputStream(string);
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "ISO-8859-1"));
            while ((string2 = bufferedReader.readLine()) != null) {
                String[] stringArray = string2.split("\\s+", 2);
                assert (stringArray.length == 2);
                hashMap.put(stringArray[0], stringArray[1]);
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            } else if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        return hashMap;
    }

    private Pattern makeTargetTagPattern(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<");
        stringBuilder.append(Pattern.quote(string));
        stringBuilder.append(">(.*?)");
        stringBuilder.append("</");
        stringBuilder.append(Pattern.quote(string));
        stringBuilder.append(">");
        return Pattern.compile(stringBuilder.toString(), 32);
    }

    public static void main(String[] stringArray) throws IOException, RuleFormatException {
        if (stringArray.length != 3) {
            Evaluate.usage();
            System.exit(-1);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(string));
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            System.exit(1);
        }
        Evaluate evaluate = new Evaluate(string2, string3, properties);
        evaluate.run();
    }

    private static void usage() {
        System.err.printf("Usage: java %s propertyFile inputDir outputDir\n", Evaluate.class.getName());
    }
}

