/*
 * Decompiled with CFR 0.152.
 */
package tratz.jwni;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import tratz.jwni.IndexEntry;
import tratz.jwni.LexPointer;
import tratz.jwni.MorphoProcessor;
import tratz.jwni.POS;
import tratz.jwni.PointerType;
import tratz.jwni.Pointers;
import tratz.jwni.SemPointer;
import tratz.jwni.Sense;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordNet {
    private static WordNet sInstance;
    private Map<Integer, Sense> mNounToSenseMap = new HashMap<Integer, Sense>();
    private Map<Integer, Sense> mVerbToSenseMap = new HashMap<Integer, Sense>();
    private Map<Integer, Sense> mAdjToSenseMap = new HashMap<Integer, Sense>();
    private Map<Integer, Sense> mAdvToSenseMap = new HashMap<Integer, Sense>();
    private Map<String, Sense> mKeyHashToSense = new HashMap<String, Sense>();
    private Map<POS, Map<Integer, Sense>> mPosToSenseMap = new HashMap<POS, Map<Integer, Sense>>();
    private Map<POS, Map<String, IndexEntry>> mPosToIndexEntries = new HashMap<POS, Map<String, IndexEntry>>();
    private Map<Integer, String> mLexnamesMap = new HashMap<Integer, String>();
    private MorphoProcessor mMorpho;
    private static final Map<Integer, POS> INTEGER_TO_POS;
    private static final Map<String, POS> STRING_TO_POS;

    public static WordNet getInstance() {
        return sInstance;
    }

    public WordNet(String base) throws IOException {
        this(URI.create(base + File.separator + "index.sense").toURL(), URI.create(base + File.separator + "data.noun").toURL(), URI.create(base + File.separator + "data.verb").toURL(), URI.create(base + File.separator + "data.adj").toURL(), URI.create(base + File.separator + "data.adv").toURL(), URI.create(base + File.separator + "index.noun").toURL(), URI.create(base + File.separator + "index.verb").toURL(), URI.create(base + File.separator + "index.adj").toURL(), URI.create(base + File.separator + "index.adv").toURL(), URI.create(base + File.separator + "lexnames").toURL(), true);
        this.mMorpho = new MorphoProcessor(this, base);
        sInstance = this;
    }

    public WordNet(File base) throws IOException {
        this(base, true);
    }

    public WordNet(File base, boolean includeGloss) throws IOException {
        this(new File(base, "index.sense").toURI().toURL(), new File(base, "data.noun").toURI().toURL(), new File(base, "data.verb").toURI().toURL(), new File(base, "data.adj").toURI().toURL(), new File(base, "data.adv").toURI().toURL(), new File(base, "index.noun").toURI().toURL(), new File(base, "index.verb").toURI().toURL(), new File(base, "index.adj").toURI().toURL(), new File(base, "index.adv").toURI().toURL(), new File(base, "lexnames").toURI().toURL(), includeGloss);
        this.mMorpho = new MorphoProcessor(this, base);
        sInstance = this;
    }

    private WordNet(URL indexURL, URL nounDataURL, URL verbDataURL, URL adjDataURL, URL advDataURL, URL nounIndexURL, URL verbIndexURL, URL adjIndexURL, URL advIndexURL, URL lexnamesURL, boolean includeGloss) throws IOException {
        this.mPosToSenseMap.put(POS.NOUN, this.mNounToSenseMap);
        this.mPosToSenseMap.put(POS.VERB, this.mVerbToSenseMap);
        this.mPosToSenseMap.put(POS.ADJECTIVE, this.mAdjToSenseMap);
        this.mPosToSenseMap.put(POS.ADVERB, this.mAdvToSenseMap);
        HashMap<String, String> canonicalStrings = new HashMap<String, String>();
        this.readDataBase(nounDataURL, this.mNounToSenseMap, includeGloss, canonicalStrings);
        this.readDataBase(verbDataURL, this.mVerbToSenseMap, includeGloss, canonicalStrings);
        this.readDataBase(adjDataURL, this.mAdjToSenseMap, includeGloss, canonicalStrings);
        this.readDataBase(advDataURL, this.mAdvToSenseMap, includeGloss, canonicalStrings);
        this.mPosToIndexEntries.put(POS.NOUN, this.readIndex(nounIndexURL));
        this.mPosToIndexEntries.put(POS.VERB, this.readIndex(verbIndexURL));
        this.mPosToIndexEntries.put(POS.ADJECTIVE, this.readIndex(adjIndexURL));
        this.mPosToIndexEntries.put(POS.ADVERB, this.readIndex(advIndexURL));
        this.readSenseIndex(indexURL);
        this.readLexNames(lexnamesURL);
    }

    private void readLexNames(URL lexnamesURL) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(lexnamesURL.openStream()));
        String line = null;
        while ((line = reader.readLine()) != null) {
            String[] split = line.trim().split("\\t+");
            if (split.length != 3) continue;
            this.mLexnamesMap.put(Integer.parseInt(split[0].trim()), split[1]);
        }
        reader.close();
    }

    private void readSenseIndex(URL senseIndexURL) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(senseIndexURL.openStream()));
        String line = null;
        while ((line = reader.readLine()) != null) {
            Sense.Key[] keys;
            if (line.trim().equals("")) continue;
            String[] split = line.split("\\s+");
            String wnSenseKey = split[0];
            int offset = Integer.parseInt(split[1]);
            int senseNum = Integer.parseInt(split[2]) - 1;
            int tagCount = Integer.parseInt(split[3]);
            int percentIndex = wnSenseKey.indexOf(37);
            String lemma = wnSenseKey.substring(0, percentIndex);
            int posInt = Integer.parseInt(wnSenseKey.substring(percentIndex + 1, wnSenseKey.indexOf(58)));
            POS pos = INTEGER_TO_POS.get(posInt);
            Map<String, IndexEntry> lemmaToIndexEntry = this.mPosToIndexEntries.get((Object)pos);
            IndexEntry iEntry = lemmaToIndexEntry.get(lemma);
            Sense sense = iEntry.getSenses()[senseNum];
            for (Sense.Key key : keys = sense.getKeys()) {
                if (!key.getLemma().toLowerCase().equals(lemma)) continue;
                key.setTagCount(tagCount);
                key.setSenseKey(wnSenseKey);
                this.mKeyHashToSense.put(wnSenseKey, sense);
            }
        }
        reader.close();
    }

    public String getLexName(int lexId) {
        return this.mLexnamesMap.get(lexId);
    }

    private Map<String, IndexEntry> readIndex(URL indexURL) throws IOException {
        LinkedHashMap<String, IndexEntry> entries = new LinkedHashMap<String, IndexEntry>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(indexURL.openStream()));
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("  ")) continue;
            String[] split = line.split(" ");
            String lemma = split[0];
            POS pos = STRING_TO_POS.get(split[1]);
            int numSenses = Integer.parseInt(split[2]);
            int numPointerTypes = Integer.parseInt(split[3]);
            int[] senses = new int[numSenses];
            for (int i = 0; i < numSenses; ++i) {
                senses[i] = Integer.parseInt(split[6 + numPointerTypes + i]);
            }
            IndexEntry entry = new IndexEntry(this, pos, lemma, senses);
            entries.put(entry.getLemma(), entry);
        }
        reader.close();
        return entries;
    }

    public MorphoProcessor getMorpho() {
        return this.mMorpho;
    }

    public Map<String, IndexEntry> getIndexWords(POS pos) {
        return this.mPosToIndexEntries.get((Object)pos);
    }

    public Map<Integer, Sense> getSenses(POS pos) {
        return this.mPosToSenseMap.get((Object)pos);
    }

    public IndexEntry getIndexEntry(POS pos, String lemma) {
        return this.mPosToIndexEntries.get((Object)pos).get(lemma);
    }

    public IndexEntry lookupIndexEntry(POS pos, String lemma, boolean splitIfNecessary) {
        return this.mMorpho.lookupIndexEntry(pos, lemma, splitIfNecessary);
    }

    public IndexEntry lookupIndexEntry(POS pos, String lemma) {
        return this.lookupIndexEntry(pos, lemma, true);
    }

    public Sense getSense(String wnkey) {
        return this.mKeyHashToSense.get(wnkey);
    }

    public Sense getSenseAtOffset(POS pos, int offset) {
        return this.mPosToSenseMap.get((Object)pos).get(offset);
    }

    private void readDataBase(URL dataURL, Map<Integer, Sense> senseMap, boolean includeGloss, Map<String, String> canonicalStrings) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(dataURL.openStream()));
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("  ")) continue;
            Sense sense = this.readSense(line, includeGloss, canonicalStrings);
            senseMap.put(sense.getOffset(), sense);
        }
        reader.close();
    }

    public Sense readSense(String line, boolean includeGloss, Map<String, String> canonicalStrings) {
        int barIndex = line.indexOf(124);
        String preBar = line.substring(0, barIndex);
        String gloss = line.substring(barIndex + 2);
        String[] glossTerms = null;
        if (!includeGloss) {
            gloss = null;
        } else {
            String[] terms = gloss.replaceAll("[^\\w]", " ").split("\\s+");
            glossTerms = new String[terms.length];
            for (int i = 0; i < terms.length; ++i) {
                String term = terms[i];
                String canonicalVersion = canonicalStrings.get(term);
                if (canonicalVersion == null) {
                    canonicalVersion = term;
                    canonicalStrings.put(term, canonicalVersion);
                }
                glossTerms[i] = term = canonicalVersion;
            }
        }
        String[] split = preBar.split("\\s+");
        int offset = Integer.parseInt(split[0]);
        byte lexfilenum = Byte.parseByte(split[1]);
        POS sensePOS = STRING_TO_POS.get(split[2]);
        int wordCount = Byte.parseByte(split[3], 16);
        List[] lexPointers = new List[wordCount];
        for (int i = 0; i < wordCount; ++i) {
            lexPointers[i] = new LinkedList();
        }
        Sense.Key[] keys = new Sense.Key[wordCount];
        for (int i = 0; i < wordCount; ++i) {
            String canonicalVersion;
            String word = split[4 + 2 * i];
            byte lexid = Byte.parseByte(split[4 + 2 * i + 1], 16);
            if (word.endsWith(")")) {
                if (word.endsWith("(a)") || word.endsWith("(p)")) {
                    word = word.substring(0, word.length() - 3);
                } else if (word.endsWith("(ip)")) {
                    word = word.substring(0, word.length() - 4);
                }
            }
            if ((canonicalVersion = canonicalStrings.get(word)) == null) {
                canonicalVersion = word;
                canonicalStrings.put(word, canonicalVersion);
            }
            word = canonicalVersion;
            keys[i] = new Sense.Key(this, word, lexid, sensePOS);
        }
        int pointerCount = Integer.parseInt(split[4 + wordCount * 2]);
        int firstPointer = 4 + wordCount * 2 + 1;
        LinkedList<SemPointer> semPointers = new LinkedList<SemPointer>();
        HashSet<PointerType> lexPointerTypes = new HashSet<PointerType>();
        for (int i = 0; i < pointerCount; ++i) {
            String pointerSymbol = split[firstPointer + 4 * i];
            PointerType pointerType = Pointers.STRING_TO_POINTER_TYPE.get(pointerSymbol);
            int synsetOffset = Integer.parseInt(split[firstPointer + 4 * i + 1]);
            POS targetPOS = STRING_TO_POS.get(split[firstPointer + 4 * i + 2]);
            String sourceTarget = split[firstPointer + 4 * i + 3];
            byte source = Byte.parseByte(sourceTarget.substring(0, 2), 16);
            byte target = Byte.parseByte(sourceTarget.substring(2, 4), 16);
            if (source == 0) {
                if (target == 0) {
                    semPointers.add(new SemPointer(this, synsetOffset, pointerType, targetPOS));
                    continue;
                }
                System.err.println(this.getClass().getCanonicalName() + " says EEEEEEEEEEEEEEEEEK");
                continue;
            }
            source = (byte)(source - 1);
            target = (byte)(target - 1);
            LinkedList<LexPointer> pointers = lexPointers[source];
            if (pointers == null) {
                lexPointers[source] = pointers = new LinkedList<LexPointer>();
            }
            pointers.add(new LexPointer(this, synsetOffset, pointerType, targetPOS, source, target));
            lexPointerTypes.add(pointerType);
        }
        int frameIndex = 4 + wordCount * 2 + 4 * pointerCount + 1;
        if (split.length > frameIndex) {
            int numFrames = Integer.parseInt(split[frameIndex]);
            for (int i = 0; i < numFrames; ++i) {
                int frameNum = Integer.parseInt(split[frameIndex + i * 3 + 2]);
                int wordNum = Integer.parseInt(split[frameIndex + i * 3 + 3], 16);
                if (wordNum == 0) {
                    for (Sense.Key key : keys) {
                        key.addFrame(frameNum);
                    }
                    continue;
                }
                keys[wordNum - 1].addFrame(frameNum);
            }
        }
        LexPointer[][] lPointers = new LexPointer[wordCount][];
        for (int i = 0; i < wordCount; ++i) {
            lPointers[i] = lexPointers[i].toArray(new LexPointer[0]);
        }
        return new Sense(offset, gloss, glossTerms, lexfilenum, sensePOS, keys, lPointers, semPointers.toArray(new SemPointer[0]));
    }

    static {
        INTEGER_TO_POS = new HashMap<Integer, POS>();
        STRING_TO_POS = new HashMap<String, POS>();
        STRING_TO_POS.put("n", POS.NOUN);
        STRING_TO_POS.put("v", POS.VERB);
        STRING_TO_POS.put("a", POS.ADJECTIVE);
        STRING_TO_POS.put("s", POS.ADJECTIVE);
        STRING_TO_POS.put("r", POS.ADVERB);
        INTEGER_TO_POS.put(1, POS.NOUN);
        INTEGER_TO_POS.put(2, POS.VERB);
        INTEGER_TO_POS.put(3, POS.ADJECTIVE);
        INTEGER_TO_POS.put(4, POS.ADVERB);
        INTEGER_TO_POS.put(5, POS.ADJECTIVE);
    }
}

