/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.mallet.base.pipe;

import edu.umass.cs.mallet.base.pipe.Pipe;
import edu.umass.cs.mallet.base.pipe.TokenSequence2FeatureVectorSequence;
import edu.umass.cs.mallet.base.types.Alphabet;
import edu.umass.cs.mallet.base.types.Instance;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class SerialPipes
extends Pipe
implements Serializable {
    ArrayList pipes;
    static boolean suppressExceptions = true;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    public SerialPipes() {
        this.pipes = new ArrayList();
    }

    public SerialPipes(Object[] pipes) {
        this((Pipe[])pipes);
    }

    public SerialPipes(Pipe[] pipes) {
        this.pipes = new ArrayList(pipes.length);
        int i = 0;
        while (i < pipes.length) {
            this.add(pipes[i]);
            ++i;
        }
    }

    public SerialPipes(List pipeList) {
        this.pipes = new ArrayList(pipeList.size());
        for (Pipe pipe : pipeList) {
            this.add(pipe);
        }
    }

    public ArrayList getPipes() {
        return this.pipes;
    }

    public static boolean isSuppressExceptions() {
        return suppressExceptions;
    }

    public static void setSuppressExceptions(boolean suppressExceptions) {
        SerialPipes.suppressExceptions = suppressExceptions;
    }

    public void setTargetProcessing(boolean lookForAndProcessTarget) {
        super.setTargetProcessing(lookForAndProcessTarget);
        int i = 0;
        while (i < this.pipes.size()) {
            ((Pipe)this.pipes.get(i)).setTargetProcessing(lookForAndProcessTarget);
            ++i;
        }
    }

    protected Alphabet resolveDataAlphabet() {
        if (this.dataAlphabetResolved) {
            throw new IllegalStateException("Alphabet already resolved.");
        }
        if (this.parent != null) {
            this.dataDict = this.parent.dataDict;
        }
        int i = 0;
        while (i < this.pipes.size()) {
            Alphabet fd;
            this.dataDict = fd = ((Pipe)this.pipes.get(i)).resolveDataAlphabet();
            ++i;
        }
        this.dataAlphabetResolved = true;
        return this.dataDict;
    }

    protected Alphabet resolveTargetAlphabet() {
        if (this.targetAlphabetResolved) {
            throw new IllegalStateException("Target Alphabet already resolved.");
        }
        if (this.parent != null) {
            this.targetDict = this.parent.targetDict;
        }
        int i = 0;
        while (i < this.pipes.size()) {
            Alphabet ld;
            this.targetDict = ld = ((Pipe)this.pipes.get(i)).resolveTargetAlphabet();
            ++i;
        }
        this.targetAlphabetResolved = true;
        return this.targetDict;
    }

    protected void add(Pipe pipe) {
        if (this.dataAlphabetResolved || this.targetAlphabetResolved) {
            throw new IllegalStateException("Cannot add to SerialPipes after dictionaries are resolved.");
        }
        pipe.setParent(this);
        this.pipes.add(pipe);
    }

    public Instance pipe(Instance carrier, int startingIndex) {
        int i = startingIndex;
        while (i < this.pipes.size()) {
            block5: {
                Pipe p = (Pipe)this.pipes.get(i);
                if (p == null) {
                    System.err.println("Pipe is null");
                } else {
                    try {
                        carrier = p.pipe(carrier);
                    }
                    catch (Exception e) {
                        System.err.println("Exception on pipe " + i + ". " + e);
                        e.printStackTrace(System.err);
                        if (suppressExceptions) break block5;
                        throw new RuntimeException(e);
                    }
                }
            }
            ++i;
        }
        return carrier;
    }

    public Instance pipe(Instance carrier, int startingIndex, boolean growAlphabet) {
        int i = startingIndex;
        while (i < this.pipes.size()) {
            Pipe p = (Pipe)this.pipes.get(i);
            if (p == null) {
                System.err.println("Pipe is null");
            } else {
                try {
                    if (p instanceof TokenSequence2FeatureVectorSequence) {
                        ((TokenSequence2FeatureVectorSequence)p).setGrowAlphabet(false);
                    }
                    carrier = p.pipe(carrier);
                }
                catch (Exception e) {
                    System.err.println("Exception on pipe " + i + ". " + e);
                }
            }
            ++i;
        }
        return carrier;
    }

    public void removePipe(int index) {
        try {
            this.pipes.remove(index);
        }
        catch (Exception e) {
            System.err.println("Error removing pipe. Index = " + index + ".  " + e.getMessage());
        }
    }

    public void replacePipe(int index, Pipe p) {
        try {
            this.pipes.set(index, p);
        }
        catch (Exception e) {
            System.err.println("Error replacing pipe. Index = " + index + ".  " + e.getMessage());
        }
    }

    public int size() {
        return this.pipes.size();
    }

    public Pipe getPipe(int index) {
        Pipe retPipe = null;
        try {
            retPipe = (Pipe)this.pipes.get(index);
        }
        catch (Exception e) {
            System.err.println("Error getting pipe. Index = " + index + ".  " + e.getMessage());
        }
        return retPipe;
    }

    public Instance pipe(Instance carrier) {
        return this.pipe(carrier, 0);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.pipes.size()) {
            sb.append(String.valueOf(((Pipe)this.pipes.get(i)).toString()) + ",");
            ++i;
        }
        return sb.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
        out.writeObject(this.pipes);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.pipes = (ArrayList)in.readObject();
    }
}

