/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.mallet.base.minimize;

import edu.umass.cs.mallet.base.minimize.LineMinimizer;
import edu.umass.cs.mallet.base.minimize.Minimizable;
import edu.umass.cs.mallet.base.types.Matrix;
import edu.umass.cs.mallet.base.util.MalletLogger;
import java.util.logging.Logger;

public class BackTrackLineSearch
implements LineMinimizer {
    private static Logger logger = MalletLogger.getLogger(BackTrackLineSearch.class.getName());
    final int maxIterations = 100;
    final double stpmax = 100.0;
    final double EPS = 3.0E-8;
    final double TOLX = 1.0E-10;
    final double ALF = 1.0E-4;

    public double minimize(Minimizable function, Matrix line, double initialStep) {
        double slope;
        double fold;
        Matrix oldParameters = function.getNewMatrix();
        function.getParameters(oldParameters);
        Matrix x = (Matrix)oldParameters.cloneMatrix();
        Matrix g = function.getNewMatrix();
        double tmplam = 0.0;
        double alam2 = 0.0;
        double f2 = fold = function.getCost();
        logger.fine("Entering BackTrackLnSrch, cost=" + fold);
        g = ((Minimizable.ByGradient)function).getCostGradient(g);
        assert (!g.isNaN());
        double sum = line.twoNorm();
        if (sum > 100.0) {
            logger.fine("attempted step too big. scaling: sum=" + sum + ", stpmax=" + 100.0);
            line.timesEquals(100.0 / sum);
        }
        double newSlope = slope = g.dotProduct(line);
        logger.fine("slope=" + slope);
        assert (slope <= 0.0) : "slope:" + slope;
        double test = 0.0;
        int singleSize = oldParameters.singleSize();
        int i = 0;
        while (i < singleSize) {
            double temp = Math.abs(line.singleValue(i)) / Math.max(Math.abs(oldParameters.singleValue(i)), 1.0);
            if (temp > test) {
                test = temp;
            }
            ++i;
        }
        double alamin = 1.0E-10 / test;
        double alam = 1.0;
        double oldAlam = 0.0;
        int iteration = 0;
        iteration = 0;
        while (iteration < 100) {
            logger.fine("BackTrack loop iteration " + iteration + ": current step size=" + alam + " old step size=" + oldAlam);
            assert (alam != oldAlam) : "alam == oldAlam";
            x.plusEquals(line, alam - oldAlam);
            function.setParameters(x);
            oldAlam = alam;
            double f = function.getCost();
            logger.fine("cost=" + f);
            if (alam < alamin) {
                logger.info("Jump too small. Exiting BackTrackLineSearch. Cost=" + f + ", step = " + alam);
                function.setParameters(oldParameters);
                return 1.0;
            }
            if (f <= fold + 1.0E-4 * alam * slope) {
                logger.info("Exiting backtrack: cost=" + f + ", step=" + alam);
                assert (f <= fold);
                return 0.0;
            }
            if (alam == 1.0) {
                tmplam = -slope / (2.0 * (f - fold - slope));
            } else {
                double disc;
                double rhs1 = f - fold - alam * slope;
                double rhs2 = f2 - fold - alam2 * slope;
                assert (alam - alam2 != 0.0) : "FAILURE: dividing by alam-alam2=" + (alam - alam2);
                double a = (rhs1 / (alam * alam) - rhs2 / (alam2 * alam2)) / (alam - alam2);
                double b = (-alam2 * rhs1 / (alam * alam) + alam * rhs2 / (alam2 * alam2)) / (alam - alam2);
                tmplam = a == 0.0 ? -slope / (2.0 * b) : ((disc = b * b - 3.0 * a * slope) < 0.0 ? 0.5 * alam : (b <= 0.0 ? (-b + Math.sqrt(disc)) / (3.0 * a) : -slope / (b + Math.sqrt(disc))));
                if (tmplam > 0.5 * alam) {
                    tmplam = 0.5 * alam;
                }
            }
            alam2 = alam;
            f2 = f;
            logger.fine("tmplam:" + tmplam);
            alam = Math.max(tmplam, 0.1 * alam);
            ++iteration;
        }
        if (iteration >= 100) {
            throw new IllegalStateException("Too many iterations.");
        }
        return 0.0;
    }
}

