/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.data;

import java.util.ArrayList;
import net.didion.jwnl.JWNL;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.Pointer;
import net.didion.jwnl.data.PointerTarget;
import net.didion.jwnl.data.Synset;

public class Word
extends PointerTarget {
    static final long serialVersionUID = 8591237840924027785L;
    private Synset _synset;
    private int _index;
    private String _lemma;
    private transient String _cachedToString = null;

    public Word(Synset synset, int n, String string) {
        this._synset = synset;
        this._index = n;
        this._lemma = string;
    }

    public boolean equals(Object object) {
        return object instanceof Word && ((Word)object).getSynset().equals(this.getSynset()) && ((Word)object).getIndex() == this.getIndex();
    }

    public int hashCode() {
        return this.getSynset().hashCode() ^ this.getIndex();
    }

    public String toString() {
        if (this._cachedToString == null) {
            Object[] objectArray = new Object[]{this.getPOS(), this.getLemma(), this.getSynset(), new Integer(this.getIndex())};
            this._cachedToString = JWNL.resolveMessage("DATA_TOSTRING_005", objectArray);
        }
        return this._cachedToString;
    }

    public Synset getSynset() {
        return this._synset;
    }

    public POS getPOS() {
        return this._synset.getPOS();
    }

    public int getIndex() {
        return this._index;
    }

    public String getLemma() {
        return this._lemma;
    }

    public Pointer[] getPointers() {
        Pointer[] pointerArray = this.getSynset().getPointers();
        ArrayList<Pointer> arrayList = new ArrayList<Pointer>(pointerArray.length);
        int n = 0;
        while (n < pointerArray.length) {
            Pointer pointer = pointerArray[n];
            if (this.equals(pointer.getSource())) {
                arrayList.add(pointer);
            }
            ++n;
        }
        return arrayList.toArray(new Pointer[arrayList.size()]);
    }
}

