/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent;

import java.io.File;
import java.io.FileReader;
import java.text.DecimalFormat;
import opennlp.maxent.BasicContextGenerator;
import opennlp.maxent.BasicEventStream;
import opennlp.maxent.ContextGenerator;
import opennlp.maxent.PlainTextByLineDataStream;
import opennlp.model.Event;
import opennlp.model.GenericModelReader;
import opennlp.model.MaxentModel;
import opennlp.model.RealValueFileEventStream;

public class ModelApplier {
    MaxentModel _model;
    ContextGenerator _cg = new BasicContextGenerator(",");
    int counter = 1;
    public static final DecimalFormat ROUNDED_FORMAT = new DecimalFormat("0.000");

    public ModelApplier(MaxentModel maxentModel) {
        this._model = maxentModel;
    }

    private void eval(Event event) {
        this.eval(event, false);
    }

    private void eval(Event event, boolean bl) {
        double[] dArray;
        String string = event.getOutcome();
        String[] stringArray = event.getContext();
        if (!bl) {
            dArray = this._model.eval(stringArray);
        } else {
            float[] fArray = RealValueFileEventStream.parseContexts(stringArray);
            dArray = this._model.eval(stringArray, fArray);
        }
        int n = 0;
        for (int i = 1; i < dArray.length; ++i) {
            if (!(dArray[i] > dArray[n])) continue;
            n = i;
        }
        String string2 = this._model.getOutcome(n);
        String string3 = "+";
        if (string2.equals(string)) {
            string3 = "";
        }
        System.out.println(this.counter + "\t0:" + string + "\t0:" + this._model.getOutcome(n) + "\t" + string3 + "\t" + ROUNDED_FORMAT.format(dArray[n]));
        ++this.counter;
    }

    private static void usage() {
        System.err.println("java ModelApplier [-real] modelFile dataFile");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        String string = "maxent";
        int n = 0;
        if (stringArray.length > 0) {
            Object object;
            while (stringArray[n].startsWith("-")) {
                if (stringArray[n].equals("-real")) {
                    bl = true;
                } else if (stringArray[n].equals("-perceptron")) {
                    string = "perceptron";
                } else {
                    ModelApplier.usage();
                }
                ++n;
            }
            String string2 = stringArray[n++];
            String string3 = stringArray[n++];
            ModelApplier modelApplier = null;
            try {
                object = new GenericModelReader(new File(string2)).getModel();
                modelApplier = new ModelApplier((MaxentModel)object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(0);
            }
            System.out.println("=== Predictions on test data ===\n");
            System.out.println(" inst#     actual  predicted error prediction");
            try {
                object = new BasicEventStream(new PlainTextByLineDataStream(new FileReader(new File(string3))), ",");
                while (object.hasNext()) {
                    modelApplier.eval(object.next(), bl);
                }
                return;
            }
            catch (Exception exception) {
                System.out.println("Unable to read from specified file: " + string2);
                System.out.println();
                exception.printStackTrace();
            }
        }
    }
}

