/*
 * Decompiled with CFR 0.152.
 */
package tratz.types;

import java.io.Serializable;
import java.util.Arrays;

public class IntArrayList
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int[] mData;
    private int mLength;

    public IntArrayList() {
        this(10);
    }

    public IntArrayList(int size) {
        this.mData = new int[size];
    }

    public void add(int b) {
        this.expandIfNecessary(this.mData, this.mLength);
        this.mData[this.mLength++] = b;
    }

    private void expandIfNecessary(int[] data, int neededLength) {
        if (data.length == neededLength) {
            int newSize = data.length * 3 / 2 + 1;
            int[] newData = new int[newSize];
            System.arraycopy(data, 0, newData, 0, data.length);
            this.mData = newData;
        }
    }

    public int[] getData() {
        return this.mData;
    }

    public int[] toCompactArray() {
        int[] result = new int[this.mLength];
        System.arraycopy(this.mData, 0, result, 0, this.mLength);
        return result;
    }

    public int get(int i) {
        return this.mData[i];
    }

    public void set(int i, int b) {
        this.mData[i] = b;
    }

    public int size() {
        return this.mLength;
    }

    public void clear() {
        this.mLength = 0;
    }

    public void sort() {
        Arrays.sort(this.mData, 0, this.mLength);
    }
}

