/*
 * Decompiled with CFR 0.152.
 */
package tratz.runpipe.impl.annotators.sentence;

import java.text.BreakIterator;
import java.util.List;
import java.util.Map;
import tratz.runpipe.Annotation;
import tratz.runpipe.TextDocument;
import tratz.runpipe.annotations.Sentence;
import tratz.runpipe.impl.AnnotatorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BreakIteratorSentenceAnnotator
extends AnnotatorImpl {
    public static final String ONLY_WHEN_NECESSARY = "ONLY_WHEN_NECESSARY";
    private boolean mOnlyWhenNecessary;

    @Override
    public void initialize(Map<String, String> params) {
        String result = params.get(ONLY_WHEN_NECESSARY);
        if (result != null) {
            this.mOnlyWhenNecessary = Boolean.parseBoolean(result);
        }
    }

    @Override
    public void process(TextDocument doc) {
        List<? extends Annotation> sentences = doc.getAnnotationList(Sentence.class);
        if (!this.mOnlyWhenNecessary || sentences == null) {
            BreakIterator sentenceIterator = BreakIterator.getSentenceInstance();
            sentenceIterator.setText(doc.getText());
            int start = sentenceIterator.first();
            int end = sentenceIterator.next();
            while (end != -1) {
                doc.addAnnotation(new Sentence(doc, start, end));
                start = end;
                end = sentenceIterator.next();
            }
        }
    }
}

