/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.mallet.base.types;

import edu.umass.cs.mallet.base.types.Alphabet;
import edu.umass.cs.mallet.base.types.AugmentableFeatureVector;
import edu.umass.cs.mallet.base.types.ConstantMatrix;
import edu.umass.cs.mallet.base.types.FeatureConjunction;
import edu.umass.cs.mallet.base.types.FeatureSelection;
import edu.umass.cs.mallet.base.types.FeatureSequence;
import edu.umass.cs.mallet.base.types.SparseVector;
import edu.umass.cs.mallet.base.util.MalletLogger;
import edu.umass.cs.mallet.base.util.PropertyList;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.logging.Logger;

public class FeatureVector
extends SparseVector
implements Serializable {
    private static Logger logger = MalletLogger.getLogger(FeatureVector.class.getName());
    Alphabet dictionary;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    protected FeatureVector(Alphabet dict, int[] indices, double[] values, int capacity, int size, boolean copy, boolean checkIndicesSorted, boolean removeDuplicates) {
        super(indices, values, capacity, size, copy, checkIndicesSorted, removeDuplicates);
        this.dictionary = dict;
    }

    public FeatureVector(Alphabet dict, double[] values) {
        super(values);
        this.dictionary = dict;
    }

    public FeatureVector(Alphabet dict, int[] featureIndices, double[] values) {
        super(featureIndices, values);
        this.dictionary = dict;
    }

    public FeatureVector(Alphabet dict, int[] featureIndices) {
        super(featureIndices);
        this.dictionary = dict;
    }

    public static int[] getObjectIndices(Object[] entries, Alphabet dict, boolean addIfNotPresent) {
        int[] feats = new int[entries.length];
        int i = 0;
        while (i < entries.length) {
            feats[i] = dict.lookupIndex(entries[i], addIfNotPresent);
            if (feats[i] == -1) {
                throw new IllegalArgumentException("Object is not in dictionary.");
            }
            ++i;
        }
        return feats;
    }

    public FeatureVector(Alphabet dict, Object[] keys, double[] values) {
        this(dict, FeatureVector.getObjectIndices(keys, dict, true), values);
    }

    private static int[] sortedFeatureIndexSequence(FeatureSequence fs) {
        int[] feats = fs.toFeatureIndexSequence();
        Arrays.sort(feats);
        return feats;
    }

    public FeatureVector(FeatureSequence fs, boolean binary) {
        super(fs.toSortedFeatureIndexSequence(), false, false, true, binary);
        this.dictionary = fs.getAlphabet();
    }

    public FeatureVector(FeatureSequence fs) {
        this(fs, false);
    }

    public FeatureVector(Alphabet dict, PropertyList pl, boolean binary, boolean growAlphabet) {
        super(dict, pl, binary, growAlphabet);
        this.dictionary = dict;
    }

    public FeatureVector(Alphabet dict, PropertyList pl, boolean binary) {
        this(dict, pl, binary, true);
    }

    private static int[] indicesWithConjunctions(FeatureVector fv, Alphabet newVocab, int[] conjunctions) {
        int j;
        assert (fv.values == null);
        assert (!(fv instanceof AugmentableFeatureVector));
        Alphabet v = fv.getAlphabet();
        assert (v.size() <= newVocab.size()) : "fv.vocab.size=" + v.size() + " newVocab.size=" + newVocab.size();
        int[] newIndices = new int[fv.indices.length * conjunctions.length];
        Arrays.sort(conjunctions);
        System.arraycopy(fv.indices, 0, newIndices, 0, fv.indices.length);
        int size = fv.indices.length;
        int ci = 0;
        int i = 0;
        while (i < fv.indices.length) {
            if (ci < conjunctions.length && conjunctions[ci] < fv.indices[i]) {
                ++ci;
            }
            if (conjunctions[ci] == fv.indices[i]) {
                j = 0;
                while (j < fv.indices.length) {
                    if (conjunctions[ci] != fv.indices[j]) {
                        int index = newVocab.lookupIndex(FeatureConjunction.getName(v, conjunctions[ci], fv.indices[j]));
                        if (index == newVocab.size() - 1 && index % 3 == 0) {
                            logger.info("New feature " + newVocab.lookupObject(index));
                        }
                        if (index != -1) {
                            newIndices[size++] = index;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        Arrays.sort(newIndices, 0, size);
        i = 1;
        while (i < size) {
            if (newIndices[i - 1] == newIndices[i]) {
                j = i + 1;
                while (j < size) {
                    newIndices[j - 1] = newIndices[j];
                    ++j;
                }
                --size;
            }
            ++i;
        }
        int[] ret = new int[size];
        System.arraycopy(newIndices, 0, ret, 0, size);
        return ret;
    }

    private static int[] indicesWithConjunctions(FeatureVector fv, Alphabet newVocab, FeatureSelection fsNarrow, FeatureSelection fsWide) {
        int j;
        int length;
        assert (fv.values == null);
        Alphabet v = fv.getAlphabet();
        assert (v.size() <= newVocab.size()) : "fv.vocab.size=" + v.size() + " newVocab.size=" + newVocab.size();
        if (fv instanceof AugmentableFeatureVector) {
            length = ((AugmentableFeatureVector)fv).size;
            ((AugmentableFeatureVector)fv).sortIndices();
        } else {
            length = fv.indices.length;
        }
        int[] newIndices = new int[length * length];
        System.arraycopy(fv.indices, 0, newIndices, 0, length);
        int size = length;
        boolean ci = false;
        int i = 0;
        while (i < length) {
            if (fsNarrow == null || fsNarrow.contains(fv.indices[i])) {
                j = 0;
                while (j < length) {
                    int index;
                    if ((fsWide == null || fsWide.contains(fv.indices[j])) && fv.indices[i] != fv.indices[j] && (index = newVocab.lookupIndex(FeatureConjunction.getName(v, fv.indices[i], fv.indices[j]))) != -1) {
                        newIndices[size++] = index;
                    }
                    ++j;
                }
            }
            ++i;
        }
        Arrays.sort(newIndices, 0, size);
        i = 1;
        while (i < size) {
            if (newIndices[i - 1] == newIndices[i]) {
                j = i + 1;
                while (j < size) {
                    newIndices[j - 1] = newIndices[j];
                    ++j;
                }
                --size;
            }
            ++i;
        }
        int[] ret = new int[size];
        System.arraycopy(newIndices, 0, ret, 0, size);
        return ret;
    }

    public FeatureVector(FeatureVector fv, Alphabet newVocab, int[] conjunctions) {
        this(newVocab, FeatureVector.indicesWithConjunctions(fv, newVocab, conjunctions));
    }

    public FeatureVector(FeatureVector fv, Alphabet newVocab, FeatureSelection fsNarrow, FeatureSelection fsWide) {
        this(newVocab, FeatureVector.indicesWithConjunctions(fv, newVocab, fsNarrow, fsWide));
    }

    public ConstantMatrix cloneMatrix() {
        return new FeatureVector(this.dictionary, this.indices, this.values);
    }

    public ConstantMatrix cloneMatrixZeroed() {
        assert (this.values != null);
        if (this.indices == null) {
            return new FeatureVector(this.dictionary, new double[this.values.length]);
        }
        int[] newIndices = new int[this.indices.length];
        System.arraycopy(this.indices, 0, newIndices, 0, this.indices.length);
        return new FeatureVector(this.dictionary, newIndices, new double[this.values.length], this.values.length, this.values.length, false, false, false);
    }

    public String toString() {
        return this.toString(false);
    }

    public boolean toSimpFile(String FileName, int curdocNo, boolean printcounts) {
        int i;
        StringBuffer sb = new StringBuffer();
        if (this.values == null) {
            int indicesLength = this.numLocations();
            i = 0;
            while (i < indicesLength) {
                if (this.dictionary == null) {
                    sb.append("[" + i + "]");
                } else {
                    sb.append(this.dictionary.lookupObject(this.indices[i]).toString());
                }
                sb.append('\n');
                ++i;
            }
        } else {
            int valuesLength = this.numLocations();
            i = 0;
            while (i < valuesLength) {
                int idx;
                int n = idx = this.indices == null ? i : this.indices[i];
                if (this.dictionary == null) {
                    sb.append("[" + i + "]");
                } else {
                    sb.append(String.valueOf(curdocNo) + " " + idx);
                }
                if (printcounts) {
                    sb.append(" " + this.values[i]);
                }
                sb.append("\n");
                ++i;
            }
        }
        String str = sb.toString();
        File myfile = new File(FileName);
        try {
            FileWriter out = new FileWriter(myfile, true);
            out.write(str);
            out.close();
        }
        catch (IOException e) {
            System.err.println("Feature Vector exception when trying to print a file");
        }
        return true;
    }

    public String toString(boolean onOneLine) {
        StringBuffer sb = new StringBuffer();
        if (this.values == null) {
            int indicesLength = this.numLocations();
            int i = 0;
            while (i < indicesLength) {
                if (this.dictionary == null) {
                    sb.append("[" + i + "]");
                } else {
                    sb.append(this.dictionary.lookupObject(this.indices[i]).toString());
                }
                if (!onOneLine) {
                    sb.append('\n');
                } else {
                    sb.append(' ');
                }
                ++i;
            }
        } else {
            int valuesLength = this.numLocations();
            int i = 0;
            while (i < valuesLength) {
                int idx;
                int n = idx = this.indices == null ? i : this.indices[i];
                if (this.dictionary == null) {
                    sb.append("[" + i + "]");
                } else {
                    sb.append(this.dictionary.lookupObject(idx).toString());
                    sb.append("(" + idx + ")");
                }
                sb.append("=");
                sb.append(this.values[i]);
                if (!onOneLine) {
                    sb.append("\n");
                } else {
                    sb.append(' ');
                }
                ++i;
            }
        }
        return sb.toString();
    }

    public Alphabet getAlphabet() {
        return this.dictionary;
    }

    public int location(Object entry) {
        if (this.dictionary == null) {
            throw new IllegalStateException("This FeatureVector has no dictionary.");
        }
        int i = this.dictionary.lookupIndex(entry, false);
        if (i < 0) {
            return -1;
        }
        return this.location(i);
    }

    public boolean contains(Object entry) {
        int loc = this.location(entry);
        return loc >= 0 && this.valueAtLocation(loc) != 0.0;
    }

    public double value(Object o) {
        int loc = this.location(o);
        if (loc >= 0) {
            return this.valueAtLocation(loc);
        }
        throw new IllegalArgumentException("Object " + o + " is not a key in the dictionary.");
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
        out.writeObject(this.dictionary);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.dictionary = (Alphabet)in.readObject();
    }
}

