function w = arwmul(x,v,blk)
% ARWMUL computes w_i = X_i v_i, 1 <= i <= nblk, where X_i = arw(x_i)
%
% w = arwmul(x,v,blk)
%
% Single block case:
% if x = (x0,x1,...,xn) then
%             [ x0 x1 x2 ... xn ]
%             [ x1 x0  0 ...  0 ]
%    arw(x) = [ x2  0 x0 ...  0 ]
%             [      ...        ]
%             [ xn  0  0 ... x0 ]
%
%     = x0*I + e0*xbar^T + xbar*e0^T
% where
%     e0   = (1,0,...,0) of length n+1
%     xbar = (0,x1,...,xn)
%
% input variables:
%     - x         vector of quadratic blocks
%     - v         vector of length n
%     - blk       block structure vector
%
% output variables:
%     - w         vector of length n

% SDPPACK Version 0.9 BETA
% Copyright (c) 1997 by
% F. Alizadeh, J.-P. Haeberly, M. Nayakkankuppam, M.L. Overton, S. Schmieta
% Last modified : 4/20/97
%
 n =length(x);
 nblk = length(blk);
 w = zeros(n,1);
 fin = 0;
 for i = 1:nblk
    start = fin + 1;
    fin = fin + blk(i);
    xtmp = x(start:fin);
    vtmp = v(start:fin);
    wtmp = xtmp(1)*vtmp;
    xtmp(1) = 0;
    wtmp(1) = wtmp(1) + xtmp'*vtmp;
    wtmp = wtmp + vtmp(1)*xtmp;
    w(start:fin) = wtmp;
 end
%
% END function
