function [A,b,C,blk] = import(fname)
% IMPORT  imports SDP data stored in a variant of Nemirovskii's
%         compact form into matlab; see export.m for details about
%         the storage scheme.
%
% [A,b,C,blk] = import(fname)
%
% input variables:
%     - fname     the name of the output file
%
% output variables:
%     - A         matrix of primal constraints
%     - b         rhs of primal constraints
%     - C         cost matrix
%     - blk       block structure vector

% SDPPACK Version 0.8 BETA
% Copyright (c) 1997 by
% F. Alizadeh, J.-P. Haeberly, M. Nayakkankuppam, M.L. Overton
% Last modified: 3/24/97
%
 eval(['load ',fname]);
 for i = 1:length(fname),  % strip extension
    if fname(i) == '.',
      break;
    end;
 end;
 s = fname(1:i-1);
%
 idx = 1;
 eval(['m = ',s,'(idx);']);             % m = # constraints
 idx = idx + 1;
 eval(['nblk = ',s,'(idx);']);          % nblk = # blocks
 idx = idx + 1;
 eval(['sparseblocks = ',s,'(idx);']);  % are blocks sparse?
 idx = idx + 1;
%
 blk = zeros(nblk,1);
 for i = 1:nblk                 % read in block sizes
    eval(['blk(i) = ',s,'(idx);']);
    idx = idx + 1;
 end;
 n = sum(blk);
 nsq = (sum(blk .* (blk+1)))/2;
 if sparseblocks,
    A = sparse(m,nsq);
 else,
    A = zeros(m,nsq);
 end;
 b = zeros(m,1);
%
% make lookup table of starting points of blocks
%
 start(1) = 0;
 for k = 2:nblk,
    start(k) = start(k-1) + blk(k-1);
 end;
%
% get b
%
 for i = 1:m,
    eval(['b(i) = ',s,'(idx);']);
    idx = idx + 1;
 end;
%
% get the matrix C
%
 if nblk > 1 | sparseblocks == 1,
    C = sparse(n,n);
 else,
    C = zeros(n,n);
 end;
 for blkidx = 1:nblk,
    bsize = blk(blkidx);
    ulc = start(blkidx);
    lrc = ulc + bsize;
    ulc = ulc+1;
    if sparseblocks == 1,   % data is in sparse format
       tmpmat = sparse(bsize,bsize);
       eval(['nz = ',s,'(idx);']);  % # nonzeros entries in block blkidx
       idx = idx + 1;
       for k = 1:nz
          eval(['rowidx = ',s,'(idx);']);  % row index
          idx = idx + 1;
          eval(['colidx = ',s,'(idx);']);  % column index
          idx = idx + 1;
          eval(['tmpmat(rowidx,colidx) = ',s,'(idx);']);
          idx = idx + 1;
       end;   % k loop
    else,   % matrix is full
       tmpmat = zeros(bsize,bsize);
       for i = 1:bsize,
          for j = i:bsize
             eval(['tmpmat(i,j) = ',s,'(idx);']);
             idx = idx + 1;
           end;
        end;
    end;  % if sparseblocks
    C(ulc:lrc,ulc:lrc) = tmpmat;  % assign the block to C
 end;   % blkidx loop
%
% now symmetrize C: note that C is currently an upper triangular matrix
%
 d = diag(C);
 C = C - diag(d);
 C = C + C';
 C = C + diag(d);
%
% get the matrices A1,...,Am
%
 for cstridx = 1:m,
    if nblk > 1 | sparseblocks == 1, % data is in sparse format
       Ak = sparse(n,n);             % Ak gets initialized to 0
    else,
       Ak = zeros(n,n);
    end;
    for blkidx = 1:nblk,
       bsize = blk(blkidx);
       ulc = start(blkidx);
       lrc = ulc + bsize;
       ulc = ulc+1;
       if sparseblocks == 1,         % data is in sparse format
          tmpmat = sparse(bsize,bsize);
          eval(['nz = ',s,'(idx);']);
          idx = idx + 1;
          for k = 1:nz
             eval(['rowidx = ',s,'(idx);']);
             idx = idx + 1;
             eval(['colidx = ',s,'(idx);']);
             idx = idx + 1;
             if rowidx < colidx,    % swap indices to get lower triangle
                tmpidx = colidx;
                colidx = rowidx;
                rowidx = tmpidx;
             end;
             eval(['tmpmat(rowidx,colidx) = ',s,'(idx);']);
             idx = idx + 1;
          end;   % k loop
       else,   % matrix is full
          tmpmat = zeros(bsize,bsize);
          for i = 1:bsize,
             for j = i:bsize
                eval(['tmpmat(j,i) = ',s,'(idx);']);
                idx = idx + 1;
             end;
          end;
       end;  % if sparsemat
       Ak(ulc:lrc,ulc:lrc) = tmpmat;
    end;   % blkidx loop
   %
% Note that the matrix Ak currently is a lower triangular matrix.
% There is no need to symmetrize Ak since it will only be fed to svec
% and svec only uses the lower triangular part of its matrix argument.
% Now store Ak in appropriate row of A
%
    A(cstridx,:) = (svec(Ak,blk,sparseblocks))';
 end;   %  cidx loop
%
% END function
