function smax = stepmax(x, d, xbound);
% max t such that ||x + td||_inf <= xbound
%  Written by M. Overton (overton@cs.nyu.edu), last revised March 2003
for k = 1: length(x);
   if d(k) > 0
      t(k) = (xbound - x(k))/d(k);   % positive/positive
   elseif d(k) < 0
      t(k) = (xbound + x(k))/(-d(k));  % positive/positive
   else
      t(k) = inf;
   end
end
smax = min(t);
