function [fbundle,gbundle] = getbundle(x, samprad, N, pars);
% get bundle of N function values and gradients near x
%  Written by M. Overton (overton@cs.nyu.edu), last revised November 2003

m = length(x);
discard = 0;
for k = 1:N
   if k == 1
      % first evaluation is without perturbation
      [f,grad] = feval(pars.fgname, x, pars);
      if f == inf  % should not happen - will be caught earlier
         error('f is infinite in getbundle')
      end
   else
      xpert = x + samprad*(rand(m,1) - 0.5); % uniform distribution
      [f,grad] = feval(pars.fgname, xpert, pars);
      while f == inf  % disallow infinite function values
         discard = discard + 1;
         xpert = (x + xpert)/2;     % contract back until feasible
         [f,grad] = feval(pars.fgname, xpert, pars);
      end
   end;
   fbundle(k) = f;
   gbundle(:,k) = grad;   
end
%%% fprintf('warning: %d gradients were discarded because f was inf', discard)
