function result = funexcludes0(f,B,depthlimit)
    %test if f(B) surely excludes (does not contain) 0
    
    %Work on a regular box copy of B
    B0 = box(B.boxdimensions,B.length0);
    B0.depth = 0;
    
    result = true;
    
    Q = B0;
    
    %Limit on the total number of boxes considered:
    numlimit = inf; %100 %1000 
    
    i = 0;
    while ~isempty(Q) && i<numlimit
        B = Q(1);
        Q(1) = [];
        if B.depth <= depthlimit
            fB = f(B.interval);
            if ~interval.zeros(1).subset(fB) %f(B) excludes 0 (for currently considered B)
                %continue to the remaining boxes
            else %f(B) cannot be said to exclude 0 at this precision
                children = B.split;
                Q = [Q,children];
            end
            i = i+1;
        else %depth limit reached
            result = false; %The test is inconclusive
            return
        end
    end
    if ~isempty(Q) %numlimit reached
        result = false; %The test is inconclusive
        return
    end
    
    %f(B) surely excludes 0
end