/* M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
   (c) 2005 All rights reserved.
   Read Terms of Use at http://mlp-xml.sourceforge.net.
   Contact medical_language_processing@gmail.com
*/
#include <iostream.h>
#include <fstream.h>
#include <setjmp.h>
#include "common.fcm"
#include "nodefs.fcm"
#include "lispdefs.fcm"
#define TRUE 1
#define FALSE 0

extern void asgnat(int,int,int,int,int,int);
extern void freenode(int);
extern int upone(void), down(void), right(void);
extern void exitr(int, const char *);
extern void updateRegisters(void), fixupStacks(void);
extern void treeChanged(void);
extern void longJumpErr(int);
extern void prntif();
extern char *nodnam(int,char*);
/*
 ************************************************************************
    XFMTRE is invoked by operators REPLACE, INSERTBEFORE, and
    INSERTAFTER in function interp to transform the parse tree.  The
    parameter list contains the following information:

       lxr7    points to Node immediately to the left of (if filsw =
               FALSE) or above (if filsw = TRUE) the Node deleted
               or replaced or the point where the transformed
               structure is to be inserted

       rxr7    points to the Node immediately to the right of the Node
               deleted or replaced or the point where the transformed
               structure is to be inserted (= 0 if no node to right)

       filsw   TRUE if the Node deleted or replaced or the top
               leftmost node to be inserted is a first-in-level

       frstxf  points to the top leftmost Node of the transformed
               structure (= 0 if no transformed structure, delete
               operation)

       lastxf  points to the top rightmost Node of the transformed
               structure

       xfwds0[i] points to the entry in the symbol table for the
                   word subsumed by the transformed structure
       xfwds1[i] points to the category list for the word subsumed
                   by the transformed structure

       ixfwds  the number of words subsumed by the transformed
               structure
**********************************************************************
*/

static char * xfwds0[200];
static int xfwds1[200], xfwds2[200];
static char xfwds3[200];
static int ixfwds;
void xfwdsInit(){ ixfwds=0;}
int xfwdsQue(char * nnam, int catagoryList, int selCatList,int idomCnt){
	xfwds0[ixfwds]=nnam;
	xfwds1[ixfwds]=catagoryList;
	xfwds2[ixfwds]=selCatList;
	xfwds3[ixfwds]=idomCnt;
	return ++ixfwds;
}

void xfmtre(int lxr7, int rxr7, int filsw, int frstxf, int lastxf){
	int inc,n,strtw,endw,oldw,pass,imj,jmj;

	if(!lxr7) exitr(19, " *** Subtree badly formed-grammar error");

	while (1){
		if(frstxf) {
			NDUPLF(frstxf)=lxr7;
			NDRTPT(lastxf)=rxr7;
			if(rxr7) NDUPLF(rxr7)=lastxf;
			if(filsw){
				NDBALP(lxr7)=frstxf;
				NDABTS(frstxf)=(NDABTS(frstxf) | FIL);
				if(!(NDNONT(lxr7)))break;// GO TO 1490
				}//if
			else {
				NDRTPT(lxr7)=frstxf;
				NDABTS(frstxf)=(NDABTS(frstxf)&~FIL);
				if(!(NDIDMT(lxr7))) break;//GO TO 1490
				} //else

//         inserting nodes beneath a dummy Node:
//         mark inserted nodes with INDUM flag

			n=frstxf;
//1450 
			do {
				NDABTS(n)=NDABTS(n)|INDUM;
				if(n == lastxf) break;//GO TO 1490
				}while( n=NDRTPT(n));
	
			}//if

		else {
			if(rxr7) NDUPLF(rxr7)=lxr7;

			if(!filsw) NDRTPT(lxr7)=rxr7;
			else {
				if(rxr7) NDABTS(rxr7)=(NDABTS(rxr7)|FIL);
				NDBALP(lxr7)=rxr7;
				} //else
			}//else
		break;
	}//while(1)

//                    transformed structure has been linked into parse
//                    tree.  We must now adjust SENTE to take account 
//                    of words added or deleted by the transformation.

// 		set strtw = word starting transformed structure
//1490
	if(filsw) strtw=NDWPNC(lxr7);
	else strtw=NDWPCP(lxr7);

//                    set endw=(word ending xfmd structure)+1
	if(rxr7) endw=NDWPNC(rxr7);
	else {
		xr7=lxr7;
		if(!filsw) pass= upone();
		endw=NDWPCP(xr7);
		}// else
//cout<<"xformT:strtw "<<strtw<<" endw "<<endw<<" ixfwds "<<endl;// **debug
//                      oldw = no. of words subsumed by deleted structure
	oldw=endw-strtw;
//                      delta = change in length of sentence
	int delta=ixfwds-oldw;
	if(delta){

	if(delta<0) {
//                      sentence shorter, close up SENTE
		for(int i=endw;i<=nwordSent ;i++){
			SENTE1(i+delta)=SENTE1(i);
			SENTE6(i+delta)=SENTE6(i);
			SENTE2(i+delta)=SENTE2(i);
			SENTE3(i+delta)=SENTE3(i);
			}//for
		}//del<0
	else {
// *                     sentence longer, open up SENTE
// check whether there is enough space in the sentence array
	if(nwordSent+delta > MAXNUMOFWORDS){
		prntif();
		*coutP<<"Sentence expansion too large-transf terminated"<<endl;
		longJumpErr(3);
		}
		for(int i=nwordSent;i>=endw;i--){
			SENTE1(i+delta)=SENTE1(i);
			SENTE6(i+delta)=SENTE6(i);
			SENTE2(i+delta)=SENTE2(i);
			SENTE3(i+delta)=SENTE3(i);
			}//for
		} // else
		nwordSent += delta; // mark new sentence length
		wordend = nwordSent;
	}//if delt!=0

// *                     insert words from transformed structure
	for(imj=0, jmj=strtw; imj<ixfwds; imj++, jmj++){
// this is an address
		SENTE1(jmj)=xfwds0[imj];
		SENTE6(jmj)=xfwds3[imj];
		SENTE2(jmj)=xfwds1[imj];
		SENTE3(jmj)=xfwds2[imj];
		}
		ixfwds=0;
/*
     The pointers in each Node to first and last subsumed words must
  now be fixed. The pointers in the transformed structure, which now
  range from 0 to ixfwds, must be changed to strtw through ixfwds+strtw.
  If the total sentence length has been changed, the pointers in nodes
  following the transformed structure must also be fixed.
*/

	if(delta) {// delta != 0
		if(frstxf){ //goto L1560;
			inc=strtw;
			xr7=frstxf;
			do {
int fd=NDWPNC(xr7);
NDWPNC(xr7) += inc;
char nmb[50];
//cout<<"xformT: subsum NC fix node= "<<xr7<<" "<<nodnam(xr7,nmb)<<" from "<<fd<<" to "<<NDWPNC(xr7)<<endl;
}while(down()) ;
			} //if frstxf != 0
		else {// frstxf == 0
			inc=delta;
			if(rxr7){// goto L1560;
				xr7=rxr7;
				do {
int fd=NDWPNC(xr7);
char nmb[50];
NDWPNC(xr7) += inc; 
//cout<<"xfix: subsum NC fix node= "<<xr7<<" "<<nodnam(xr7,nmb)<<" from "<<fd<<" to "<<NDWPNC(xr7)<<endl;

}while(down()) ;
				} // if
			else { xr7=lxr7; pass= upone(); }
			}// else frstxf ==0

		} //if delta !=0

	else {// delta == 0
		if(!frstxf) {//frstxf == 0goto L1580;
			xr7=lxr7;
			return;
			}//if

		xr7=frstxf;
		inc = strtw;
		do {
int fd=NDWPNC(xr7);
char nmb[50];
NDWPNC(xr7) += inc;
//cout<<"xfix:subsum NC fix node= "<<xr7<<" "<<nodnam(xr7,nmb)<<" from "<<fd<<" to "<<NDWPNC(xr7)<<endl;
}while(down()) ;
		} //else delta ==0

	while (1){
		NDWPCP(xr7) += inc;
		if(xr7 == lastxf){
			if(!delta) break;//goto L1580;
			inc = delta;
			}
		if(right()){// goto L1560;
			do {
//cout<<"xform fixing xr7="<<xr7<<endl;
NDWPNC(xr7) += inc; }while(down()) ;
		}
		else
			if(!upone())break;// goto L1565;
		}// while

//               all done, look at first node of XFMD structure
//L1580:
	if(frstxf == 0) xr7=lxr7;
	else xr7=frstxf;
	treeChanged();
	return;
}

// ************************************************************************
// *     XFIXUP updates various tables in the parser to reflect the effect
// *     of the transformation just performed. It is called after each
// *     transformation to the parse tree (to be precise, after each
// *     REPLACE, INSERTBEFORE, and INSERTAFTER operator).

// *          The transformation leaves traces of its effect on the parse
// *     tree as follows:  If a Node has been dropped from the parse tree,
// *     _NDSPFB_ of the Node is set to 0 (this is done by mrkfre). If a
// *     node N is replicated (by the -COPY- operator) to produce nodes
// *     N1, N2, ... , NK, a linked list is established as follows:

// *                  NDGCPS(N)  = N1
// *                  NDGCPS(N1) = N2
// *                            .
// *                            .
// *                            .
// *                  NDGCPS(NK) = 0
// ************************************************************************
#if 0
      INCLUDE 'xcom.fcm'
      INCLUDE 'regstk.fcm'
// *                   STACKS USED BY INTERP
      PARAMETER (LNNDST=20,LNSAVD=1000,LNSTKS=20)
      INTEGER NDSTK(LNNDST,3),SAVED(LNSAVD),STKSTK(LNSTKS)
      COMMON/STACKS/IS,NDSTK,INDSTK,SAVED,ISAVED,STKSTK,ISTKST
      INTEGER TEMP(LNXSTK,2)
#endif

int xstack[10], xlp[10], ixstck;
int xfixup(int deltree){
//	int it,i,itemp,temp1[10], temp2[10];

//         Update transformation stack (XSTACK AND XLP)
//                   if copies N1, ... , Nk are made of a Node N on
//                   xstack, entries are added for nodes N1, ... , Nk all
//                   pointing to the same transformation as the entry for
//                   N. If a Node is deleted which is on xstack, its
//                   entry on xstack is deleted too.

	extern void xformStackFixup();
	xformStackFixup();
#if 0
      for(i=0;i<ixstck;i++){
      temp1[i]=xstack[i];
	temp2[i]=xlp[i];}

      itemp=ixstck;
      ixstck=0;

      for(i=1;i<=itemp;i++){
// *        copy original entry if corresponding node has not been dropped
	it=temp1[i];
	if(!NDSPFB(it)){
		it=NDGCPS(it);
		if(!it)continue;}
		do {
// 20
//CALL ADDCNT (IXSTCK,LNXSTK,'XSTACK',1)
		xstack[ixstck]=it;
		xlp[ixstck++]=temp2[i];
// *     if node has been replicated, add pointers to new nodes to stack
			}while(it=NDGCPS(it));
}
#endif
// 40 CONTINUE
// *        Update Registers
// *
// *                  if the value of a register is a Node which has not
// *                  been deleted, the register is unchanged. If the
// *                  value is a Node n which has been copied to n1,...,nk
// *                  and then deleted, the value of the register is
// *                  changed from n to n1 (the first copy). If the value
// *                  is a Node which has been deleted but not copied, the
// *                  register is marked as undefined.

	updateRegisters();// update registers in the registers object
#if 0
      DO 60 I=1,LCLREG
      if(REGSTK(I,3)==0) THEN
        nd=REGSTK(I,2)
        if(nd) {//THEN
          if(NDSPFB(ND)==0) REGSTK(I,2)=NDGCPS(ND)
        }
      ENDIF
   60 CONTINUE

      DO 70 I=GBLREG,REGLIM
      If(REGSTK(i,3)==0) {//THEN
        nd=REGSTK(i,2);
        If(nd){
		if(NDSPFB(nd)==0) REGSTK(I,2)=NDGCPS(nd);
		}
      }
   70 CONTINUE
#endif
int furet=1;
int fixupNodeAttributes(int);
	if(deltree)furet=fixupNodeAttributes(deltree);
#if 0
int n,nd,ilist;
//  PUT IN NA OBJECT
// *        Update Node Attributes
	int nprev,attrb,val;
	n=NAFLBL(nodatl);
	if(n) {//GO TO 200
	NAFLBL(nodatl)=0;
	NAPRBL(n)=0;
	while(NAFLBL(n)) n=NAFLBL(n);

	while(n) {//GO TO 200
//110
		nprev=NAPRBL(n);
		nd=NAPNPA(n);
		attrb=NANAMA(n);
		val=NAVALA(n);
		ilist=NANDLS(n);
		freenode(n);
int nx=n;
		n=nprev;
			if(NDSPFB(nd) == 0) {
//cout<<"deleted node "<<nd<<" "<<NDGCPS(nd)<<endl;
			nd=NDGCPS(nd);
}
		if(ilist || val <=0) {//GOTO 150

// *                  update Node attribute without value

//120
			while(nd){// GO TO 180
//cout<<"fxNA-NN: from "<<nx<<" nd: "<<nd<<" attrb: "<<attrb<<" val: "<<val
//<<" list: "<<ilist<<endl;
				asgnat(nd,attrb,val,ilist,0,TRUE);
				nd=NDGCPS(nd);
//cout<<"nd=NDGCPS(nd) "<<nd<<endl;
				}
			continue;//go to 180
			}//if
		else { // update node attribute pointing to a node
			if(NDSPFB(val) == 0) {
//cout<<"no val deleted node "<<nd<<" "<<NDGCPS(val)<<endl;
			val=NDGCPS(val);
}

//150
		if(!nd || !val) continue; //go to 180
//160
		while (1){
//cout<<"fxNA-Nod: from "<<nx<<" nd: "<<nd<<" attrb: "<<attrb<<" val: "<<val
//<<" list: "<<ilist<<endl;
			asgnat(nd,attrb,val,ilist,0,TRUE);
			if(NDGCPS(nd) == 0 && NDGCPS(val) == 0) break; 
			if(NDGCPS(nd)) nd=NDGCPS(nd);
			if(NDGCPS(val)) val=NDGCPS(val);
			} //GO TO 160
		}//else

//180
	}// while GO TO 110
	}//if no attrbs
#endif
// *                  update stacks used by interp:
	fixupStacks();
// *                            STACK, SAVED, NDSTK, STKSTK
#if 0
//200
// these are the nodes on the recursive stack
DO 210 I=FPTR+5,IS,5
       not a node item            list
      IF(STACK(I).EQ.0 .OR. STACK(I-1).NE.0) GO TO 210
      IF(NDSPFB(STACK(I)).EQ.0) STACK(I)=NDGCPS(STACK(I))
  210 CONTINUE
// what are these qued recursive stack items
// also register items in the saved environments
      DO 220 I=5,ISAVED,5
       not a node item            list
      IF(SAVED(I).EQ.0 .OR. SAVED(I-1).NE.0) GO TO 220
      IF(NDSPFB(SAVED(I)).EQ.0) SAVED(I)=NDGCPS(SAVED(I))
  220 CONTINUE
// these are the qued requests
      DO 230 I=1,INDSTK
      IF(NDSPFB(NDSTK(I,1)).EQ.0) NDSTK(I,1)=NDGCPS(NDSTK(I,1))
  230 CONTINUE
for(int i=0; i<environSavIdx; i++){
int *ixx = unstackInfo[i].nodeListPtr;
for(int j=0; j< unstackInfo[i].numOfNodes; j++)
if(NDSPFB(*ixx == 0) *(ixx++) = NDGCPS(*ixx);
}// for on i
// these are the not yet qued stacking requests
      DO 240 I=1,ISTKST
      IF(NDSPFB(STKSTK(I)).EQ.0) STKSTK(I)=NDGCPS(STKSTK(I))
  240 CONTINUE
for(i=0,j=0; i<istkst; i++)
      if(NDSPFB(stkstk[i]) == 0){
stkstk[j]=NDGCPS(stkstk[i]);
	if(stkstk[j] != 0)j++;
}
istkst=j;
#endif
extern void clearNDGCPS(void);
clearNDGCPS();
      return furet;
}
// ************************************************************************
// *     XDO IS CALLED BY INTERP PRIOR to the execution of each trans-
// *     formational operator.  IF THE CURRENT TRANSFORMATION IS OPTIONAL,
// *     xdo saves the parse tree before the operator is executed.
// ************************************************************************
extern int xopdun;
void xdo(void){
	if(xopdun==2) return;
	xopdun=2;
#if 0
// *   clear out the NDGCPS so it may be used for linking purposes
//      DO 5 I=1,NDLIM,NDSIZE
//    5 NDGCPS(I)=0
#endif
//    if(!optnlx) return;
//    noptx++;
//    WRITE(UNIT=WKFIL) XLP,IXSTCK,XSTACK,XN,PREV,SENTE,NWORD,NODRAY
//    IF(XTRACE.OR.XTRACR)  PRINT 10, NOPTX
// 10 FORMAT(' --- Parse tree saved (save point ',I2,')')
extern void clearNDGCPS(void);
clearNDGCPS();
      return;
}
#if 0

      ENTRY XUNDO
      BACKSPACE (UNIT=WKFIL)
      READ(UNIT=WKFIL) XLP,IXSTCK,XSTACK,XN,PREV,SENTE,NWORD,NODRAY
      BACKSPACE (UNIT=WKFIL)
      RETURN

      ENTRY XSVTRE
      REWIND WKFIL
      WRITE(UNIT=WKFIL) XN,PREV,NWORD,SENTE,NODRAY
      RETURN

      ENTRY XRETRE
      REWIND WKFIL
      READ(UNIT=WKFIL) XN,PREV,NWORD,SENTE,NODRAY
      RETURN
  900 PRINT*,' ***** System error: XFORM found EOF on unit12'
      END
#endif
