/* M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
   (c) 2005 All rights reserved.
   Read Terms of Use at http://mlp-xml.sourceforge.net.
   Contact medical_language_processing@gmail.com
*/
/*
 ************************************************************************
     XFORM controls the transformational decomposition phase of the
     parser.  It is invoked after a parse is obtained by the parser.
     XFORM in turn invokes INTERP to try the inverse transformations in
     the proper sequence.  This sequencing involves, two
     nested iterations:

        1. The innermost loop is over the transformations associated
     with a single node.  These are housed together with the disqualify
     restrictions on the first option of the definition of the node.
     sequencing begins with the first transformation associated with
     the node.  If the transformation is successful control passes to
     the next transformation for this node (if a TRANSFORM operator was
     executed in the transformation, this sequence will be interrupted;
     see 2.). xstack(ixstck) contains the current node, and xlp(ixstck)
     points to the current element in the list of transformations.

        2. The outer loop is over nodes whose transformations are to
     be tried.  XFORM begins by executing the transformations on the
     root node.  These transformations may in turn specify (with the
     -TRANSFORM- operator) that the transformations on lower nodes are
     to be executed;  this process may be repeated to several levels of
     nesting.  XFORM always executes the transformations on the node
     most recently specified in a -TRANSFORM- operator.  When these
     transformations have all been successfully executed, control
     returns to the previously current node, continuing with the
     transformation following the last one executed.  When all
     transformations on the root node have been successfully
     executed, the transformational decomposition is complete
     and the kernels can be printed.  The previously current nodes
     are stacked in -XSTACK-, whose height is in -IXSTCK-.

     XFORM returns TRUE it it succeeds.

     'xltr' selects the transformations to be executed: only
     transformations whose name begins with the letter 'xltr' are
     executed.
 ************************************************************************
*/

int fixct =0 ;// **debug
#include <iostream.h>
#include <fstream.h>
#include <string.h>
#include "common.fcm"
#include "lispdefs.fcm"
#include "nodefs.fcm"
#include "symtab.h"
#include "returncodes.h"

extern void errmgp(int,int,int,int);
extern void longJumpErr(int);
extern void prnt(void),fill(const char *);
extern char * nodnam(int, char *);
extern int interp(int,int,char *, int);
extern void prntif(void);
extern void plistnn(int,int,int);
extern void treeDraw(int, int);
extern void ptree(int);
extern void outpud(int, int, int, int);
int xopdun=0;

#define TRUE 1
#define FALSE 0
extern SymbTable sytab;
extern char *subsum(int,char *);

static int ixstck,ixstckStart, treeChangedFlag;
struct xformStkStr{int xstack; int xlp;};
#define TRANSFORMSTACKSIZE 250
static xformStkStr xformarr[TRANSFORMSTACKSIZE];

int stackXform(int stacknode){
	if(ixstck> TRANSFORMSTACKSIZE-2){
		longJumpErr(LJR_TRANSSTACKOVER);
		*coutP<<"Transform stack overflow"<<endl;
		return 0;
		}
	xformarr[++ixstck].xstack=stacknode;
	xformarr[ixstck].xlp=0;
//cout<<"\n stackxform: "<<ixstck<<" "<<stacknode<<endl;// **debug
	if(xopdun<1)xopdun=1;
	return 1;
}

void treeChanged(){
	treeChangedFlag=1;
	}

void deactXform(){
	for(int i=ixstckStart; i<ixstck; i++){
		xformarr[i].xstack=xformarr[i+1].xstack;
		xformarr[i].xlp=xformarr[i+1].xlp;
		if(xopdun<1)xopdun=1;
	}
	ixstck--;
	return;
}

void xformStackFixup(){
	struct xformStkStr *xformtmpP ;
	xformtmpP = new xformStkStr[500];
	struct xformStkStr *xformtmpmv=xformtmpP;
	int itmp=0;
	for(int i=0; i<=ixstck; i++){
// *     if node has been replicated, add pointers to new nodes to stack
// *     copy original entry if corresponding Node has not been dropped
		int it = xformarr[i].xstack;
		if(NDSPFB(it)){ // not deleted - retain on to be returned list
			xformtmpmv->xstack=it;
			(xformtmpmv++)->xlp=xformarr[i].xlp;
			itmp++;
			}
//cout<<"stkfixup: node "<<it<<" being deleted"<<endl;// **debug
		while((it=NDGCPS(it))!=0) {
			xformtmpmv->xstack=it;
			(xformtmpmv++)->xlp=xformarr[i].xlp;
			itmp++;
			}// while
		}//for

// copy fixed up array from temp area to the usual array
	xformtmpmv=xformtmpP;
	ixstck = --itmp;
fixct++;// **debug
if(fixct>133){// **debug
int a=1;// **debug
}// **debug
	for(int iv = 0; iv<=ixstck; iv++) xformarr[iv]=*xformtmpmv++;
	delete xformtmpP;
	return;
}

int xform(char xltr, int startNode){
	int resnam,result,xnex;
	int tr;
	int argtrn,shrttr,xr7tr,option1,optnlx;
	char * resnamP;
//                         save parse tree, initialize xstack
//      IF (VERBOS) CALL TIMEIT (0)
	xformarr[0].xstack=startNode;
	xformarr[0].xlp=0;
	ixstck=1;
	xopdun=0;
	shrttr=xtrace && !xtracer;
//                              get first/next xfmn on current Node
//                                A. no current Node, go to V.
//L100:
	while(1) {
	while(ixstck-- > 0){
	xr7tr = xformarr[ixstck].xstack;
//                                B. print header for minimal trace
//char xubbuf[100];// **debug
//if(strcmp(nodnam(xr7tr,xubbuf),"PN")==0){// **debug
//cout<<"xformcont: in assertion"<<endl;// **debug
//}// **debug
{
char subbuf[760];
	if(shrttr) {
        	prntif();
        	fill("Transformations in ");
		fill(nodnam(xr7tr, subbuf));
        	fill(" which subsumes ");
		fill(subsum(xr7tr,subbuf));
		fill(":  ");
		prnt();
		}//if
}

//                                C. if we have already executed some
//                                   xfmns on this node, go to E.
	if(xnex=xformarr[ixstck].xlp)
		xnex=xformarr[ixstck].xlp=CDR(xnex);// get next transformation

	else {
//                            get pointer to list of restrictions and xfrms
//                            (in special field of first option pointer)
		xnex=option1=CDR(NDHDBA(xr7tr));
//                                   1. atomic node -- ignore
		if(option1 != 0) { //  get next transformation
//  L115:
			xnex=xformarr[ixstck].xlp=CSR(option1);
			}
		}//else

	if(!xnex)continue;
// *                            III. execute next xfmn
// *                               A. no more, go to IV.
//  L120
	do {
		argtrn=CAR(xformarr[ixstck].xlp);
		resnam=CAR(argtrn);
		resnamP=STNAME(CAR(argtrn));
// *                       B. skip if first letter of name not 'xltr'
		if(*resnamP != xltr) continue; //goto L115;
		if(CSR(argtrn) & IGNRBT) continue; //goto L115;

// *                       C. print minimal trace or operator trace header
		tr=xtracer || (CSR(argtrn) & RTRBIT);
{
char subbuf[560];
	if(tr) {
        	prntif();
        	plistnn(argtrn,FALSE,PRUNIT);
        	fill(" executed in ");
        	fill(nodnam(xr7tr, subbuf));
        	fill(" which subsumes ");
        	fill(subsum(xr7tr,subbuf));
        	prnt();
		}
	else {
		if(shrttr){
//          COL(PRU)=KOLXTR
          		fill(resnamP);
//          KOLXTR=COL(PRU)
        	}
        }
}
// *                               D. call INTERP to perform xfmn
// L125:
	xopdun=0;
	treeChangedFlag=0;
	argtrn=CDR(argtrn);
	xr7=xr7tr;
	well=TRUE;
	ixstckStart=ixstck; // save stack position at start of transform
//void printSent(int,int,int,int);// **debug
//printSent(1,nwordSent,0,2);// **debug
//cout<<"xformcont before"<<endl;// **debug
//if(tr ) ptree(PRUNIT);// **debug
if(NDSPFB(xr7tr)==0){
*coutP<<"deleted node"<<endl;
}
	result=interp(xr7tr,argtrn,resnamP, tr);
	if(result<0) return result;
	if(tr)prntif();
//                             Print +|-|* for minimal trace
{
	char *m;
	if(!tr && shrttr) {
		if(!result) m = (char *) " - ";
		else {if(treeChangedFlag||xopdun) m= (char *)" * ";
                         else m= (char *) " + "; }
//        COL(PRU)=KOLXTR
		fill(m);
//        KOLXTR=COL(PRU)
		}
}
// *                        F. if xfmn failed, try alternate sequence
	if(!result) { errmgp(4,resnam,xr7,0); return FALSE; }

// *                                  1. print tree if trace is on
//if(tr && treeChangedFlag) printSent(1,nwordSent,0,2);// **debug
	if(tr && treeChangedFlag) ptree(PRUNIT);
	if(xopdun) {//goto L115;
// *                            A TRANSFORM operator was executed
	ixstck++; // ** a fake get rid
		break;
		}
//                                H. get next transformation
	}while(xformarr[ixstck].xlp=CDR(xformarr[ixstck].xlp));
		prntif();
//                             IV. all xfmns on Node have succeeded
//                                 -- return to previously current node
	} // while
//                       V. decomposition complete, print/draw tree
	if(xtresw) {
		*coutP<<"Decomposition Tree:"<<endl;
        	outpud(0, wordstart, wordend, PRUNIT);
		}
	if(xdrwsw) {
		*coutP<<"Decomposition Tree:"<<endl;
        	treeDraw(wordstart, wordend);
		} 
//                             VI. seek alternate path
//                                A. none left, go to VII.
	prntif();
	break; //goto L500;
//                                C. if trace is on, print message
{
	if(xtrace || xtracer) {
		prntif();
		fill(" resuming from save point ");
	char*	m= (char *)"1";//DEC(NOPTX,3)
		fill(m);
		fill(", skipping transformation ");
		argtrn=CAR(xformarr[ixstck].xlp);
		plistnn(argtrn,FALSE,PRUNIT);
		prnt();
		}
}
// *                               D. Skip optional xfmn and keep going
	xr7=xformarr[ixstck].xstack;
//      KOLXTR=5
	}//while  goto L100;
// *                            V. All paths tried, restore tree and return
	*coutP<<" -- All decompositions tried --"<<endl;
//      IF(VERBOS) CALL TIMEIT (1)
 //     PRINT 510
//  510 FORMAT('1')
      return 1;
 //9999
      //return -1;
}
