/* M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
   (c) 2005 All rights reserved.
   Read Terms of Use at http://mlp-xml.sourceforge.net.
   Contact medical_language_processing@gmail.com
*/
#include <iostream.h>
#include <fstream.h>
#include "symtab.h"
#include "common.fcm"
#include "nodefs.fcm"
#include "lispdefs.fcm"
#define FALSE 0
#define TRUE 1

extern SymbTable sytab;
extern int gcons(int,int,int);
extern int odown(void), oleft(void);
extern int oright(void),oupone(void),upone();
extern int getnod(void);
extern int litral(char *);
extern int symbol(char *);
extern int nsymbl(int);
static int t,f,colon,equal,uparow;
extern int trelistr(int,int);
//extern void treListInit(void);
extern int asgnat(int,int,int,int,int,int);

struct NAsetstr{int attrb; int value; short valtyp; int hous;};
extern int getNAfornode(int, struct NAsetstr*, int);
extern int isNAfornode(int);

// -----------------------------------------------------

void treListInit(void){
	t=symbol((char *) "T");
	f=symbol((char *) "F");
	colon=symbol((char *) ":");
	equal=symbol((char *) "=");
	uparow=symbol((char *) "^");
	return;
}

int treeToList(int forms){
      return trelistr(1,forms);
      }

int subttol(int start, int forms){
      return trelistr(start,forms);
      }

/*       
***********************************************************************
     TREETOLIST converts the parse tree into a list structure and 
     returns a pointer to this structure .

          CAR(LISTEX) contains a representation of the tree itself.
     The tree is encoded as:

        (Name-of-root-node  Child-1  Child-2 ... )

     where Child-I is the encoding of the I-th immediate descendant
     node and the subtree it dominates.  An atomic node is encoded as

        (Node-Name = Word-1 Word-2 ... : attribute-list)

     where Word-1, Word-2, ... are the words, if any, subsumed by the node.
     If -forms- =TRUE the list of related word forms is included immediately
     after the attribute list (immediately after the word if it has no
     attribute list), prefixed by an ^, so the structure is:

       (Node-name = Word-1 Word-2 ... : attribute-list ^ forms-list)
      
          CSR(tree) contains a representation of the node attributes of the
    tree. it is a list, each of whose elements has the form

          (Assigned-node [ attribute-name ] value)

     assigned-node is the ordinal (when the tree is scanned in preorder) of
     the node possessing the attribute.  -VALUE- will be the value of the
     attribute or, if the attribute points to a node, The ordinal of the node
     in the parse tree.  If the ordinal of the node which is the value of the
     attribute.  If the node attribute has no value, -Value- will be -T-. 
     If the node attribute was produced by a delete node attribute operation,
     -Value- will be -F-.  The most recently added node attribute will appear
     at the end of list.
***********************************************************************
*/

int trelistr(int start, int forms){
	int ps, sxr7, tree,nal,stsv,abt,chldrn,sib,nm,iw,val,nd,frstwd,n;

//int sss,eee;// **debug
//sss=ig+1;// **debug
//	if(!trlif){trlif=1;treListInit();}
/*
        STEP 1:  Traverse the parse tree right-to-left, bottom-to-top,
                 assigning to each node its corresponding list structure
                 (the pointer to this structure is saved in NDGCPS of each node)
*/

//                     Go to rightmost, deepest descendant
	xr7=start; list=0;
	stsv=NDUPLF(xr7);
	NDUPLF(xr7)=0;
	abt=NDABTS(xr7);
	NDABTS(xr7) |= FIL;

	do {
		while(odown()) { while(oright()); }
//                            nm = name of node

		do {
			nm=NDHDBA(xr7);
			sxr7=xr7;

			chldrn=0;
			if(!(NDATMT(xr7))) {

//                    for non-atomic nodes, set chldrn = list
//                    structure for nodes below current node

				if(odown()) chldrn=NDGCPS(xr7);
				xr7=sxr7;
				} //if
			else {
//                        for atomic nodes, set chldrn =
//                          = words subsumed : attribute list
//                                             ^ forms list
			frstwd=NDWPNC(xr7);
				iw=NDWPCP(xr7);
				chldrn=0;
				if(forms && iw > frstwd)
			chldrn=gcons(gcons(chldrn,0,SENTE3(frstwd)),0,uparow);
		if(NDBALP(xr7)) chldrn=gcons(gcons(chldrn,0,NDBALP(xr7)),0,colon);
				if(iw > frstwd) {
					while(--iw>=frstwd)
					chldrn=gcons(chldrn,0,litral(SENTWD(iw)));

					chldrn=gcons(chldrn,0,equal);
					} //if iw
				} //else

//            sib = list structure for nodes to right of current node

	sib=0;
	if(oright()) sib=NDGCPS(xr7);
	xr7=sxr7;
//                         build list structure for current node
	tree=gcons(sib,0,gcons(chldrn,0,nm));

//                         save pointer to structure in NDGCPS of node
	NDGCPS(xr7)=tree;
//                         process node to left
	if((ps=oleft()))break;
//                         if no nodes to left, go up
	} while(oupone()) ;
	} while(ps); //do

//              step 2:  scan tree in preorder, assigning ordinal
//              to each node (ordinal is saved in NDGCPS of node)

	xr7=start;
	int kount=0;
	ps=1;
	do{
		NDGCPS(xr7)=nsymbl(++kount);
		if(odown()) continue;
		do {
			if(oright()) break;
			}while((ps=oupone()));
		}while(ps);
#if 0
eee=ig;// **debug
cout<<"before node attributes"<<endl;// **debug
int a=433;// **debug
for(int i=sss;i<=eee;i++){// **debug
cout<<i<<"  "<<CDR(i)<<" "<<CSR(i)<<" "<<CAR(i)<<"   "<<i+a<<endl;//
}// **debug
sss=ig+1;// **debug
#endif

//               step 3:  convert node attributes to a list expression

	nal=0;
	xr7=start;
	ps=1;
struct NAsetstr *NAset = new struct NAsetstr[60];
	while(ps){
//get list of node attributes for this node. returns attribute value if any
//and type of value list or node. the return is zero if none there else
//number of nonerased attributes in list.
	int numOfNAs=getNAfornode(xr7,NAset, 60);
	if(numOfNAs){

//         collect and print the node attributes of the current node

		for(int i=0;i<numOfNAs;i++) {

//                 generate printable value for attribute

			int val=NAset[i].value;
			int typ = NAset[i].valtyp ;
if(val==-2)continue;
			if(val == -1){
void printNA(int, const char*);
printNA(xr7,"\nin tree to list");
// val=f;//node erased
int fff=0;
		for(int k=i+1;k<numOfNAs;k++) {
			if(NAset[i].attrb == NAset[k].attrb){
			NAset[k].value=-2;
fff=1;
			break;
			}
			}//for
if(!fff){
*coutP<<"cant find erased node"<<endl;
}
continue;
			}//val = -1
			else {
				if(val == 0 && typ == 0) val=t;//no value
				else {
					if(typ == 0) val=NDGCPS(val);
					}//else
				}//else
			nd=NDGCPS(xr7);// node which has value
			nm=NAset[i].attrb; // name of attribute
      			nal=gcons(nal,0,gcons(val,nm,nd));
			}//for
		}//if

		if(odown()) continue;
		do {
			if(oright()) break;
			} while((ps=oupone()));
		}// while

	delete NAset;
#if 0
eee=ig;// **debug
cout<<"after node attributes"<<endl;// **debug
a=437;// **debug
for(i=sss;i<=eee;i++){// **debug
cout<<i<<"  "<<CDR(i)<<" "<<CSR(i)<<" "<<CAR(i)<<"   "<<i+a<<endl;//
}// **debug
#endif

// *                    Step 4:  clear NDGCPS of each node

	xr7=start;
	ps=1;
	while(ps){
		NDGCPS(xr7)=0;
		if(odown()) continue;

		do {
			if(oright()) break;
			} while((ps=oupone()));
		}// while

	CSR(tree)=nal;
	NDUPLF(xr7)=stsv;
	NDABTS(xr7)=abt;
	return tree;
}

static int T,F,COLON,EQUAL,UPARROW;
extern int upone(void);
extern int getnod(void);
extern SymbTable sytab;
static const char *errMsgArgLtot= "*** Error in argument to listToTree";

       
/*
***********************************************************************
     listToTree builds a parse tree from the list structure pointed to
     by -LISTEX-.  Refer to the comments in TTOL for a description of
     the list structure encoding of the parse tree.
***********************************************************************
*/

static int lpcnt;
int xtotcnt=200;
void exitr(const char *);
int listToTree(int listex, int prevTreeRead){
	int lisx,lvl,prev=0,nintre=0,wordct=1;
	int pass;
	int frstwd,m,ist,ns;
lpcnt=0;
   
//              clear node and sentence arrays
    
//              build parse tree from CAR(listex)
  
	lisx=listex;
	xr7=getnod();
	NDABTS(xr7)=FIL;
	NDWPNC(xr7)=wordct;
	while(1){
lpcnt++;
//if(lpcnt>xtotcnt)exitr("from list2tre");
	NDGCPS(xr7) = lisx;
	lvl=CARADDR(lisx);
	if(ATOMP(lvl)){ *coutP<<errMsgArgLtot<<endl; return FALSE;}
	NDHDBA(xr7) = CAR(lvl);
//if(xr7<20)
//cout<<"node= "<<xr7<<" name  "<<nodnam(xr7)<<" "<<NDHDBA(xr7)<<endl;// **debug
if(!prevTreeRead) NDSPFB(xr7) = CSRINT(CAR(lvl));
else NDSPFB(xr7) = CSRINTGRAM(CAR(lvl));
	if((lisx = CDRADDR(lvl))){
	if(CAR(lisx) != EQUAL){

//                add new node below current node
		ns=getnod();
		NDUPLF(ns)=xr7;
		NDBALP(xr7)=ns;
		NDABTS(ns)=FIL;
		NDWPNC(ns)=wordct;
		xr7=ns;
		continue;
		}//if not EQUAL

	frstwd=wordct;
	if(NDATMT(xr7)== 0) {
		ist=CAR(NDHDBA(xr7));
	*coutP<<"Sentence words specified for non-atomic symbol "
		<<STNAME(ist)<<endl;
		}// 
	else { // add words and attribute list for atomic nod(char *)(char) e
		int nww=0;
		while(lisx=CDR(lisx)) {
			m=CAR(lisx);
			if(m==COLON){
				lisx=CDR(lisx);
				NDBALP(xr7)=CAR(lisx);
				if(!(lisx=CDR(lisx)))break;
				m=CAR(lisx);
		if(m != UPARROW){*coutP<<errMsgArgLtot<<endl; return FALSE;}
				}//COLON

			if(m==UPARROW){
				if(!(lisx=CDR(lisx))){
					*coutP<<errMsgArgLtot<<endl;
					return FALSE;}
				SENTE3(frstwd)=CAR(lisx);
				break;
				}// if UPARROW

			if((CSRINT(m)&(HEAD|LTOMIC))!=(HEAD|LTOMIC))
				{ *coutP<<errMsgArgLtot<<endl; return FALSE;}
// got to fix this
// this symbol should be put into the sentence word bucket and not in
// symbol table remove it from the symbol table
			SENTE1(wordct)=STNAME(CAR(m));
			SENTE2(wordct)=0;
			SENTE3(wordct)=0;
			SENTE6(wordct)=0;
			if(nww==0) nww=wordct;
			SENTE6(nww)++;
//cout<<wordct<<" "<<SENTE1(wordct)<<endl; // **debug
			wordct++;
			}// while
		}//else
	} //if
// 		add node to right of current node
	pass = 1;
	while(pass){
		NDWPCP(xr7)=wordct;
		NDORDC(xr7)=0;
		if((lisx=CDR(NDGCPS(xr7)))) break;
//			no more nodes to right, go up
		pass = upone();
		}// while pass

		if(!pass)break;
		ns=getnod();
		NDUPLF(ns)=xr7;
		NDRTPT(xr7)=ns;
		NDWPNC(ns)=wordct;
		NDABTS(ns)=0;
		xr7=ns;
		} // top level while
    
//               add node attributes from CSRADDR(listex)
   
	int nal = CSRADDR(listex);

	while(nal){
	int nd,nm,val,nodval,ilist;
		lisx=CAR(nal);
		nd=CDRADDR(CAR(lisx));
		nm=CSR(lisx);
		val=CDR(lisx);
//                     nodval=TRUE, if value is an integer
//                     and therefore specifies a node
		nodval=NUMBRP(val);

// 	         if the value is a node, convert integer (ordinal of
//               node in preorder scan of tree) into index into node array
		if(nodval) {
			val=CDR(val);
			ilist=0;
			}//if
		else {
        		if(val==T){ val=0; ilist=0; }
        		else {
				if(val==F){ val=-1; ilist=0;}
				else ilist=1;
				}//else
			}//else
		asgnat(nd,nm,val,ilist,0,TRUE);
		nal=CDR(nal);
		} // while nal
	xr7=1;
	nwordSent=wordct-1;
	return TRUE;
// *      
// 9999 cout "*** Nodes in tree exceed selected limit";
//    return FALSE;
}

void ltotinit(void){
	T=symbol((char *) "T");
	F=symbol((char *) "F");
	COLON=symbol((char *) ":");
	EQUAL=symbol((char *) "=");
	UPARROW=symbol((char *) "^");
	return ;
}
