/* M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
   (c) 2005 All rights reserved.
   Read Terms of Use at http://mlp-xml.sourceforge.net.
   Contact medical_language_processing@gmail.com
*/
#include <limits.h>
#include <sys/times.h>
clock_t tms_utime;
clock_t tms_stime;
clock_t tms_cutime;
clock_t tms_cstime;

class timings {
	private:
		char sentTimeFlag;
		char routineTimeFlag;
		char nodeTimeFlag;
		char extflag;
		int activeRestr;
		int restrTabLen;
		float timeSysSent;
	struct restrTimTable{ int name; int counts; hrtime_t time; hrtime_t routtime;};
	struct restrTimTable *restTableP;
	struct tms *sentTimStStrP;
        struct tms *sentTimEndStrP;

	hrtime_t restrTimStStr;
	hrtime_t restrTimEndStr;
	hrtime_t routineTimStStr;
	hrtime_t routineTimEndStr;


	public:
	timings();
	~timings();
	void timeSentStart(void);
	float timeSentEnd(void);
	float timeSysSentEnd(void);
	void timeRestrInit(void);
	void timeRestrStart(int);
	void timeRestrEnd(int);
	void timeRestrPrint(void);
	void timeRoutineStart(void);
	void timeRoutineEnd(void);
};

