/* M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
   (c) 2005 All rights reserved.
   Read Terms of Use at http://mlp-xml.sourceforge.net.
   Contact medical_language_processing@gmail.com
*/
// #include <string.h>
#include <iostream.h>
#include "timings.h"
#include "symtab.h"
#include <iomanip.h>
#include "lispdefs.fcm"

#define RESTRTIMTABLELEN 350

timings::timings(){
	sentTimeFlag=0;
	routineTimeFlag=0;
	activeRestr=-1;
	nodeTimeFlag=0;
	sentTimStStrP = new struct tms;
        sentTimEndStrP = new struct tms;
}

timings::~timings(){
	delete sentTimStStrP;
        delete sentTimEndStrP;
	if(restTableP) delete restTableP;
}

void timings::timeSentStart(void){
	sentTimeFlag=0;//mark a timing start
	times(sentTimStStrP);
	return;
}

float timings::timeSentEnd(void){
	times(sentTimEndStrP);
	sentTimeFlag=0;//clear a timing start
	timeSysSent = float(((sentTimEndStrP->tms_stime
		-sentTimStStrP->tms_stime)*1000)/CLK_TCK)/1000.;
	return float(((sentTimEndStrP->tms_utime
		-sentTimStStrP->tms_utime)*1000)/CLK_TCK)/1000.;
}

float timings::timeSysSentEnd(void){
	return timeSysSent;
}

void timings::timeRestrInit(void){
	if(!restTableP){
		restTableP = new restrTimTable[RESTRTIMTABLELEN];
		}
	routineTimeFlag = 0;
	activeRestr = -1; //mark no active restriction
	restrTabLen = 0;
	return;
}

//static int rsnn;
void timings::timeRestrStart(int restr){
/*
if(restr==rsnn){
cout<<"start "<<int(restrTimStStr/1000000)<<'\n';
}
*/
	activeRestr = restr;//mark a timing start
	int i;
	for(i=0; i<restrTabLen; i++){
		if(restTableP[i].name == restr)break;
		}
	if(i==restrTabLen){
		if(restrTabLen >= RESTRTIMTABLELEN){
			cout<<"*** Restriction Time Table too small"<<endl;
			return;
			}
		restrTabLen++;
		restTableP[i].time = 0;
		restTableP[i].counts = 0;
		restTableP[i].name = restr;
		restTableP[i].routtime = 0;
		}
	activeRestr=i; // save the active restriction
restrTimStStr = gethrtime();
	return;
}

void timings::timeRestrEnd(int restr){
	if(activeRestr < 0){// no start was done
		cerr<<"On restriction timing, no start call"<<endl;
		return;
		}
restrTimEndStr = gethrtime();
// since we are using a "wall-clock" time it is necessary to discard bad
//values
	long long elpst = restrTimEndStr - restrTimStStr;
if(elpst < 3500000){
	restTableP[activeRestr].counts++;
	restTableP[activeRestr].time += elpst;
}
else {
extern SymbTable sytab;
/*
cout.setf(ios::left);
cout<<setw(18)<<STNAME(restTableP[activeRestr].name)<<" ";
cout<<setw(10)<<elpst<<"  **Rejected"<<endl;
*/
}
//cout<<restTableP[activeRestr].time<<'\n' ;
/*
extern SymbTable sytab;
cout.setf(ios::left);
cout<<setw(18)<<STNAME(restTableP[activeRestr].name)<<" ";
cout.unsetf(ios::left);
cout<<setw(10)<<elpst<<"  "
<<setw(10)<<restTableP[activeRestr].time<<endl;
*/
	activeRestr = -1;
		
}

void timings::timeRoutineStart(){
routineTimeFlag=1;
routineTimStStr = gethrtime();
	return;
}

void timings::timeRoutineEnd(){
routineTimEndStr = gethrtime();
	restTableP[activeRestr].routtime +=
(routineTimEndStr - routineTimStStr);
routineTimeFlag=0;
	return;
}

void timings::timeRestrPrint(){
extern SymbTable sytab;
	long long longsum=0;
	for(int i=0; i<restrTabLen; i++) longsum += restTableP[i].time;
// convert from nanosec to millisec
	int suminmillisec = int(longsum/1000000);

cout<<"\n   Total Time in Restrictions:  "<<suminmillisec<<" millisec."<<"\n\n";
	cout.setf(ios::left);
	cout<<setw(18)<<"  Restriction         Count"
	<<"       Time in      Time in "<<'\n'
	<<"                                 Restriction   Routines"<<"\n\n";
	for(int im=0; im<restrTabLen; im++){
		cout.setf(ios::left);
		cout.setf(ios::fixed);
		cout<<setw(18)<<STNAME(restTableP[im].name);
		cout.unsetf(ios::left);
		if(restTableP[im].counts==0) {cout<<'\n';continue;}
float ratio= float((restTableP[im].time*10000)/longsum)/100.; 
//if(ratio<.5)continue; 
//long tmp=(restTableP[im].time*100000)/sum; //this is wrong
int inttmp=int(restTableP[im].time); 
//float ftmfromint=inttmp*10000/intsum;
//int ti=int(tmp);
//cout<<"lng tim="<<restTableP[im].time<<"    flt tim="
//<<float(restTableP[im].time)<<" intsum="<<intsum<<endl;
//cout<<"inttmp="<<inttmp<<"  ftmfromint="<<ftmfromint<<"  tmp="<<tmp<<"  ti="<<ti<<endl;
		cout<<setw(9)<<restTableP[im].counts<<setw(12)
		<<setprecision(2)<<float(restTableP[im].time)/1000000.<<"    ";
		cout<<setw(8)<<setprecision(2)
			<<float(restTableP[im].routtime)/1000000.<<"    ";
		cout<<setw(8)<<setprecision(2)<<ratio<<setw(10)
		<<setprecision(2)<<(float(restTableP[im].time)/1000000.)/
		restTableP[im].counts<<'\n';
		}
	cout<<endl;
	return;
}
/*
void timings::timeNodePrint(){
extern SymbTable sytab;
	clock_t sum=0;
	for(int i=0; i<nodeTabLen; i++) sum += nodeTableP[i].time;
cout<<"Time in Restrictions "<<(sum*100/CLK_TCK)/100.<<" sec."<<'\n';
	cout.setf(ios::left);
	cout<<setw(18)<<"  Node"<<"  Count"<<'\n';
	for(i=0; i<nodeTabLen; i++){
		if(nodeTableP[i].counts<5) continue;
		cout.setf(ios::left);
		cout<<setw(18)<<STNAME(nodeTableP[i].name);
		cout.unsetf(ios::left);
		cout<<setw(8)<<nodeTableP[i].counts<<setw(8)
		<<float(nodeTableP[i].time*10000/CLK_TCK)/10000.<<"    ";
if(sum>0)cout<<setw(5)<<setprecision(2)
	<<float((nodeTableP[i].time*10000)/sum)/100.<<'\n'; 
		}
	cout<<endl;
	return;
}
*/
