/* M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
   (c) 2005 All rights reserved.
   Read Terms of Use at http://mlp-xml.sourceforge.net.
   Contact medical_language_processing@gmail.com
*/
class SymbTable{
private:
int hashlk[128];
int freelk;
int sttoridx;
int sttoridxAdd;
int hashstep;
int alpharet;
int temp;
int permSymbolEnd;
int permSymbolEndSlot;
char *permSymbolTextEnd;
int permSymbolTextSizeEnd;

#define STINDEXMAP stindexMap
#define SYMSTRINGSTORADD symStringStorAdd
#define SYMTABADD symtabAdd

#define WD2GRSIZE 1500
short int wd2gr[WD2GRSIZE];
short int *wd2grPtr;

#define STINDEXMAPSIZE 3500
short stindexMap[STINDEXMAPSIZE];
short *stindexMapPtr;

struct symtabst {char *stname_ptr ;
	unsigned int staddr ;
	unsigned int strefc ;
	unsigned int stlink ;
	unsigned short sttype ;
	unsigned short stopoth ;
	};

struct symtabst *symtabPtr, *symtab;

struct symtabAddst {char *stname_ptr; unsigned int staddr; char glbFlg;};
struct symtabAddst *symtabAddPtr, *symtabAdd;

struct symStorst{char *beg; char * storPtr; short size; short alloc;} symStor[8];

char *storSymbStrng(const char *, int);

public:
SymbTable();
~SymbTable();
void alphInit();
int getNextAlpha();
int stlength();
void symbinit();
void gramfin();

void setstadd(int idx,int add){ symtab[idx].staddr=add ;}
void setstaddSym(int idx,int add){(symtabAddPtr+idx)->staddr=add ;}
//void setstaddwd(int idx,int add){ symtab[wd2gr[idx]].staddr=add ;}
void setstrefc(int idx,int refc){ symtab[idx].strefc=refc;}
//void setstrefcwd(int idx,int refc){ symtab[wd2gr[idx]].strefc=refc;}
void setsttype(int idx,int type){ symtab[idx].sttype = type;}
//void setsttypewd(int idx,int type){ symtab[wd2gr[idx]].sttype=type;}
void setstopnm(int idx,int opn){ symtab[idx].stopoth=opn;}
void setstcanf(int idx, int canfn){ symtab[idx].stopoth= canfn;}
//void setstcanfwd(int idx, int canfn){ symtab[wd2gr[idx]].stopoth= canfn;}
void setstname(int idx, char * spt){symtab[idx].stname_ptr=spt;}
#if 0
void setstadd(int idx,int add){ symtab[Map].staddr>0?=add ;}
//void setstaddwd(int idx,int add){ symtab[wd2gr[idx]].staddr=add ;}
void setstrefc(int idx,int refc){ symtab[idx].strefc=refc;}
//void setstrefcwd(int idx,int refc){ symtab[wd2gr[idx]].strefc=refc;}
void setsttype(int idx,int type){ symtab[idx].sttype = type;}
//void setsttypewd(int idx,int type){ symtab[wd2gr[idx]].sttype=type;}
void setstopnm(int idx,int opn){ symtab[idx].stopoth=opn;}
void setstcanf(int idx, int canfn){ symtab[idx].stopoth= canfn;}
//void setstcanfwd(int idx, int canfn){ symtab[wd2gr[idx]].stopoth= canfn;}
void setstname(int idx, char * spt){symtab[idx].stname_ptr=spt;}
#endif

int getTransStIdx(int idx){return (int)((stindexMapPtr)[idx]);}
int getTransWDIdx(int idx){return (int)((wd2grPtr)[idx]);}
int retstadd(int idx){return symtab[idx].staddr ;}
int retstaddSym(int idx){return  (symtabAddPtr+idx)->staddr ;}
//int retstaddwd(int idx){return symtab[wd2gr[idx]].staddr ;}
int retsttype(int idx){return symtab[idx].sttype ;}
//int retsttypewd(int idx){return symtab[wd2gr[idx]].sttype;}
//int retsttypeent(int idx){return symtab[idx].sttype ;}
int retstnum(int idx){return symtab[idx].stopoth;}
int retstcanf(int idx){return symtab[idx].stopoth;}
//int retstcanfwd(int idx){return symtab[wd2gr[idx]].stopoth ;}
int retstopnm(int idx){return symtab[idx].stopoth;}
int retsthostp(int idx){return symtab[idx].stopoth;}
int retstopoth(int idx){return symtab[idx].stopoth;}
int retstrefc(int idx){return symtab[idx].strefc;}
//int retstrefcwd(int idx){return symtab[wd2gr[idx]].strefc;}
char *retstname(int idx){return symtab[idx].stname_ptr;}
//char * retstnamewd(int idx){return symtab[wd2gr[idx]].stname_ptr;}
char * retstnameSym(int idx){return (symtabAddPtr+idx)->stname_ptr;}
#if 0
int retstadd(int idx){return (stindexMap[idx]>0?symtab[stindexMap[idx]].staddr:
                              symtabAdd[-stindexMap[idx]].staddr;}
int retstaddwd(int idx){return symtab[wd2gr[idx]].staddr ;}
int retsttype(int idx){return (stindexMap[idx]>0?symtab[stindexMap[idx]].stty:
                              symtabAdd[-stindexMap[idx]].staddr;}
int retsttype(int idx){return symtab[idx].sttype ;}
int retsttypewd(int idx){return symtab[wd2gr[idx]].sttype;}
int retsttypeent(int idx){return symtab[idx].sttype ;}
int retstnum(int idx){return symtab[idx].stopoth;}
int retstcanf(int idx){return symtab[idx].stopoth;}
int retstcanfwd(int idx){return symtab[wd2gr[idx]].stopoth ;}
int retstopnm(int idx){return symtab[idx].stopoth;}
int retsthostp(int idx){return symtab[idx].stopoth;}
int retstopoth(int idx){return symtab[idx].stopoth;}
int retstrefc(int idx){return symtab[idx].strefc;}
int retstrefcwd(int idx){return symtab[wd2gr[idx]].strefc;}
char *retstname(int idx){return (stindexMap[idx]>0?symtab[stindexMap[idx]].stname:
                              symtabAdd[-stindexMap[idx]].stname;}
char * retstnamewd(int idx){return symtab[wd2gr[idx]].stname_ptr;}
#endif
void clearLocalAdd(int idx){(symtabAddPtr+idx)->staddr=0;return;}
int isAddSymGlob(int idx){ return (symtabAddPtr+idx)->glbFlg;}
int ihash(const char * );
int lookst(const char * nm);
int putst(const char *nm);
int addst(const char *, int, int, int);
int rmvst(int idx) ;
int getst(const char * nme, int jytyp);
void wd2grst(int wdx,int grx){wd2gr[wdx]=grx;}

int settyp(int idx, int sytyp);
void sortstlink();
void symtabprint();
void freeTempSymbols(int);
void permSymbolDone();
}; // end of class

