/* M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
   (c) 2005 All rights reserved.
   Read Terms of Use at http://mlp-xml.sourceforge.net.
   Contact medical_language_processing@gmail.com
*/
#include <iostream.h>
#include <stdlib.h>
#include <fstream.h>
#include <string.h>
#include <ctype.h>
#include <signal.h>
#include "common.fcm"
#include "symtab.h"
#include "lispdefs.fcm"
#include "nodefs.fcm"
#include "filedeflun.fcm"
#define TRUE 1
#define FALSE 0
#define ISGWTH 1
#define INTWTH 3
#define IFDWTH 15
#define GLOBAL 16
extern SymbTable sytab;
extern void exitr(int, const char *);
extern void parscn(int);
extern void treeTransCtl(int);
extern void rdlistinit(void);
extern void ltotinit(void);
extern void largoInit(void);
extern void treListInit(void); // initalize tree to list func
extern int rdanalcont(int);
extern void lked(int);
extern int readst(int);
extern int readstskip(int);
extern void CLOSE(int);
extern void REWIND(int);
// extern int scanwd(int,int);
extern int excon(int,char);
extern void readCanonData(int);
extern void readSegmentData(int);
extern void mergeSymt(int);
extern int treeToList(int);
extern void interpInit(void);
extern void permListComp(void); // mark end of permanant list area 
extern void attachStdio(int);

void listSpaceInit(void);
static int	numsent_proc;
static ifstream * controlstr;
/*
void segfault(int sigtype){
cout<<"/n***A segmentation fault has occurred. Report this."<<endl;
exit();
}

*/
main(int argc, char* argv[]){
  // JR: call this to initialize global filestream *coutP
  attachStdio(2);

  // JR: added to stop program so gdb can be attached here
// char c;
// cout << " Enter any character and <RETURN> to continue ";
// cin >> &c;
  
if(argc>1){
if(strcmp(argv[1],"-dose")==0) parseType=DOSE_TYPE;
}
	int parsent_read;
//signal(SIGSEGV,&segfault); 
// set the print unit to the standard output
	parlim=1;

	excon(0,' '); // determine if the input command file is the standard input
//                              read next control card
	int ctltp;
	while(1){ // outer loop to keep reading control until end
//	while((ctltp=rdanalcont(comndu))==0); // 0= no action
	ctltp=rdanalcont(comndu); // 0= no action
	if(ctltp<0) exitr(0, "end");
	if(ctltp==0)continue;
	switch(ctltp){

	case 1: // run control read PARSE or READPAR
		excon(1,transType);
 		//sytab.symbinit();
		listSpaceInit();
		parsent_read=0;
	linlim=20000;
	nodlim=6000;
	maxtime=0;
	break;

	case 2: // LKED read
// Open the grammar file including symbol table if any
// or the transformation files
// Read in the grammar symbol table. If the symbol table is in the
// same file as the grammar, start by skipping past the grammar

		if(excon(2,transType)<0) exitr(1, "error");
		int stfun;
		if(grinst)stfun=grinst;
		else stfun=grinfl;
		if(readstskip(stfun)<0)exitr(2, "No Grammar Symbol Table");
		readst(stfun);

		if(grinst) {CLOSE(grinst); grinst=0;}
		else REWIND(grinfl);

// Read and load the grammar
		lked(grinfl);
		sytab.gramfin();//tell sytab that grammar is finished
		CLOSE(grinfl); grinfl=0;
		if(extyp==RDPAR){rdlistinit(); ltotinit();}		
		treListInit(); // initalize tree to list func
		largoInit();
		interpInit(); //initialize the jump table in interp
		permListComp(); // mark end of permanant list area 
		break;

	case 3: // PARSENT read
// If the first PARSENT Open dictionary look-up file and read canonical forms.
// Dict. File remains open for the entire run or until the next run control
// is read. Also read the segment table. and open WRITE file.
// and merge symbol table from WD
// Open the parse tree output file

		if(!parsent_read){
			parsent_read=1; // set first PARSENT done
			if(excon(3,' ')<0){
				exitr(3, "FILE not opened. Run terminated");
				}
			if(!grroot){// root node not on *ROOT node ctl
				grroot= LOOKST((char *) "SENTENCE");
				if(grroot)grroot=STADDR(grroot);
				}
// open WRITE file 
// Merge symbol table from WD
		if(wdsymt){
		if(readstskip(wdsymt)<0)exitr(4, "No WD Symbol Table");
		mergeSymt(wdsymt);
		permListComp(); // mark end of permanant list area 
		CLOSE(wdsymt); wdsymt=0;
		}
		sytab.permSymbolDone();//notify st object perm. symbols are done
		readCanonData(wdin); // read the canonical forms data;

// Open the seglist file and read segment list if any
		if(segbwf){readSegmentData(segbwf); CLOSE(segbwf); }
// Open output tree file
		excon(4,' ');
		} // first PARSENT

		parscn(numsent_proc);
		break;

	case 4: //TRANSTREE read
// if the first TRANSTREE Open parse tree input and output files
		if(!parsent_read){
		sytab.permSymbolDone();//notify st object perm. symbols are done
		parsent_read=1; // set first TRANSTREE done
// Open the input and output tree file
		excon(4,transType);
		}
	treeTransCtl(numsent_proc);
	break;

}
}
}//func end

// -------------------------------------------------------------

int rdanalcont(int lun){
	fstream * controlStream;
	char *rdp, token[50];
	char name[50], *nameP=name;
	fstream* getstptr(int);
static const int NMCTRS=4;
struct contrvarstruc {const char * name ;short grup ; short grtp ; int * addr;};
static  contrvarstruc controlvarImage[16]={ 
{ "PARLIM",1,1,&parlim},
{ "LINLIM",1,2,&linlim},
{ "NODLIM",1,3,&nodlim},
{ "LWIDTH",1,4,&lwidth},
{ "MAXTIME",1,5,&maxtime},

{ "COMPLETION",4,CMPLBT},
{ "IGNORE",4,IGNRBT},
{ "SAVE",4,SAVEBT},
{ "FREEZE",4,FRZBIT},
{ "TRACERTREE",4,RTRTRBIT},

{"ROOT",5,1},
{"PARSE",6,PARSSN},
{"READPAR",7,RDPAR},
{"LKED",8,1},
{"PARSENT",9,1},
{"TRANSTREE",10,1}
};

struct contrswstruc {const char * name ;short grup ; short grtp ; char * addr;};
static  contrswstruc controlswImage[25]={ 
{"TRACE",2,1,&trace},
{"TRACER",3,RTRBIT,&tracer},
{"XREF",2,2,&xref},
{"HOUSE",2,3,&house},
{"FULLTRACE",2,4,&fultrc},
{"DRAWSW",2,5,&drawsw},
{"TREESW",2,6,&treesw},
{"VERBOS",2,7,&verbos},
{"MATPRT",2,8,&matprt},
{"RARESW",2,9,&rarsw},
{"REPSW",2,10,&repsw},
{"FULLTREE",2,11,&fultre},
{"RECURTRACE",2,12,&rectrc},
{"SEGMENTSW",2,13,&segsw}, 
{"STREAM",2,14,&stream},
{"XTRACE",2,15,&xtrace},
{"XON",2,16,&xon},
{"XTRACER",2,17,&xtracer},
{"WFFTRACE",2,18,&wfftrc},
{"FRZTRACE",2,19,&frztrc},
{"DRAWSW",2,20,&drawsw},
{"XTREESW",2,21,&xtresw},
{"XDRAWSW",2,22,&xdrwsw},
{"RESTRICTIMER",2,23,&restiming},
{"NODETIMER",2,24,&nodetiming}};


	char *rdlin = new char[102];
for(int i=0;i<102;i++) rdlin[i]='\0';
	controlStream=getstptr(lun);
	char chr='\0';
	//*controlStream>>chr;
	chr = controlStream->get();
//	cin>>chr;
//	if(chr==EOF){
	if(*controlStream==0){
	*coutP<< "EOF encountered on input"<<endl;
	delete rdlin;
	return -1;
	}

	if(chr!='*'){delete rdlin; return -2;} // not a control image
	if(controlStream->getline(rdlin,101)==0){
//	if(cin.getline(rdlin,101)==0)
	*coutP<<"EOF encountered on input"<<endl;
	delete rdlin;
	return -1;
	}
// skip empty lines
	rdp=rdlin;
	while(1){
	if(*rdp=='\0'){delete rdlin; return 0;}
	if(*rdp++!=' ')break;
	}
	*coutP<<'*'<<rdlin<<endl;
	rdp=rdlin;
	if(*rdp == ' '){
//                          comment image
	delete rdlin;
	return 0;
	}

	while (isalpha(*rdp) || isdigit(*rdp)) *nameP++ = *rdp++;
	*nameP='\0';
//                                 1. search list of keyword variables
	int find=-1;
	int clgp;
	int i;
	for(i=0;i<24;i++){
		if(strcmp(name, controlswImage[i].name)==0) {
			clgp=(int)controlswImage[i].grup;
			find=i;
			break;
			}//if
		}//if
	if(find<0){
		for(i=0;i<16;i++){
		if(strcmp(name, controlvarImage[i].name)==0) {
			clgp=(int)controlvarImage[i].grup;
			find=i;
			break;
			}//if
			}//for
		}//if

	if(find<0){ // no find bad image"
		*coutP<<"Unknown Control Image\n"<<"*"<<rdlin<<endl;
		delete rdlin;
		return 0;
		}

//        get the next character
	char ct=*rdp++;	
	int term;
	if((ct=='\0')|| (ct==' '))term=1; 
	if(ct=='=')term=2; // assignment
	if(ct=='(')term=3; // image is a function
	if(((clgp==1 || clgp==2) && term !=2) || (clgp ==3 &&
		(term != 2 && term !=3))|| (clgp==5 && term != 2)){
		*coutP<<"Bad Syntax - Control Image"<<endl;
		delete rdlin;
		return 0;
		}
	if(clgp==3 && term==2)clgp=2 ;// make TRACER= an assign

// if an opening "(" get argument and check close
	if(term==3){
	nameP=name;
	while (isalpha(*rdp) || isdigit(*rdp) ||
		*rdp == '-') *nameP++ = *rdp++;
	*nameP='\0';
	if((clgp != 9 && *rdp != ')') || (clgp == 9 && *rdp != ',')
		||(clgp==5 && *rdp != '\0')) {
		*coutP<<"Bad Syntax - Control Image"<<endl;
		delete rdlin;
		return 0;
		}//if
	}//if

	switch (clgp){
	case 1: // counters
	{	int ctr=atoi(rdp);
		*controlvarImage[find].addr=ctr;
		delete rdlin;
		return 0;
	}
	case 2: //  a T F type of assignment
	if(*rdp=='T')
		*controlswImage[find].addr=TRUE;
	else if(*rdp=='F')
		*controlswImage[find].addr=FALSE;
	else *coutP<<"*** Right side of assignment invalid"<<endl;
	//*coutP<<"control parm = " << controlswImage[find].name << "=" << rdp <<endl;
	delete rdlin;
	return 0;
/*
                              G. process subscripted assignment
                                 1. *TRACER(---)=
                                 2. *COMPLETION(---)=
                                 3. *IGNORE(---)=
                                 4. *SAVE(---)=
                                 5. *FREEZE(---)=
                                 6. *TRACERTREE(---)=
*/
	case 3:
	case 4:
int	ffl;
	if(clgp==3) ffl=controlswImage[find].grtp;
	else ffl=controlvarImage[find].grtp;
	int addr;
	if(!(addr=LOOKST(name))){
		*coutP<<"no such definition "<<name<<endl;
		delete rdlin;
		return 0;
		}

	if(!(addr=STADDR(addr))){
		*coutP<<"no such definition "<<name<<endl;
		delete rdlin;
		return 0;
		}
	rdp++;
	if(*rdp != ')' && *rdp != '='){
		*coutP<<"Bad Syntax - Control Image\n"<<"*"<<rdlin<<endl;
		delete rdlin;
		return 0;
		}
	if(*++rdp=='T')CSR(addr) |= ffl;
	else CSR(addr) &= ~ffl;
	delete rdlin;
	return 0;
//				ROOT-NODE
	case 5:
	if(!(addr=LOOKST(rdp))){
		*coutP<<"no such node name "<<name<<endl;
		delete rdlin;
		return 0;
		}

	if(!(addr=STADDR(addr))){
		*coutP<<"no such definition "<<name<<endl;
		delete rdlin;
		return 0;
		}
	grroot=addr;
	return 0;

// 				PARSE()
	case 6:
	extyp=controlvarImage[find].grtp;
	transType=' ';
	delete rdlin;
	return 1;

// 				READPAR()
	case 7:
	extyp=controlvarImage[find].grtp;
	transType=*name;
	delete rdlin;
	return 1;

// 				LKED()
	case 8:
	delete rdlin;
	return 2;
// 				PARSENT(...)
	case 9:
// 				TRANSTREE(...)
	case 10:
	if(name[0]=='A')numsent_proc=-1;
	else numsent_proc=atoi(name);
	if(clgp==9){
		if(treflo){
		treout=TRENWF;
		if(*rdp==','){
			if(*(++rdp)=='W'){
				treout=TREWWF;
				}
			}
			}
		delete rdlin;
		return 3; // tell caller we have PARSENT
		}
	delete rdlin;
	return 4;		// or a TRANSTREE
	}//switch

//	while (isalpha(rdp) || isnum(rdp)) *nameP++ = *rdp++;
	*nameP='\0';

	*coutP<<"*** Right side of assignment invalid"<<endl;
	delete rdlin;

}
/*
char * dec(int n,int l){
static char decr[4]="001";
return decr;
}
*/
void closefiles(void);
void exitr(int errNum, const char * errmg){
closefiles();
*coutP<<errmg<<endl;
exit(errNum);
}
