/* M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
   (c) 2005 All rights reserved.
   Read Terms of Use at http://mlp-xml.sourceforge.net.
   Contact medical_language_processing@gmail.com
*/
#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <stdlib.h>
#include <string.h>
#include "symtab.h"
#include "common.fcm"
#include "lispdefs.fcm"
static int fillcnt=0;// **debug
#define PRUNIT 2
extern SymbTable sytab;
extern fstream * getstptr(int);
static const char * blanks =  "                                  ";
static int col[24]={0,0,0,0,0,0,0,0,0,0,0,0,0};
static short rm[24] ={0,71,80,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,
			71,71,71,71};
static struct prlincst {fstream *fillstrm; short unit; short indent; short col;
		short amskp; short rm; } prntlncont;
static const int indent=7;
static int fillUnit=PRUNIT;

// ----------------------------------------------------------------------

void setrtmargin(int lunt, int rtval){
	rm[lunt] = rtval;
	return;
}

// ----------------------------------------------------------------------

int getrtmargin(int lunt){
	return rm[lunt];
}

// ----------------------------------------------------------------------

void resetFillUnit(){
	if(prntlncont.unit == PRUNIT)return;
	prntlncont.unit=PRUNIT;
	prntlncont.rm=getrtmargin(PRUNIT);
	prntlncont.fillstrm = getstptr(PRUNIT);
	prntlncont.col=0;
	return;
}//func end

// ----------------------------------------------------------------------

void setFillUnit(int nut){ 
	if(nut == prntlncont.unit) return;
	prntlncont.unit=nut;
if(nut != PRUNIT)
	prntlncont.rm = getrtmargin(nut);
else 
	prntlncont.rm = lwidth;
	prntlncont.col = 0;
	prntlncont.fillstrm = getstptr(nut);
	return;
}//func end

// ----------------------------------------------------------------------

static void resetprcol(void){
	prntlncont.col=0;
	return ;
}//func end

// ----------------------------------------------------------------------

int getprcol(int lunt){
	return prntlncont.col;
}//end of func

// ----------------------------------------------------------------------

int getindent(int lunt){
	return prntlncont.indent;
}//end of func

// ----------------------------------------------------------------------

void setindent(int lunt, int indval){
	prntlncont.indent=indval;
	return;
}//end of func

// ----------------------------------------------------------------------

void setIndent(int indval){
	prntlncont.indent=indval;
	return;
}//end of func

// ----------------------------------------------------------------------

void setprcol(int lunt, int prpos){
	int skpl;
	if((skpl=prpos-prntlncont.col) <= 0)return;
	prntlncont.amskp=skpl;
	*coutP<<setw(skpl)<<' ';
	cout<<setw(skpl)<<' ';
	prntlncont.col=prpos;
	return;
}//end of func

// -----------------------------------------------------------------

/* ***********************************************************************
      PRNT flushes the currently active output line buffer onto unit
      OTUNIT.
 *********************************************************************** */
void prnt(void) {

//      IF(PPARSW) GO TO 50
//                  write output line buffer onto output unit
	*(prntlncont.fillstrm)<<endl;
//                       reset column pointer to left margin
	resetprcol() ;

//          if writing to the print file, decrement the line limit
	if(prntlncont.unit == PRUNIT) linz--;
	return;
}

// -----------------------------------------------------------------

/* ************************************************************************
     PRNTIF flushes the currently active output line buffer if it is
     not empty (all blank).
 *********************************************************************** */

void prntif() {
	if(prntlncont.col>0)prnt();
}//func end

// -----------------------------------------------------------------

int printSent(int wdstrt, int wdend, int optn, int outUnit){
	fstream *strout=getstptr(outUnit);

	int strp, prl=1;
	if(optn == 1 && !outUnit)*coutP<<'\f';
	if(optn != 3) *strout<<"*SID="<<sentid<<endl;

	int rm=getrtmargin(outUnit);

	if(optn == 2){*strout<<"* "; strp=2;}
	else strp=0;
	*strout<<(SENTWD(wdstrt));
	strp += strlen(SENTWD(wdstrt));
	for(int i=wdstrt+1;i<=wdend;i++){
		int sl=strlen(SENTWD(i));
		if(strp+sl+1>rm){
			*strout<<endl;
			if(optn == 2){ *strout<<"* "; strp=sl+2; }
			else  strp=sl;
			prl++;
			}// if

		else {strp += sl+1; *strout<<" "; }
		*strout<<(SENTWD(i));
		}//for
		*strout<<endl;
		return prl+1;
}//func end

// ---------------------------------------------------------------------

int printSegment( int segstrt, int segend, int prev,int segid, int outUnit){
	char segcd;
	fstream * strout=getstptr(outUnit);

	int strp=0,prl=1;
	*strout<<"Parsing Segment SID= "<<sentid<<segcd<<endl;

	int rm=getrtmargin(PRUNIT);
	int sl;
	if(!prev){
		*strout<<'['<<SENTWD(prev)<<']';
		sl=strlen(SENTWD(prev))+2;
		}//if
	else{
		*strout<<SENTWD(segstrt);
		sl=strlen(SENTWD(segstrt));
		}//else

	for(int i=segstrt+1;i<=segend;i++){
		sl=strlen(SENTWD(i));
		if(strp+sl+1>rm){ *strout<<endl; strp=sl; prl++; }
		else { strp += sl+1; *strout<<" "; }
		*strout<<SENTWD(i);
		}//for
	*strout<<endl;
	return prl+1;
}//end of func

// ---------------------------------------------------------------------

void outIndent(void){
	if(prntlncont.col != 0) return;
	if(prntlncont.indent == 0) return;
	*(prntlncont.fillstrm)<<setw(prntlncont.indent)<<" ";
	prntlncont.col = prntlncont.indent;
	return;
}//func end

// ---------------------------------------------------------------------

/* ************************************************************************
      FILL writes 'ITEM', a character string of 'LENGTH' characters,
      into the currently active output buffer 
************************************************************************ */

void fill(const char *item) {
	int length;
	if(prntlncont.col == 0 && *item == ' ')item++;
	length=strlen(item);
	if(length == 0){ // then
        	*coutP<< "in fill: attempting to print a blank item ";
		return;
		}
	fstream *strout=prntlncont.fillstrm;
char itemb[700];
// change any '!' in string to a space
	char *itemP= (char *)item-1 , *itemB=itemb;
	while(*(++itemP) != '\0'){
		if(*itemP == '!') *(itemB++) = ' ';
		else *(itemB++) = *itemP;
		}//while
	*itemB = '\0';
	itemB = itemb;

//         if item will not fit on line, print current line
	int ileft=0;
// if the string is greater than 8 print out the longest substring
// ending on a space which will fit and put the rest on a new line
	int lenorg=length;
	while(prntlncont.col+length > prntlncont.rm) {
		if(length <= 8) {
			prnt();
			if(*itemB == ' '){itemB++; length--;}
			break;
			}
		int crem,i, is;
		char zc, zn;
		crem = prntlncont.rm-prntlncont.col;
		for(i=crem+ileft; i>ileft; i--){
			if((itemb[i] == ' ') ||(itemb[i] == '_')){
				zc=itemb[i];
				is=i;
				if(zc=='_'){
					is=i+1;
					zc=itemb[is];
					}
				itemb[is] = '\0';
				outIndent();
				*strout<<itemB;
				itemb[is] = zc;
				ileft = ++i;
				itemB = itemb+ileft;
				length = lenorg-ileft;

		while(*itemB == ' ') {itemB++; ileft++; length--;}
				}//if
			}//for
		prnt();
		}//while

	outIndent();
	*strout<< itemB ;
	prntlncont.col += length;
	return;
}// func end

// ----------------------------------------------------------------------

void fillString(char * string){
	int length=strlen(string);
	fstream * strout=getstptr(prntlncont.unit);
	if(prntlncont.col+length-1 > prntlncont.rm) {
	char * stp=string+length;
	int cnt=length;
	while(--stp>string){
		cnt--;
		if(*stp==' '){
			if(prntlncont.col+cnt-1 <= prntlncont.rm) {
				*stp='\0';
				*strout<<string<<endl;
				*(stp++)=' ';
				*strout<<stp;
				prntlncont.col = length-cnt-1;
				return;
				}
			}
		}//while

	*strout<<endl;
	prntlncont.col = 0;
	}

	*strout<<string;
	prntlncont.col += length;
	return;
}//end of fun

// ----------------------------------------------------------------------

void decout(int numb){
	fstream * strout=getstptr(prntlncont.unit);
	*strout<<numb;
	return;
}//end of fun

// ----------------------------------------------------------------------

void skipln(){

// ***********************************************************************
//      Skip a line in the print file
// ***********************************************************************

	fstream * strout=getstptr(prntlncont.unit);
*strout<<endl;
      return;
}//end of fun
