/* M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
   (c) 2005 All rights reserved.
   Read Terms of Use at http://mlp-xml.sourceforge.net.
   Contact medical_language_processing@gmail.com
*/
#include <string.h>
#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include "common.fcm"
#include "nodefs.fcm"
#include "lispdefs.fcm"
#include "symtab.h"
extern SymbTable sytab;
extern void fill(const char *);
extern char *subsum(int,char*);
extern void flushbuf(int);
extern void markbuf(int,int);
extern void printSubatts(int);

int ndct=0;// **debug
extern int querybuf(int);
static int loc8on[13],lsct;
static const char * tabber[13]={" ","&","&&","&&&","#","##","###","@","@@",
  "@@@","+","++","+++"};
#define NODTRINDENT 10
#define NODWTH 6
#define TABWTH 8

void nodtrc(int key, int elementCur){
char txtarr[100];
	int i,nspec,naddr,strln,rtmg,prflg;
static	char  nodnme[NODWTH+1];
//cout<<"key "<<key<<" lsct "<<lsct<<" loc "<<loc8on[lsct]<<endl;
//return;
	if(key<0){
		loc8on[lsct] -= TABWTH;
		if(lsct && loc8on[lsct]<NODTRINDENT){
			if(lsct==0){cerr<<"lsct- "<<lsct<<endl;lsct++;}
			loc8on[--lsct] -= TABWTH;
			return;
			}//if
		}//key
	if(key < 3){
		nspec=CSRINT(elementCur);
		naddr=CARADDR(elementCur);
		}//key
	else {
		nspec=NDSPFB(xr7);
		naddr=CARADDR(NDHDBA(xr7));
		}//else

	if((nspec&NONAM)) return;
	strncpy(nodnme,STNAME(naddr),NODWTH);
	strln=strlen(nodnme);

	if(key == 0){ 
		*coutP<<"       "<<nodnme;
        	loc8on[0]=9+NODWTH;
		lsct=0;
		rtmg=500;
		markbuf(2,1);
		return;
		}//if key is 0

prflg=querybuf(2);

	switch(key){

	case 1:
	if(loc8on[lsct]>lwidth){
		*coutP<<endl;
		if(lsct>12){cerr<<"lsct "<<lsct<<endl;lsct--;}
		loc8on[++lsct] = NODTRINDENT;
		prflg=0;
		}//if
if(!prflg){
	if(lsct){
	        coutP->setf(ios::left);
		*coutP<<setw(loc8on[lsct])<<tabber[lsct]<<"= ";
		}//if
	else {
		*coutP<<setw(loc8on[lsct]+1)<<"= ";
		coutP->setf(ios::left);
		}//else
	}//if prflg
	else {
	        coutP->setf(ios::left);
		*coutP<<"= ";
		}//else

	*coutP<<setw(NODWTH)<<nodnme;
	loc8on[lsct] += TABWTH;
	if((nspec&ATOMIC)==0) {prflg=1;break;}
	if((nspec&OTOMIC)==0){
if(word>nword)*coutP<<"  (no-sent-word"<<word;
else{
		*coutP<<"  ("<<(SENTWD(word));
		for(i=1;i<=(SENTE6(word)-1);i++){
			*coutP<<'_'<<(SENTWD(word+i));
			} // for
}//else
		*coutP<<')';
	}//if
	*coutP<<endl;prflg=0;
	break;

case 2:
case 5:
	if(prflg)*coutP<<endl;
	loc8on[lsct] -= TABWTH;
	if(lsct && loc8on[lsct]<NODTRINDENT){
		if(lsct==0){cerr<<"lsct- "<<lsct<<endl;lsct++;}
		loc8on[--lsct] -= TABWTH;
		}
	if(lsct){
		coutP->setf(ios::left);
		*coutP<<setw(loc8on[lsct]+2)<<tabber[lsct]<<"- (";
		}
	else{
		*coutP<<setw(loc8on[lsct]+4)<<"- (";
		coutP->setf(ios::left);
		}
	*coutP<<nodnme<<')'<<endl;
	prflg=0;
	break;

case 3:
	if(prflg)*coutP<<endl;
	loc8on[lsct] -= TABWTH;
	if(lsct && loc8on[lsct]<NODTRINDENT){
		if(lsct==0){cerr<<"lsct- "<<lsct<<endl;lsct++;}
		loc8on[--lsct] -= TABWTH;
		}
	if(lsct){
		coutP->setf(ios::left);
		*coutP<<setw(loc8on[lsct]+2)<<tabber[lsct]<<"+ (";
		}
	else {
		*coutP<<setw(loc8on[lsct]+4)<<"+ (";
		}
	*coutP<<nodnme<<") **";
	if((nspec & (ATOMIC+OTOMIC)) == ATOMIC){
if(NDWPNC(xr7)==NDWPCP(xr7)){
*coutP<<"\n empty node at node="<<xr7<<endl;
if(NDOTMT(xr7)){
*coutP<<"node is null atomic"<<endl;
}
}
	*coutP<<"  ("<<subsum(xr7,txtarr);
ndct++;// **debug
int fw=NDWPNC(xr7);
int lw=NDWPCP(xr7);
//*coutP<<"\nin NODTRC: node="<<xr7<<" fw="<<fw<<" lw="<<lw<<" count="<<ndct<<endl;
if(lw-fw == SENTE6(fw)) printSubatts(NDBALP(xr7));//an atomic
	*coutP<<')';
}//if

*coutP<<endl; prflg=0;
	break;

case 4:
	if(loc8on[lsct]>lwidth){
		*coutP<<endl;
		if(lsct>12){cerr<<"lsct "<<lsct<<endl;lsct--;}
		loc8on[++lsct]=NODTRINDENT;
		prflg=0;
		}//if
	if(!prflg){
		coutP->setf(ios::left);
		*coutP<<setw(loc8on[lsct])<<tabber[lsct];
		*coutP<<"^ "<<setw(NODWTH)<<nodnme;
		}//if
	else {
		coutP->setf(ios::left);
		*coutP<<"^ "<<setw(NODWTH)<<nodnme;
		}//else
	loc8on[lsct] += TABWTH;
	prflg=1;
	break;
	}// switch

markbuf(2,prflg);
coutP->unsetf(ios::left);
	return;
}

void printSubatts(int attrbp){
int a1=attrbp;
const char * sublan="SUBLANGUAGE-ATTS-PRINT-LIST";
int stn=LOOKST(sublan);
if(stn){
int sublist[50];
//if(a1)cout<<"\nin sbua: fw="<<fw<<" snt3="<<(SENTE3(fw))<<" a1="<<a1<<" stn="<<stn<<endl;
int sbaddst=STADDR(stn);
if(sbaddst==0)cerr<<"no such address\n";
int prf=0;
sbaddst=CDR(sbaddst);
while(a1){// loop on atts of word
//check if attribute is on sub-language list
int flg=0;
int sbadd=sbaddst;
int a2=CAR(a1);
while(sbadd){
if(a2==CAR(sbadd)){flg=1; break;}
sbadd=CDR(sbadd);
}//while
if(flg) {if(!(prf++))*coutP<<": "<<(STNAME(CAR(a2)));}
a1=CDR(a1);
}//while
}// if sub lang exists
	return;
}
