/* M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
   (c) 2005 All rights reserved.
   Read Terms of Use at http://mlp-xml.sourceforge.net.
   Contact medical_language_processing@gmail.com
*/

// ************************************************************************
// *     _nodnam_ returns the name of the node pointed to by _nd_.
// ************************************************************************

      // INCLUDE 'nddfty.fcm'
#include <string.h>
#include <fstream.h>
#include "symtab.h"
#include "common.fcm"
#include "lispdefs.fcm"
#include "nodefs.fcm"

extern SymbTable sytab;
char *nodnam(int nd, char *nodeName){
	int n,i;
	if(!(NDNONT(nd))){ 
        	n=CAR(NDHDBA(nd));
        	if(!(NDLTMT(nd))) {
			strcpy(nodeName,STNAME(n));
			return  nodeName;
			}
        	else { // literal -- surround with quotes
			*nodeName='\'';
          		strcpy(&nodeName[1],STNAME(n));
			strcat(nodeName,"'");
			}//else
		}//if

	else { //  unnamed node--print named node above with () in front
		i=nd;
		do {i=NDUPLF(i);} while(NDNONT(i));
        	n=CAR(NDHDBA(i));
		*nodeName='(';
		nodeName[1]=')';
        	strcpy(&nodeName[2],STNAME(n));
		}//else
        return nodeName;
}
