/* M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
   (c) 2005 All rights reserved.
   Read Terms of Use at http://mlp-xml.sourceforge.net.
   Contact medical_language_processing@gmail.com
*/
#include <iostream.h>
#include <fstream.h>
#define TRUE 1
#define FALSE 0
#include <stdlib.h>
#include "common.fcm"
#include "gencom.fcm"
#include "lispdefs.fcm"
#include "symtab.h"
#define ISGWTH 1
#define INTWTH 3
#define IFDWTH 15
extern SymbTable sytab;
extern int gcons(int,int,int);
extern unsigned int getfld(int);
static int fll=0;

int load (int locrec){
//static int dbgf=0;// **debug
/*
************************************************************************
     Unpacks one object record into grammar.  The object record must be
     be selected by presetting objptr in getputfld before calling LOAD.
     on exit the returned value:

          > 0 :  no errors encountered, =index in grammar of
                      last head encountered
          = 0 :  no errors encountered, no head encountered
          < 0 :  invalid interpret field encountered

     locrec = The position in grammar of word 0 of the record
              this may be the place where the first word of the record
              is loaded, but for restrictions it would be where the
              first word of the housing portion would have gone if
              it had been loaded. This is needed to calculate the
              value for a relative field.
 ************************************************************************
*/

	unsigned int g[2],inter;
	unsigned int sign, loadret=0, ifld, last=0;
	unsigned int  headf;
unsigned int h[2],m[2];

while(TRUE){
	headf=FALSE;
	sign=getfld(ISGWTH); //     I. Get sign bit

	for(int ik=0;ik<2;ik++){
	inter = getfld(INTWTH); // II. Get interpretation bits
h[ik]=inter;// **debug
// *                               A. For null field, store 0
m[ik]=0;// **debug
	if(!inter) ifld=0;
	else { //              III. Get and process data field

	if(inter==7) return loadret; // terminator field
	ifld= getfld(IFDWTH);
m[ik]=ifld;// **debug
	switch(inter){
//                                A. Absolute field:  if head, set  load
	case 1: if(ik == 1) break;
		if((ifld & HDINOG)==0) break;
		headf=TRUE;
//                                   1. Change bit used to indicate HEAD
//                                      in object grammar (HDINOG) to bit
//                                      used to indicate head in grammar
//                                      stored in memory (HEAD)

	ifld += (HEAD-HDINOG);
	break;
//                                B. Relative field
	case 2: ifld += locrec;
	break;
//                                C. Symbol:  store symbol table index +
//                                   SOS (start of symbols)
	case 3: ifld += SOS;
	break;
//                                E. Literal: store symbol table index +
//                                   SOL (start of literals)
	case 6: ifld += SOL;
	break;
//                                D. Invalid interpreter field
	case 4 :
	case 5 :
	default: return -1;

	} //switch
	} // else

	g[ik]=ifld;
	} // for
	int kurent=gcons(0,g[0],g[1]);
#if 0
if(dbgf){
//if(((h[0]==3||h[0]==6)&&sytab.retsttype(m[0])==4) ||
//((h[1]==3||h[1]==6)&&sytab.retsttype(m[1])==4)){
cerr<<hex<<"load "<<kurent<<" "<<g[0]<<" "<<g[1]<< endl;
cerr<<"load interp "<<kurent<<" "<<h[0]<<" "<<h[1]<< endl;
cerr<<"load fld "<<kurent<<" "<<m[0]<<" "<<m[1]<< "\n\n"<<dec;

if(h[0]==3 || h[0]==6)cerr<< sytab.retstname(m[0])<<" "
<< sytab.retsttype(m[0])<<endl;
if(h[1]==3 || h[1]==6)cerr<< sytab.retstname(m[1])<<" "
<< sytab.retsttype(m[1])<<endl;
//}
}
#endif
	if(headf) loadret=kurent;
	if(sign) CDR(last)=kurent;
	last=kurent;
	}// while
} // func

#define BPW 32
static int bitlft;
static unsigned int *objectptr, *objlast;
void exitr(int, const char *);

unsigned int getfld (int width){

// ************************************************************************
// *     GETFLD extracts the next WIDTH bits from the object buffer
// *     and returns them .
// ************************************************************************

static unsigned int mask[]={0x1,0x3,0x7,0xf,0x1f,0x3f,0x7f,0xff,0x1ff,0x3ff,
    0x7ff,0xfff,0x1fff,0x3fff,0x7fff};
unsigned int bit2go,isx;
//         BPW = bits per word in object buffer
//cerr<<"bits left "<<bitlft<<endl;
	if(width<0){
		bitlft -= width ;
		if(bitlft>BPW){bitlft -= BPW;objectptr--;}
		return 1;
		}

	if(width <= bitlft){ 
        isx=*objectptr;
        bitlft=bitlft-width;
        if(bitlft) isx = isx>>bitlft;
	return (isx & (mask[width-1]));
		}
	if (bitlft == 0){
        	bitlft=BPW-width;
        	if(++objectptr>objlast) {
			exitr(15, "Object buffer empty");
			}
		return ((*objectptr)>>bitlft) & mask[width-1];
		}

//                   field is split between two words
        bit2go=width-bitlft;
        isx=((*(objectptr++)) & mask[bitlft-1])<<bit2go;
        if(objectptr>objlast) {
		exitr(15, "Object buffer empty");
		}
        bitlft=BPW-bit2go;
        return ((((*objectptr)>>bitlft) & mask[bit2go-1]) | isx) & mask[width-1];
}

// -----------------------------------------------------------------------
//      INIGET is the initialization entry for GETFLD.
// -----------------------------------------------------------------------

void iniget(unsigned int *objp,int objlen){
      objectptr=objp;
      objlast=objectptr+objlen;
      bitlft=BPW;
      return;
}
