/* M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
   (c) 2005 All rights reserved.
   Read Terms of Use at http://mlp-xml.sourceforge.net.
   Contact medical_language_processing@gmail.com
*/
#define TRUE 1
#define FALSE 0
#include <iostream.h>
#include <fstream.h>
#include "common.fcm"
#include "nodefs.fcm"
#include "lispdefs.fcm"
#include <string.h>
#include "symtab.h"

extern int nodtst(int), oupone(void);
extern SymbTable sytab;
extern int gcons(int,int,int);
extern void getreg(int,int *,int*);

static int largwd=0;
void largoInit(void){
	largwd=gcons(0,0,0);
}

int largo(int narg){
	int ixr7,ilist;
//     LARGO (List Argument to Operator)

	if(!narg)return 0;
	if((CSR(narg)&(HEAD+REGBIT)) != (HEAD+REGBIT))return narg;
//         IF(.NOT. getreg(narg,&ixr7,&ilist));
//    1 exitr(" In LARGO - Register not defined");
        getreg(narg,&ixr7,&ilist);
        if(ilist <= 0){
		CAR(largwd)=NDHDBA(ixr7);
		return largwd;
		}
        else {if(ilist == 1) return ixr7;
	else return 0;
	}
}

// ************************************************************************
//     symbolCreate  creates a symbol head for the symbol named -NM- (unless
//     such a head already exists) and returns a pointer to this head.
// ************************************************************************

int symbolCreate(char *nm){
	int sta,ist;
	if(strcmp(nm,"NIL")!=0){
        	ist=GETST(nm,0);
        		if((sta=STADDR(ist)) == 0){
			sta=gcons(0,HEAD,ist);
			SETSTADDR(ist,sta);
			}
        	return sta;
		}//if
	else return 0;
}

// ************************************************************************
//    litralCreate  creates a literal head for the symbol named -NM- (unless
//    such a head already exists) and returns a pointer to this head.
// ************************************************************************

int litralCreate(char *nm){
	int ist=GETST(nm,0);
	if(STREFC(ist) ) return ist;
	int stt=gcons(0,(HEAD+ATOMIC+LTOMIC),ist);
	SETSTREFC(ist,stt);
	return stt;
}

// ************************************************************************
//      NSYMBL creates a numeric head for the number -NUM-, and returns
//      a pointer to this head.
// ************************************************************************

int nsymblCreate(int num){
      return gcons(num,(HEAD+CNSTBT),0);
}

// ----------------------------------------------------------

int search(int lst, int item){
	while(lst) {
/*
int aa=CAR(lst);
if(!ATOMP(aa))aa=CAR(aa);
if(!ATOMP(aa))aa=CAR(aa);
if(!ATOMP(aa))aa=CAR(aa);
char *sss= STNAME(CAR(aa));
int bb=item;
if(!ATOMP(bb))bb=CAR(bb);
if(!ATOMP(bb))bb=CAR(bb);
char *ttt= STNAME(CAR(bb));
cout<<"search "<<sss<<" "<<ttt<<endl;
if((strcmp(sss,"TEAR")==0) || (strcmp(ttt,"TEAR") ==0)){
cout<<"tear march"<<endl;
}
if((&cout)->fail()){
cerr<<"iofail in search"<<endl;
(&cout)->clear();
}
*/
if(CAR(lst) == item) return lst; lst=CDR(lst);}
	return 0;
}

// ----------------------------------------------------------

static int innerProd(int s1, int s2, int s3[]){
	int numEnt=0;
	for(; s2; s2=CDR(s2)){//over list
	int ta=CAR(s2);
/*
cout<<"att symbol "<<STNAME(CAR(CAR(s2)))<<endl;
if(int tx=CSR(s2)){
cout<<"subatt symbol "<<STNAME(CAR(tx))<<endl;
}
*/

		for(int p=s1; p; p=CDR(p)){//over link set
//cout<<"link symbol "<<STNAME(CAR(CAR(p)))<<endl;
			if(ta == CAR(p)) {s3[numEnt++] = s2; break;}
			}//for
		}//for
	return numEnt;
}

// ----------------------------------------------------------

int equivmatch(int equivList, int compAttLists[], int selAtt[], int numLists, int rejlst, int regname[]){
int numEnts[10];
int *newAtt[10];
int numInAtt[10];
int last[10];
	for(int i=0;i<numLists;i++) newAtt[i]=new int[30];

	int failflg;
	for(int eql=equivList; eql; eql=CDR(eql)){
		failflg=0;
		for(int il=0; il<numLists; il++){
			if(!(numEnts[il]=innerProd(CAR(eql), compAttLists[il], newAtt[il])))
				{failflg=1; break;}
			}//for over att lists
		if(!failflg)break;// equiv match suceeded for linkset
		}//for over conjs

	if(failflg){
		for(int i=0;i<numLists;i++) delete newAtt[i];
		return FALSE;
		}//if
//convert the sell att arrays to lists

	for(int i=0; i<numLists; i++){
//get number of items in the sel lists eg from exact match
		int atp=selAtt[i];
		int atpp = 0;
		numInAtt[i] = 0;
		while(atp){
			numInAtt[i]++;
			atpp=atp;
			atp=CDR(atp);
			}
		last[i]=atpp;

//if a rejection list is present modify the selatts accordingly
if(rejlst){
int nse = numEnts[i];
// we need to see if atts on the input lists which are not on the output
// lists are on the rejection allowed list .
//if there is only one att in input set than that is on the out list
//so no need to make this check
if(CDR(compAttLists[i])){//set has more than on att
for(int atl = compAttLists[i]; atl; atl=CDR(atl)){
int fnd = 0;
int *slat = newAtt[i];
for(int sel=0; sel<nse; sel++){
if(CAR(atl) == CAR(slat[sel])){fnd=1;break;}
}//for
if(fnd)continue;
// the att list item is not on the sel list, can it be rejected
for(int rj=rejlst; rj; rj=CDR(rj)){
if(CAR(rj) == CAR(atl))break;
}//for
//not on list add to sels
slat[numEnts[i]++] = atl;
}//for
}//more than one att in input lists
}//if rejlst

//cout<<"numEnts "<<i<<"  "<<numEnts<<endl;

//build the lists for the arrays
int *ap = newAtt[i];
if(!numInAtt[i]){
int atp = gcons(0,CSR(ap[0]),CAR(ap[0]));
extern void setreg(int, int, int);
setreg(regname[i],atp,1);
//cout<<"set="<<i<<" ap[0] "<<ap[0]<<endl;
for(int j=1; j<numEnts[i]; j++){
//cout<<"set="<<i<<" ap[j] "<<j<<"  "<<ap[j]<<endl;
int atpp = gcons(0,CSR(ap[j]),CAR(ap[j]));
CDR(atp)=atpp;
atp=atpp;
}//for
}// no sels from exact
else {
atp = last[i];
for(int j=1; j<numEnts[i]; j++){
int bp = ap[j];
int k;
int ba=selAtt[i];
for(k=0; k<numInAtt[i]; k++,ba = CDR(ba)){
if(CAR(bp) == CAR(ba)) break;
}//for over exact atts
if(k<numInAtt[i])continue; //att already in exact
int atpp = gcons(0,CSR(ap[j]),CAR(ap[j]));
CDR(atp)=atpp;
atp=atpp;
}//for over eqiv atts
}//else
		delete newAtt[i];
		}//for over sublists
	return TRUE;
}//end of func

// ----------------------------------------------------------

static int anythp=0;
extern int s7(int); 
extern int symbol(char *);
int attrb(int argin){
	int sxr7,slist,targ;
	if(anythp == 0)anythp=symbol((char *) "ANYTHING");
	sxr7=xr7;
	slist=list;
	if(!list){
//       looking at node
//       if node not Atomic, return FALSE
	if(!(NDATMT(xr7))) return FALSE;

//       if pointer to attribute list = 0, return FALSE
		if(NDBALP(xr7)==0)return FALSE;
		xr7=NDBALP(xr7);
		}//if node
	else{
		if(list==1) xr7=CSR(xr7);
		else xr7=SENTE2(xr7);
		if(xr7 == 0){
			xr7=sxr7;
			list=slist;
			return FALSE;
			}
		}//else
	list=1;
	if(!argin)return TRUE;
	if(!ATOMP(argin)) if(CAR(argin)== anythp)return TRUE;
	targ=largo(argin);
	return s7(targ);
	xr7=sxr7;
	list=slist;
	return FALSE;
}

/*
 ************************************************************************
     If A and B point to lists, CAT returns the concatenation of A and
     B.  List A is modified by this process. If A and/or B points to
     A head, the lists (A) and/or (B) are used in the concatenation
     operation.
 ************************************************************************
*/

int cat (int al, int bl) {
	if(bl) { // go to 20 
	if(ATOMP(bl)) {//go to 20
//                       1. If B points to a named head, use (B) instead
	bl=gcons(0,0,bl);
		}
	}
//                       2. If A is nil, return B
	if(!al) return bl;

//                       3. if a points to a named head,return (A B)
	if(ATOMP(al))  return gcons(bl,0,al);
//   30
//                       4. IF B is nil, return A
//   40 
	if(!bl) return al ;
//                       5. APPEND LIST B TO LIST A AND RETURN A
//   51
	int ax=al;
	while(CDR(ax)) ax=CDR(ax) ;
//   55
	CDR(ax)=bl ;
//   56
	return al ;
}
// -------------------------------------------------------------

int length(int p) {
	int len=0;
	while (p){ len++; p=CDR(p) ; }
	return len ;
}

// ************************************************************************
// *     Returns the list formed by appending list B to the end of list A.
// *     neither A nor B is modified;  if A is non-null,the cdr-chain of A
// *     is copied, with the final cdr set to point to B.
// ************************************************************************

int append(int a, int b){
	int kopy,last,app;
	if(ATOMP(a) || !a) return b;
        last=gcons(0,CSR(a),CAR(a)) ;
        app=last;
// *                  A POINTER TO THE HEAD OF THE NEW LIST IS
// *                  STACKED SO THAT THE LIST WILL BE SAVED IF A
// *                  GARBAGE COLLECTION OCCURS.
//  10 
	while( a=CDR(a)){
        	if(ATOMP(a)) break;
        	kopy=gcons(0,CSR(a),CAR(a));
        	CDR(last)=kopy;
        	last=kopy ;
		} 
	CDR(last)=b;
	return app;
}

int strcmpnocase(char* nochg, char* maychg){
	char ch, chn, cht;
//return strcmp(nochg,maychg);
	while(1){
		ch = *nochg++;
		chn=*maychg++;
		if(ch == '\0' && chn == '\0') return 0;
		if(ch == '\0' || chn == '\0') return 1;
		if(ch == chn)continue;
		if(ch<'a'|| ch>'z'){ //ch not lower
			chn -= ('a'-'A');//make chn upper
			}
		else { //ch is lower
			ch -= ('a'-'A');//make ch upper
			}
		if(ch != chn)return 1;//no match
		}//while
}

int addToList(int item, int liststrt){
if(liststrt==0) return gcons(0,CSR(item),CAR(item));
else {
	int listp=liststrt, lprev=0;
	while(listp){
		if(CAR(item) == CAR(listp)) return 0;
		lprev=listp;
		listp = CDR(listp);
		}//while
	CDR(lprev)=gcons(0,CSR(item),CAR(item));
	return 0;
	}//else
}

int getIP(int lklst, int blst, int ipl[]){
	int lklt=lklst, blt, pp=0;
	while(lklt){
		blt=blst;
		int alent=CARINT(lklt);
		while(blt){
			if(CARINT(blt)==alent)ipl[pp++]=blt;
			blt=CDRINT(blt);
			}//while
		lklt=CDRINT(lklt);
		}//while
	return pp;
}

int chkIP(int lsh[],int lnum, int blst, int ipl[]){
	int blt, pp=0;
	for(int i=0; i<lnum; i++){
		blt=blst;
		int alent=CARINT(lsh[i]);
		while(blt){
			if(CARINT(blt)==alent)ipl[pp++]=blt;
			blt=CDRINT(blt);
			}//while
		}//for
	return pp;
}
