/* M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
   (c) 2005 All rights reserved.
   Read Terms of Use at http://mlp-xml.sourceforge.net.
   Contact medical_language_processing@gmail.com
*/
#include <stdlib.h>
#include <iostream.h>
#include <fstream.h>
#include <string.h>

// JR: added global filestream to be used in place
// all cout usage so that cout and getstptr(2)
// are the same stream.  11/02/11
fstream* coutP = 0;


extern void exitr(int, const char*);
extern fstream* getstptr(int);

#include "filedeflun.fcm"
#define OLD 1
#define NEW 2
#define SCRATCH 3
#include "common.fcm"
extern void closeall();
char unitvmp[40];
struct filectl { fstream * strmP; char * fname; short fstatus; short stpos;
short state; short newlin;};
static struct filectl filecontrl[9];

class myfstream : public fstream {
public:
  myfstream() {}
  
  void close() {
    cout << "closing down *coutP" << endl;
    fstream::close();
  }
};


// returns the stream pointer corresponding to lun
fstream* getstptr(int lun){
	return filecontrl[unitvmp[lun]-1].strmP;
}

void attachStdio(int lun){
  // JR: 11/2/02 was incorrectly returning cout cast 
  // to filestream, now returns a filestream.
  const char *filename ="cout.txt";
  filecontrl[1].strmP= new myfstream; 
  filecontrl[1].strmP->open(filename, ios::trunc|ios::out);
  filecontrl[1].fname = new char[strlen(filename)+1];
  strcpy(filecontrl[1].fname, filename);

  // JR: initialize coutP global variable, all usages of cout now
  // use coutP
  // cout << "initializing coutP" << endl;
  coutP = filecontrl[1].strmP;

  unitvmp[2]=2;
}

// - - - - - - - - - - - - - - - - - - - - 

// find an unused stream slot and assigns it to a a stream
int getstrm(int lun, const char *filename, int fstatus){
        // cout << "getstrm(" << lun << ")" << endl;
	fstream *stptr;
	for(int i=3;i<9;i++) if(filecontrl[i].strmP ==0){

	stptr = filecontrl[i].strmP = new fstream;
	unitvmp[lun] = i+1;

        if(fstatus == OLD)  // read only
		stptr->open(filename,ios::in);
        else {if(fstatus == SCRATCH) 
		stptr->open(filename,ios::in|ios::out);
	else // write only
		stptr->open(filename,ios::out);
		}
	if(stptr->fail()){
		return -1;
		delete stptr;
		}
	filecontrl[i].fname = new char[strlen(filename)+1];
	strcpy(filecontrl[i].fname, filename);
*coutP<<"opening file lun="<<lun<<" name="; // **debug
*coutP<<filecontrl[unitvmp[lun]-1].fname<<" with str ptr=";// **debug
*coutP<<filecontrl[unitvmp[lun]-1].strmP<<endl ; // **debug
	return 1;
	}
cerr << "cannot assign stream"<<endl;
//exitr(,10, "no stream");
return -1;
}

// - - - - - - - - - - - - - - - - - - - - 

void flushbuf(int lun){
	fstream * fst;
	if(filecontrl[unitvmp[lun]-1].newlin){
		fst=getstptr(lun);
		*fst<<endl;
	// *(filecontrl[unitvmp[lun]-1].strmP)<<endl;
		filecontrl[unitvmp[lun]-1].newlin=0;
		}
	return;
}

// - - - - - - - - - - - - - - - - - - - - 

void markbuf(int lun, int state){
	filecontrl[unitvmp[lun]-1].newlin=state;
	return;
}

// - - - - - - - - - - - - - - - - - - - - 

int querybuf(int lun){
return filecontrl[unitvmp[lun]-1].newlin;
}

// - - - - - - - - - - - - - - - - - - - - 

// closes the file and deletes a stream frees it from a unit number
void retstrm(int lun){
  if(lun==2) {
    cout << "retstrm(2)" << endl;
  return;
  }
*coutP<<"closing file lun="<<lun<<" name="<< // **debug
filecontrl[unitvmp[lun]-1].fname<<" with str ptr="<< // **debug
filecontrl[unitvmp[lun]-1].strmP<<endl ; // **debug
(filecontrl[unitvmp[lun]-1].strmP)->close();
if(lun>2)
delete filecontrl[unitvmp[lun]-1].strmP;
if(lun>2)
delete filecontrl[unitvmp[lun]-1].fname;
filecontrl[unitvmp[lun]-1].strmP = (fstream *)NULL ;
filecontrl[unitvmp[lun]-1].fname =(char *)NULL ;
unitvmp[lun] = 0;
return ;
}

// - - - - - - - - - - - - - - - - - - - - 

char trcchr;
int excon(int reqtyp, char trcphas){
	int setfil(int),retv;
//cerr<< " in excon request type "<< reqtyp<<endl;
	trcchr=trcphas;
switch(reqtyp){

	case 0:
// open the control file if not the standard input
void resetFillUnit(void);
resetFillUnit();
	setfil(1);
	return 0;

//  run type statement has been read
	case 1:
	trace=0; tracer=0; xref=0; house=0; fultrc=0; treesw=0; verbos=0;
	matprt=0; rarsw=0; repsw=0; fultre=0; rectrc=0; stream=0;
	xtrace=0; segsw=0; drawsw=0; xtresw=0; xdrwsw=0; echo=0; xon=0;
	xtracer=0; frztrc=0; wfftrc=0;

	closeall();

	if(extyp== PARSSN){
//     parsing runs
		return 0;
		}
	else {
//     runs which read in a parse tree
		return 0;
		}

	case 2: // open the grammar files
	if(extyp == PARSSN) return setfil(4); // parsing files
	else return setfil(5); // transformation files

	case 3: // open the dictionary files
	return setfil(3);

	case 4: // open the parse tree input and output files
 	retv=setfil(6);
	if(!treflo)treout=0;
	return retv;
 } // switch
 } // function

int setfil(int comtyp){
//    This routine reads the file names for the various grammars and symbol
//    tables and data files opens these files and sets the UNIT numbers
//    which are Parameters and defined in the file filedeflun.fcm.

int envget(const char *, int, int);
void REWIND(int);
	fstream * stptr, *getstrm(int);

switch(comtyp) {
//  The run has begun and the command file is opened and the error
//  and write file if any.are to be opened
case 1:
{
	char * envval;
	trefdi=TREDF1;
	trefdo=TREDF2;
	comndu= envget("PARINP", COMNDU, OLD);
	if(!comndu) exitr(12, "No command file");

	errmgf= envget("ERRORS",ERRMDF,NEW);

//   open and assign file for WRITE diag output

	if(writef==0) 
	writef=envget("DIAGFILE",WRITDIAGDF,NEW);

//   open and assign file for WRITE info output

	if(infofil==0) 
	infofil=envget("INFOFILE",WRITINFODF,NEW);

//   open and assign file for draw tree output

	if(drawtrfl==0) 
	drawtrfl=envget("DRAWTREFILE",DRTRDF,NEW);

//   open and assign file for maxtime sentences
	if(maxtimefl==0)
	maxtimefl=envget("MAXTIMEFILE",MXTIMDF,NEW);

	return 0;


//  a run type image has been received and the grammar and temp files 
//  must be set up
}
case 2:

//	drawtrfl = envget("DRAWTREFILE",DRTRDF,NEW);
	return 0;


case 3: //  open word dictionary files
	wdin = envget("WRDICTSEL",WDFLDF,OLD);
	if(wdin<=0){*coutP<<"No dictionary select file"<<endl;
	return -1;}

//  open separate WD symbol table file if any

	if(wdin) {
        	wdsymt = envget("WDSYMTTEMP",WDSTDF,OLD);
		} //if

//x      wdtmp= envget("WDTEMP",WDTMDF,SCRATCH) ;
	return 0;
case 4:
	grinfl =  envget("GRAMIN",GRINDF,OLD);
	if(grinfl <= 0) {
		*coutP<<"No GRAMMAR file"<<endl;
		return -1; }

	grinst=envget("GRAMIS",GRSTDF,OLD);
	if(grinst<0){*coutP<<"No grammar symbol table file"<<endl; return -1;}
	return 0;

case 5:
//  Assign and open transformation grammar files
{
static char trname[7]={'T','R','F','G','R','\0','\0'};
static char trstnam[8]={'T','R','F','G','S','T','\0','\0'};

//  open transformation grammar
	*(trname+5)=trcchr;
	grinfl = envget(trname,GRINDF,OLD);

	if(grinfl == 0) {
		*coutP<<"No GRAMMAR file"<<endl;
		return -1; }
//  open transformation grammar symbol table, if any
	*(trstnam+6)=trcchr;
	grinst =  envget(trstnam,GRSTDF,OLD) ;
	return 0;
}
case 6:
//   open and assign tree input file if any (transformation)
//   open and assign tree output file if any (trans and parse)
{
static char trtrinam[8]={'T','R','T','R','E','I','\0','\0'};
static char trtronam[8]={'T','R','T','R','E','O','\0','\0'};
	if(extyp==PARSSN){
	treflo = envget("PARTREE",trefdo,NEW); // parse tree out file
	if(treflo)treout=TREWWF;
	return 0;
	}
	*(trtrinam+6)=trcchr;
	trefli=envget(trtrinam,trefdi,OLD);
	if(trefli == -3) {
// an OPEN mark previous output as input
int tmp;
        	tmp=trefdi;
        	trefdi=trefdo;
        	trefdo=tmp;
        	trefli=trefdi;
        	REWIND(trefli);
		} //if
	else if(trefli < 0) exitr(13, "Cannot open tree input file");

	*(trtronam+6)=trcchr;
	treflo = envget(trtronam,TREFDO,NEW);
	if(treflo)treout=TREWWF;
#if 0
*    open and assign transformation debug files
      NAME="TRDBG"//CHR
      tredbg= envget(NAME,TRDBDF,NEW);
#endif
      return 0;
}

case 7:
//   Open file of barrier words if any
	segbwf = envget("SEGWORDS",SEGWDDF,OLD);
	return 0;
} // switch
}

// --------------------------------------------------------------------

// get the file name and open it
// return 0  no environment variable
//       -1  could not open file
int envget(const char *envVar, int defaultUnit, int fstatus){
	int OPEN(int, char *,int);
	char *envval;
	int funtp=0;
	if((envval = getenv(envVar)) == (char *)NULL) return 0;
	if(strcmp(envval,"OPEN")==0) return -3;
       	int opret = OPEN(defaultUnit,envval,fstatus);
	if(opret < 0) return -1;
       	funtp=defaultUnit;
	return funtp;
}

void CLOSE(int unitNum){
	retstrm(unitNum);
	return;
}

void REWIND(int unitNum){
	fstream * stptr; 
	stptr=getstptr(unitNum);
	stptr->seekg(0,ios::beg);
	return;
}

int OPEN(int unitNum, char * envval, int fstatus){
	int opencode = getstrm(unitNum, envval, fstatus);
	if(opencode<=0){
	*coutP <<"Unable to open file  " << envval << "\n";
	return -1;
	}
	return 0;
}

void closefiles(){ // close all open files
	delete filecontrl[1].fname;
for(int i=2; i<9; i++){
if(filecontrl[i].strmP != (fstream *)NULL)
(filecontrl[i].strmP)->close();
delete filecontrl[i].strmP;
	delete filecontrl[i].fname;
}
	return ;
}

void closeall(){ // close all open files
	if(treflo)CLOSE(treflo);
	if(trefli)CLOSE(trefli);
	if(segbwf)CLOSE(segbwf);
	return;
}
