*  M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
*  (c) 2005 All rights reserved.
*  Read Terms of Use at http://mlp-xml.sourceforge.net.
*  Contact medical_language_processing@gmail.com
*
      SUBROUTINE TDRAW
       
************************************************************************
*      
*     TDRAW draws the parse tree. TDRAW begins by trying to draw the
*     tree in a single frame (screen or page-full). If it doesn't fit,
*     it splits off a subtree, places its root node in array ROOT,
*     and tries redrawing the main tree (with the subtree replaced
*     by a link '<n>').  This is repeated until the main tree fits
*     in a frame.  The same process is then applied to each subtree
*     split off from the main frame.
*      
************************************************************************
       
      IMPLICIT INTEGER (A-Z)
      INCLUDE 'common.fcm'
      INCLUDE 'nodray.fcm'
      INCLUDE 'tdraw.fcm'
      INCLUDE 'grio.fcm'
      INCLUDE 'printr.fcm'
      INCLUDE 'nddfty.fcm'
      PARAMETER (IDTLIM=8)
      CHARACTER*80 IDNTFN(IDTLIM)
      COMMON /IDNTFC/IDNTFN
      COMMON/IDNTFN/IDTLEN
      CHARACTER*10 DEC
      CHARACTER*10 HEX
      LOGICAL PNFLG
      CHARACTER*150 BLKLIN
      DATA BLKLIN/'    '/
      INCLUDE 'asf.fcm'
      INCLUDE 'natdef.fcm'
      INCLUDE 'nodefs.fcm'
*      
      LSTCOL=MAXARL-1
*          longest line user wishes printed
      IF(RGHTCOL.NE.0.AND.DRTRFL.NE.0) THEN
        MAXPRT=RGHTCOL
        TREOTLUN=DRTRFL
      ELSE
        MAXPRT=RM(WUTIX(PRUNIT))-1
        TREOTLUN=6
      ENDIF
      MAXCOL=MAXPRT
      LINCNT=0
*                  initialize list of root nodes of frames
      NFRAME=0
      IFRAME=0
      tall=0
      ROOT(0)=1
*                  scan tree in preorder, assigning ordinal
*                  to each node(ordinal is saved in NDGCPS
*                  of node)
*      
      XR7=1
      LIST=0
      NANCRT=0
      KOUNT=0
      NTS=NAFLBL(NODATL)
*                  get name of present node
* 110 NDGCPS(XR7)=0
  110 NODE(XR7+8)=0                                                                 
      NAME=NODNAM(XR7)
      CALL EMPTY
*                  skip NULLs and empty SAs
      IF(.NOT.(NAME.EQ.'NULL' .OR. (NAME.EQ.'SA' .AND. PASS))) THEN
        NT=NTS
  111   IF(NAPNPA(NT).EQ.XR7) THEN
          KOUNT=KOUNT+1
*         NDGCPS(XR7)=KOUNT
          NODE(XR7+8)=KOUNT                                                         
          IF(NAME.EQ.'NON-EMPTY'.AND.NANCRT.LT.NONEM) THEN
            NANCRT=NANCRT+1
            ANONEM(NANCRT,1)=navala(NT)
            ANONEM(NANCRT,2)=UPXR7
          END IF
          GO TO 112
        else if(nandls(nt).eq.0.and.navala(nt).eq.xr7)then
          KOUNT=KOUNT+1
*         NDGCPS(XR7)=KOUNT
          NODE(XR7+8)=KOUNT                                                         
          IF(NAME.EQ.'NON-EMPTY'.AND.NANCRT.LT.NONEM) THEN
            NANCRT=NANCRT+1
            ANONEM(NANCRT,1)=napnpa(NT)
            ANONEM(NANCRT,2)=UPXR7
          END IF
          GO TO 112
        ELSE
          NT=NAFLBL(NT)
          IF(NT.NE.0) GO TO 111
        END IF
      END IF
  112 CONTINUE
      upxr7=xr7
      CALL ODOWN
      IF(PASS) GO TO 110
  120 CALL ORIGHT
      IF(PASS) GO TO 110
      CALL OUPONE
      IF(PASS) GO TO 120
*      
      do 121 ii=1,nancrt
      nj=ANONEM(ii,1)
*     NDGCPS(nj)=-(bit16*ii+NDGCPS(nj))
      NODE(nj+8)=-(bit16*ii+NDGCPS(nj))                                             
  121 continue
*      
      WRITE(UNIT=TREOTLUN,FMT='( ''SID= '',A)') SENTID
      WRITE(UNIT=TREOTLUN,FMT=133)(IDNTFN(I),I=1,IDTLEN)
  133 FORMAT(1x,A)
      LINCNT=IDTLEN+3
      IF(SOURSW) THEN
        WRITE(UNIT=TREOTLUN,FMT=133) (SOURCE(I),I=1,SRCLEN)
        LINCNT=LINCNT+SRCLEN
      END IF
*                  try to draw next frame
  100 CALL DRWFRM (*200,*600)
      tall=0
*                  subtree fits in frame, print it
  102 IF(LINCNT+NLINE.GT.55) THEN
        WRITE(UNIT=TREOTLUN,FMT='(''1'')')
        LINCNT=0
      END IF
*                                       find the longest line
      MLL=MIN(NCOL(1),LSTCOL)
      DO 157 I=2,NLINE
  157 MLL=MAX(MLL,MIN(NCOL(I),LSTCOL))
      LINCNT=LINCNT+NLINE
      IF(MLL.LE.MAXPRT) THEN
      DO 151 II=1,NLINE
      I=ILINPT(II)
  151 WRITE(UNIT=TREOTLUN,FMT=150) FRMLIN(I)(1:MIN(NCOL(II),LSTCOL))
  150 FORMAT((1X,A))
      ELSE
      DO 156 I=1,NLINE
  156 FRWKA(I)=0
      NGRPS=(MLL+MAXPRT-7)/(MAXPRT-6)
      LL1=-MAXPRT+1+6
      LL2=0
      NL1=1
      NL2=NLINE
      do 155 j=1,ngrps
      LL1=LL1+MAXPRT-6
      LL2=MIN(LL2+MAXPRT-6,MLL)
      IF(J.NE.1) THEN
      DO 141 II=NL1,NL2
  141 IF(FRWKA(II).LT.0) GO TO 142
  142 NL1=II
      DO 144 II=NL2,NL1,-1
  144 IF(FRWKA(II).LT.0) GO TO 145
  145 NL2=II
      END IF
      DO 153 II=NL1,NL2
      I=ILINPT(II)
      LL3=MIN(LL2,NCOL(II),LSTCOL)
      PNFLG=LL3.LT.MIN(NCOL(II),LSTCOL)
      IF(FRWKA(II).LE.0) THEN
        IF(FRWKA(II).EQ.0) THEN
          IF(PNFLG) THEN
            WRITE(UNIT=TREOTLUN,FMT=154) FRMLIN(I)(LL1:LL3),II
  154 FORMAT(1X,A,'\\',I2)
            FRWKA(II)=-1
          ELSE
            WRITE(UNIT=TREOTLUN,FMT=150) FRMLIN(I)(LL1:LL3)
            FRWKA(II)=1
          END IF
        ELSE
          IF(.NOT.PNFLG) THEN
            WRITE(UNIT=TREOTLUN,FMT=159) II,FRMLIN(I)(LL1:LL3)
  159 FORMAT(1X,I2,'\\',A)
            FRWKA(II)=1
          ELSE
            IF(J.NE.NGRPS) THEN
            WRITE(UNIT=TREOTLUN,FMT=158) II,FRMLIN(I)(LL1:LL3),II
  158 FORMAT(1X,I2,'\\',A,'\\',I2)
            ELSE
              WRITE(UNIT=TREOTLUN,FMT=148) II,FRMLIN(I)(LL1:LL3)
  148 FORMAT(1X,'\\',I2,A,' ...')
            END IF
          END IF
        END IF
      ELSE
      WRITE(UNIT=TREOTLUN,FMT='(''/'')')
      END IF
  153 CONTINUE
  155 continue
      END IF
*      
      MAXCOL=MAXPRT
*     WRITE(UNIT=TREOTLUN,FMT=150)(FRMLIN(I)(1:NCOL(I)),I=1,NLINE)
* 150 FORMAT(/(1x,a))
*                  if more frames, loop
      IFRAME=IFRAME+1
      IF(IFRAME.LE.NFRAME) GO TO 100
*      
*    print the node attributes
*      
  500 call prntif
      NTS=NAFLBL(NODATL)
      IF(NTS.NE.0) THEN
        WRITE(UNIT=TREOTLUN,FMT=567)
  567 FORMAT(/'    *** Node Attributes ***'/)
      IF(RGHTCOL.NE.0.AND.DRTRFL.NE.0) THEN
        CALL OTUSEL(DRTRFL)
      ENDIF
        XR7=1
  310   IF(NDGCPS(XR7).NE.0) THEN
          pnflg=.false.
          NT=NTS
*        collect and print the node attributes of the current node
  305     IF(NAPNPA(NT).EQ.XR7) THEN
            IF(NAVALA(NT).GE.0) THEN
              if(.not.pnflg) then
                call prntif
                call fill('Node ID: ')
                NAME=HEX(NDGCPS(XR7),2)
                call fill(NAME(1:2))
                call fill(':: ')
                pnflg=.true.
              else
                call fill(' ; ')
              end if
              call filltr(STNAME(CAR(NANAMA(NT))))
              IF(NAVALA(NT).NE.0) THEN
                IF(NANDLS(NT).EQ.0) THEN
                  call fill(' ->')
                  name=hex(NDGCPS(NAVALA(NT)),2)
                  call filltr(name(1:2))
                ELSE
                  call fill(' =')
                  IR=NAVALA(NT)
                  if(atomp(ir)) then
                    call fill(' ')
                    call filltr(stname(car(ir)))
                  else
  308               call fill(' ')
                    call filltr(STNAME(CAR(CAR(IR))))
                    IR=CDR(IR)
                    if(IR.NE.0) GO TO 308
                  END IF
                END IF
              END IF
            END IF
          END IF
          NT=NAFLBL(NT)
          IF(NT.NE.0) GO TO 305
        END IF
        CALL ODOWN
        IF(PASS) GO TO 310
  320   CALL ORIGHT
        IF(PASS) GO TO 310
        CALL OUPONE
        IF(PASS) GO TO 320
        call prntif
        IF(RGHTCOL.NE.0.AND.DRTRFL.NE.0) THEN
          CALL OTUSEL(PRUNIT)
        ENDIF
      ELSE
        PRINT*,'No node attributes'
      END IF
      PRINT 321
  321 FORMAT('1')
  600 RETURN
*                  subtree doesn't fit in frame, split off parts
*                  of subtree and start again
  200 IF(MAXCOL.EQ.LSTCOL) THEN
        if(tall.eq.0) then
          tall=tall+1
          call split(*222)
          go to 100
        end if
  222   PRINT *, 'Tree too wide ... cannot split into frames'
        GO TO 500
      END IF
      IF(NFRAME.EQ.MAXFRM) THEN
        PRINT *, ' *** Tree too large ... frame limit exceeded'
        GO TO 500
      END IF
      CALL SPLIT (*210)
      GO TO 100
*      
  210 MAXCOL=LSTCOL
      go to 100
*     RETURN
      END
*      
      SUBROUTINE DRWFRM (*,*)
       
************************************************************************
*      
*     DRWFRM tries to draw the subtree of the parse tree with root
*     ROOT(IFRAME) in the frame buffer.  DRWFRM returns normally if
*     the tree fits in the buffer;  it takes the alternate return if
*     the tree doesn't fit.
*      
************************************************************************
       
      IMPLICIT INTEGER (A-Z)
      INCLUDE 'common.fcm'
      INCLUDE 'nodray.fcm'
      INCLUDE 'tdraw.fcm'
      INCLUDE 'nddfty.fcm'
*                  SONFLG is true if we have gone down in the tree but
*                  have not yet drawn a son
      LOGICAL SONFLG
      CHARACTER*(WORDLEN) CTMP
      CHARACTER*3 OFC
      CHARACTER*10 DECSTR
      CHARACTER*35 LABELS
      CHARACTER*80 IDMPRT
      CHARACTER*10 DEC
      CHARACTER*10 HEX
      CHARACTER*(WORDLEN) SENTWD
      DATA LABELS /'123456789abcdefghijklmnopqrstuvwxyz'/
*                  off-frame connector
      INCLUDE 'asf.fcm'
      INCLUDE 'nodefs.fcm'
      INCLUDE 'natdef.fcm'
      SENTWD(X)=STNAME(SENTE1(X))
*      
   10 XR7=ROOT(IFRAME)
*                  clear frame buffer
      DO 20 I=1,MAXLIN
      ILINPT(I)=I
      FRMLIN(I)=' '
   20 NCOL(I)=0
*                  enter frame number (except for 0th frame) and
*                  root node
      NLINE=1
      ILINE=1
      START=1
      IF(NDGCPS(XR7).NE.0) THEN
        n5=and(abs(ndgcps(xr7)),bit16-1)
        CTMP=NODNAM(XR7)
        LL=TRMLEN(CTMP)
        IF(NDGCPS(XR7).LT.16) THEN
      NAME='*'//LABELS(n5:n5)//'*'//CTMP(1:MIN(LL,17))
          LL=LL+3
        ELSE
          DECSTR=HEX(n5,2)
          NAME='*'//DECSTR(1:2)//'*'//CTMP(1:MIN(LL,16))
          LL=LL+4
        END IF
        IF(LL.GT.20) LL=20
      ELSE
        NAME=NODNAM(XR7)
        LL=TRMLEN(NAME)
      END IF
      IF(IFRAME.EQ.0) THEN
        FRMLIN(ILINPT(1))=NAME
        NCOL(1)=LL
      ELSE
        FRMLIN(ILINPT(1))='<'//LABELS(IFRAME:IFRAME)//'>'
        NCOL(1)=3
        CALL SON (NAME,LL,*300)
      END IF
      SONFLG=.FALSE.
*                  get next node of parse tree, scanning in preorder
  100 CALL ODOWN
      IF(PASS) THEN
        SONFLG=.TRUE.
        GO TO 150
      END IF
  110 CALL ORIGHT
      IF(PASS) GO TO 150
  120 CALL OUPONE
      IF(.NOT.PASS) GO TO 310
      IF(.NOT.SONFLG) THEN
        ILINE=ILINE-2
      ELSE
        SONFLG=.FALSE.
      END IF
      IF(XR7.NE.ROOT(IFRAME)) GO TO 110
      RETURN
*                  have we reached the root of a subtree?
  150 J=0
      DO 160 I=1,NFRAME
      IF(ROOT(I).EQ.XR7) J=I
  160 CONTINUE
      IF(J.NE.0) THEN
*                       yes, print off-frame connector (*n*)
*                       and continue scan above this node
         OFC='<'//LABELS(J:J)//'>'
         IF(SONFLG) THEN
           CALL SON (OFC,3,*300)
           SONFLG=.FALSE.
         ELSE
           CALL BRO (OFC,3,*300)
         END IF
         GO TO 110
      END IF
*                  get name of present node
      CTMP=NODNAM(XR7)
      CALL EMPTY
*                  skip NULLs and empty SAs
      IF(CTMP.EQ.'NULL' .OR. (CTMP.EQ.'SA' .AND. PASS)) GO TO 110
*                  draw node
      LL=TRMLEN(CTMP)
      LB=0
      IF(NDGCPS(XR7).NE.0) THEN
        LA=NDGCPS(XR7)
        IF(LA.LT.0)THEN
          LB=-LA
          LA=AND(LB,(BIT16-1))
          LB=LB/BIT16
        END IF
        IF(LA.LT.16) THEN
          IDMPRT='*'//LABELS(LA:LA)//'*'//CTMP(1:MIN(LL,17))
          LL=LL+3
        ELSE
          DECSTR=HEX(LA,2)
          IDMPRT='*'//DECSTR(1:2)//'*'//CTMP(1:MIN(LL,16))
          LL=LL+4
        END IF
        IF(LL.GT.20) LL=20
      ELSE
        IDMPRT=CTMP
      END IF
        IF(LB.GT.0) THEN
          NAME=NODNAM(ANONEM(LB,2))
          IDMPRT(LL+1:LL+1)='['
          LC=TRMLEN(NAME)
          IDMPRT(LL+2:)=NAME
          IDMPRT(LL+2+LC:LL+2+LC)=']'
          LL=LL+2+LC+1
        END IF
      IF(SONFLG) THEN
        CALL SON (IDMPRT,LL,*200)
        SONFLG=.FALSE.
      ELSE
        CALL BRO (IDMPRT,LL,*200)
      END IF
*                  for atomic nodes (except for literal and null atomics
*                  draw words beneath node
      IF(AND(NDSPFB(XR7),ATOMIC+LTOMIC+OTOMIC).EQ.ATOMIC) THEN
        FW=NDWPNC(XR7)
        LW=NDWPCP(XR7)-1
        NAME=SENTWD (FW)
        L1=TRMLEN(NAME)
        IF(LW.EQ.FW) THEN
          NAME=SENTWD (FW)
          CALL SON (NAME,L1,*200)
          ILINE=ILINE-2
        ELSE IF(LW.GT.FW) THEN
          IDMPRT=NAME
          DO 190 IW=FW+1,LW
          IDMPRT(L1+1:L1+1)=' '
          NAME=SENTWD (IW)
          L2=TRMLEN(NAME)
          IDMPRT(L1+2:L1+1+L2)=NAME(1:L2)
  190     L1=L1+L2+1
          CALL SON (IDMPRT,L1,*200)
          ILINE=ILINE-2
        END IF
      END IF
*                  get next node
      GO TO 100
*                  errors
  300 PRINT *, ' *** Unexpected frame overflow'
      return 2
  310 PRINT *, ' *** Internal error in DRWFRM'
*                  tree doesn't fit in frame, return to split off
*                  part of tree
  200 RETURN 1
      END
      SUBROUTINE SON (LABEL,WIDTH,*)
       
************************************************************************
*      
*     SON adds a node with name LABEL to the tree being drawn,
*     immediately below the most recently drawn node.  SON
*     returns normally if the node fits in the current frame;
*     the alternate return is taken if it doesn't fit.
*      
************************************************************************
       
      IMPLICIT INTEGER (A-Z)
      INCLUDE 'common.fcm'
      INCLUDE 'nodray.fcm'
      INCLUDE 'tdraw.fcm'
      CHARACTER *(*) LABEL
*      
*                  check for sufficient space in frame ...
*                       at least 2 lines
*     if(iline+2.gt.maxlin) print *,'maxlin-over'
      IF(ILINE+2.GT.MAXLIN) RETURN 1
      IF(MAXCOL.LT.LSTCOL) THEN
*                       at least WIDTH columns
      IF(START+WIDTH-1.GT.MAXCOL) RETURN 1
      END IF
*                  if position of son is already occupied, push down
*                  rest of tree by two lines
      IF(START.GT.2 .AND. NCOL(ILINE+2).GE.START) THEN
*     if(iline+2.gt.maxlin) print *,'maxlin-over'
         IF(NLINE+2.GT.MAXLIN) RETURN 1
         DO 50 I=NLINE,ILINE+1,-1
*           FRMLIN(I+2)=FRMLIN(I)
            NCOL(I+2)=NCOL(I)
   50       ILINPT(I+2)=ILINPT(I)
*        FRMLIN(ILINE+2)=FRMLIN(ILINE+1)
*        NCOL(ILINE+2)=NCOL(ILINE+1)
         ILINPT(ILINE+1)=NLINE+1
         ILINPT(ILINE+2)=NLINE+2
         MNN=MIN(START-1,LSTCOL)
         FRMLIN(ilinpt(ILINE+1))(1:MNN)=
     *    FRMLIN(ILINPT(ILINE+3))(1:MNN)
         FRMLIN(ilinpt(ILINE+2))(1:MNN)=
     *    FRMLIN(ILINPT(ILINE+3))(1:MNN)
         NLINE=NLINE+2
      END IF
*                  insert vetical bar to connect son to parent
      IF(START.LE.LSTCOL) THEN
      FRMLIN(ilinpt(ILINE+1))(START:START)='|'
*                  insert son
      MMN=MIN(START+WIDTH-1,LSTCOL)
      FRMLIN(ilinpt(ILINE+2))(START:MMN)=LABEL
      END IF
      NCOL(ILINE+1)=START
      NCOL(ILINE+2)=START+WIDTH-1
      ILINE=ILINE+2
      NLINE=MAX(ILINE,NLINE)
      RETURN
      END
      SUBROUTINE BRO (LABEL,WIDTH,*)
       
************************************************************************
*      
*     BRO adds a node with the name LABEL to the tree
*     currently being drawn.  This node is added to the right of
*     the most recently drawn node.  BRO returns normally if the node
*     fits in the current frame;  the alternate return is taken if
*     it doesn't fit.
*      
************************************************************************
       
      IMPLICIT INTEGER (A-Z)
      INCLUDE 'common.fcm'
      INCLUDE 'tdraw.fcm'
      CHARACTER *(*) LABEL
*      
      HERE=NCOL(ILINE)
*                  BELOW = width of line below current line
      IF(ILINE.LT.NLINE) THEN
         BELOW=NCOL(ILINE+2)
      ELSE
         BELOW=0
      END IF
*                  the new node is placed 4 columns to the right of the
*                  end of the current line or the line below, whichever
*                  extends further (ignoring BELOW at this point would
*                  produce taller, narrower trees)
      START=MAX(HERE,BELOW)+4
*                  if node won't fit, return
      IF(MAXCOL.NE.LSTCOL) THEN
      IF(START+WIDTH-1.GT.MAXCOL) RETURN 1
      END IF
*                  add --- and node name to frame buffer
      IF(HERE+1.LE.LSTCOL) THEN
      FRMLIN(ilinpt(ILINE))(HERE+1:MIN(START-1,LSTCOL))=
     +   '--------------------------------------------------------------
     +-------------------------------------------------------------'
        IF(START.LE.LSTCOL) THEN
          MMN=MIN(LSTCOL,START+WIDTH-1)
          FRMLIN(ilinpt(ILINE))(START:MMN)=LABEL
        ELSE
          FRMLIN(ilinpt(ILINE))(LSTCOL:LSTCOL)='#'
        END IF
      ELSE
        FRMLIN(ilinpt(ILINE))(LSTCOL:LSTCOL)='#'
      END IF
      NCOL(ILINE)=START+WIDTH-1
*     if(ncol(iline).gt.lstcol)print*,'longline',ncol(iline)
      RETURN
      END
      SUBROUTINE SPLIT (*)
************************************************************************
*      
*     SPLIT is invoked when the current subtree will not fit in the
*     frame buffer;  XR7 points to the node of the parse tree we were
*     trying to draw when the frame buffer overflowed.  SPLIT identifies
*     a subtree of the current subtree and splits it off, adding its
*     root to the ROOT array.
*        We require that the root of the subtree which is split off be
*     an ancestor of node(XR7).  We first seek an ancestor node with
*     no siblings;  if none exists, we try to split at the parent of
*     node XR7.  If even this is not possible (because the parent of
*     XR7 is the root of the current subtree), or if the frame limit
*     is exceeded, the alternate return is taken.
*      
************************************************************************
       
      IMPLICIT INTEGER (A-Z)
      INCLUDE 'common.fcm'
      INCLUDE 'tdraw.fcm'
       
      TXR7=XR7
*                  go up in parse tree
  100 CALL OUPONE
      IF(XR7.EQ.ROOT(IFRAME)) GO TO 200
*                  try to go left and right;  if either is possible,
*                  continue ascending tree
      SXR7=XR7
      CALL OLEFT
      XR7=SXR7
      IF(PASS) GO TO 100
      CALL ORIGHT
      XR7=SXR7
      IF(PASS) GO TO 100
*                  neither is possible, add current node as root of
*                  a new frame and return
      NFRAME=NFRAME+1
      ROOT(NFRAME)=XR7
      RETURN
*                  cannot find any ancestor with no siblings, so try
*                  to split at parent of node which caused frame
*                  buffer to overflow
  200 XR7=TXR7
      CALL OUPONE
      IF(XR7.EQ.ROOT(IFRAME)) GO TO 210
      NFRAME=NFRAME+1
      ROOT(NFRAME)=XR7
      RETURN
*      
  210 XR7=TXR7
      RETURN 1
      END
