*  M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
*  (c) 2005 All rights reserved.
*  Read Terms of Use at http://mlp-xml.sourceforge.net.
*  Contact medical_language_processing@gmail.com
*
      SUBROUTINE SUBSUM (IXR7)

************************************************************************
*
*     SUBSUM writes into line the number and name of the words subsumed
*     by the node pointed to by IXR7.  If the node is incomplete the
*     characters ... are appended.
*
************************************************************************
      CALL SUBSUMP(IXR7,'_')
      RETURN
      END
*
      SUBROUTINE SUBSUMFB(IXR7)
      CALL SUBSUMP(IXR7,' ')
      RETURN
      END
*
      SUBROUTINE SUBSUMP(IXR7,SPCH)
      IMPLICIT INTEGER (A-Z)
      INCLUDE 'common.fcm'
      INCLUDE 'nodray.fcm'
      CHARACTER*1 SPCH
      CHARACTER*(WORDLEN) SENTWD
      INCLUDE 'nddfty.fcm'
      INCLUDE 'asf.fcm'
      INCLUDE 'nodefs.fcm'
      SENTWD(X)=STNAME(SENTE1(X))
*
      FRSTWD=NDWPNC(IXR7)
      LASTWD=NDWPCP(IXR7)
      IF(LASTWD.EQ.0) LASTWD=W
      LASTWD=LASTWD-1
      IF (FRSTWD.LE.LASTWD) THEN
        DO IW=FRSTWD,LASTWD
        NAME=SENTWD(IW)
        CALL FILLTR (NAME)
        CALL FILL (' ')
        ENDDO
      ELSE
        CALL FILL ('...')
        IWW=MIN(W+3,NWORD-1)
   42   IF (W.LE.IWW)THEN
          CALL FILL('-words after are-')
          DO IW=W,IWW
          NAME=SENTWD(IW)
          CALL FILLTR(NAME)
          CALL FILL (' ')
          ENDDO
        END IF
      END IF
      RETURN
      END
