*  M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
*  (c) 2005 All rights reserved.
*  Read Terms of Use at http://mlp-xml.sourceforge.net.
*  Contact medical_language_processing@gmail.com
*
      SUBROUTINE READST (UNITN,*,SEPSYM)
*
************************************************************************
*     READST reads in the symbol table from unit UNITN.
************************************************************************
*
      IMPLICIT INTEGER(A-Z)
      INCLUDE 'common.fcm'
      INCLUDE 'nodray.fcm'
      CHARACTER*1 CHR
      CHARACTER*(30-WORDLEN) EXCS
      LOGICAL SEPSYM
      INCLUDE 'asf.fcm'
*
      if(sepsym) then
    1 READ(UNIT=UNITN,FMT='(A1)',END=80)CHR
      IF(CHR.NE.'S') GO TO 1
      endif
      DO 10 I=1,128
   10 HASHLK(I)=0
      FREELK=0
*
*     Read in symbol table
*
      NREM=0
      DO 12 I=1,STLNTH
      READ(UNIT=UNITN,FMT=11,END=13)chr,STNAME(I),EXES,ITYPE,IREFC
   11 FORMAT(a1,A,A,2I6)
      if(chr.eq.'E') go to 13
*
      STTYPE(I)=ITYPE
   12 STREFC(I)=IREFC
      LENSY=STLNTH
    2 READ(UNIT=UNITN,FMT=11,END=13)chr,NAME,EXES,ITYPE,IREFC
      NREM=NREM+1
      GO TO 2
   13 LENSY=I-1
      IF(LENSY.EQ.0) THEN
        PRINT *, 'No symbol table'
        CALL EXITR (' No symbol table')
      END IF
      IF (NREM.EQ.0) THEN
        PRINT 14,LENSY
   14 FORMAT(' No. of symbols read = ',I4)
      ELSE
        PRINT 15,LENSY,NREM
   15 FORMAT(' No. of symbols read = ',I4,'  No. remaining  = ',I4)
      END IF
      DO 16 I=LENSY+1,STLNTH
      STNAME(I)=' '
      STTYPE(I)=0
   16 STREFC(I)=0
*
*        SET UP CHAINS OF ENTRIES WITH SAME HASH VALUE
*        (CHAINS ARE BUILT IN ALPHABETICAL ORDER SO THAT REFERENCE MAP
*        AND HOUSING DIRECTORY WILL APPEAR IN ALPHABETICAL ORDER)
*
      DO 20 I=1,LENSY
      IF(STNAME(I).NE.' ') THEN
      IH=IHASH(STNAME(I))
      J=HASHLK(IH)
      IF(J.EQ.0) GO TO 19
      IF(STNAME(J).GT.STNAME(I)) GO TO 19
   22 LASTJ=J
      J=STLINK(J)
      IF(J.EQ.0) GO TO 17
      IF(STNAME(J).LT.STNAME(I)) GO TO 22
   17 STLINK(I)=J
      STLINK(LASTJ)=I
      GO TO 20
*
   19 STLINK(I)=J
      HASHLK(IH)=I
      END IF
   20 CONTINUE
*
*        Chain together available space in symbol table
      DO 30 I=STLNTH,1,-1
      IF(STNAME(I).EQ.' ') THEN
      STLINK(I)=FREELK
      FREELK=I
      ENDIF
   30 CONTINUE
      RETURN
*    RETURN IF FILE IS EMPTY
   80 RETURN 1
*
*        ABORT ON END-OF-FILE
*
   90 PRINT 91,UNITN
   91 FORMAT(/51('*')/' *** SYMBOL TABLE not found on file ',
     =   I1,' -- RUN ABORTED'/' ',51('*'))
      CALL EXITR(' No symbol table')
   93 ISTL=STLNTH
      PRINT 94,I,ISTL
   94 FORMAT(/' **** Symbol table length =',I6,', Allocated space = ',
     1I6,' Run aborted')
      CALL EXITR('SYMTSM')

      ENTRY WRITST(UNITN,*)
*
************************************************************************
*
*     WRITST writes the symbol table out onto unit UNITN.
*
************************************************************************
*
*
*        WRITE OUT SYMBOL TABLE (UP TO LAST OCCUPIED ENTRY)
*
      EXCS=' '
      DO 100 I=STLNTH,1,-1
  100 IF(STNAME(I).NE.' ') GO TO 110
  110 LENG=I
      WRITE(UNIT=UNITN,FMT='(''SYMBOL TABLE'')')
      DO 120 I=1,LENG
      ITYPE=STTYPE(I)
      IREFC=STREFC(I)
  120 WRITE(UNIT=UNITN,FMT=111)STNAME(I),EXCS,ITYPE,IREFC
  111 FORMAT(1x,A,A,2I6)
      PRINT 201,LENG,UNITN
  201 FORMAT(/' Output symbol length = ',I5,'   written on unit ',I3)
      RETURN
      END
