*  M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
*  (c) 2005 All rights reserved.
*  Read Terms of Use at http://mlp-xml.sourceforge.net.
*  Contact medical_language_processing@gmail.com
*
      SUBROUTINE PAKNAM (CHR,NCHR,ERRFLG)
*
************************************************************************
*
*     packs the following name in the input stream into variable -NAME-.
*     A name is
*        if the current character is not ', the current character and
*           all subsequent letters, digits, and -
*        if the current character is a ', all subsequent characters up
*           to (but not including) the next ' not immediately followed
*           by another ' (a ' immediately followed by another ' is
*           packed as a single ').
*     On entry, CHR should contain the current character in the input
*     stream.  On exit, it will contain the next character following
*     the name.  An ERROR exit, indicated by ERRFLG=.TRUE., occurs if
*     the first character is a blank or if there is no close '.
*
************************************************************************
*
      IMPLICIT INTEGER (A-Z)
      INCLUDE 'chartrn.fcm'
      CHARACTER*1 CHR
      LOGICAL ERRFLG
*
      ERRFLG=.FALSE.
      CALL PAKSET
      IF(NCHR.EQ.SEOR.OR.NCHR.EQ.BLANK)GO TO 90
      IF(NCHR.NE.IAPOS) THEN
   10 CALL PACKEM (CHR)
      CALL GETCHR (CHR,NCHR)
      IF(NCHR.EQ.SEOR)GO TO 90
      IF(NCHR.LE.IALPHA.OR.NCHR.EQ.SHYPH)GO TO 10
      RETURN
      ENDIF
   20 CALL GETCHR (CHR,NCHR)
      IF(NCHR.EQ.SEOR)GOTO90
      IF(NCHR.NE.IAPOS) GO TO 25
      CALL GETCHR (CHR,NCHR)
      IF(NCHR.NE.IAPOS) RETURN
   25 CALL PACKEM (CHR)
      GO TO 20
   90 ERRFLG=.TRUE.
      RETURN
      END
