*  M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
*  (c) 2005 All rights reserved.
*  Read Terms of Use at http://mlp-xml.sourceforge.net.
*  Contact medical_language_processing@gmail.com
*
      SUBROUTINE NAMLIT (NM)

************************************************************************
*
*     NAMLIT generates the external representation of the literal named
*     -NM-, and stores this representation back into -NM-.  It does so
*     by surrounding the character string by '...' and replacing any '
*     in the string by two successive 's.  If the resulting string would
*     exceed 20 characters, it is truncated and a warning is printed.
*
************************************************************************

      INCLUDE 'common.fcm'
      INCLUDE 'nodray.fcm'
      CHARACTER*(WORDLEN) NM, NTEMP
      CHARACTER*1 CHR
      NTEMP=NM

*        External representation is built in -NAME- by subr. -PACKEM-
      CALL PAKSET
      CALL PACKEM ('''')
*        K counts number of characters packed
      K=1
*        N indexes over characters in original string
      LAST=TRMLEN(NTEMP)
      DO 20 N=1,LAST
*        Get nth character of string
      CHR=NTEMP(N:N)
      IF(K.EQ.(WORDLEN-1).OR.(K.EQ.(WORDLEN-2).AND.CHR.EQ.''''))
     *GO TO 30
      CALL PACKEM (CHR)
      K=K+1
      IF(CHR.EQ.'''') THEN
        CALL PACKEM ('''')
        K=K+1
      END IF
   20 CONTINUE
      GO TO 40
   30 PRINT 31, NTEMP
   31 FORMAT(' * LITERAL ",A," Too long to write--truncated')
   40 CALL PACKEM ('''')
      NM=NAME
      RETURN
      END
