*  M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
*  (c) 2005 All rights reserved.
*  Read Terms of Use at http://mlp-xml.sourceforge.net.
*  Contact medical_language_processing@gmail.com
*
      SUBROUTINE LKED(GRMOBF,GRMSTF)
*
      IMPLICIT INTEGER(A-Z)
      INCLUDE 'common.fcm'
      INCLUDE 'nodray.fcm'
      INCLUDE 'grio.fcm'
      INCLUDE 'gencom.fcm'
      INCLUDE 'printr.fcm'
      PARAMETER (RNMELG=300)
      CHARACTER*(WORDLEN) RNAME(RNMELG),NILNM
      PARAMETER (RECLIM=2000)
      INTEGER FRSTIG(RECLIM)
      EQUIVALENCE  (NODE(1),FRSTIG)


      PARAMETER (NUMGEN=13)
      CHARACTER*(WORDLEN) GONAME(NUMGEN)
      PARAMETER (LXLEN=15)
      CHARACTER*10 LXSYM(LXLEN)
      COMMON/LEXLST/LXADR(LXLEN)
      COMMON/LEXSYM/LXSYM
      COMMON/LKDBLK/LRSRVD
      COMMON/LOADCM/SOL,SOS,LOCREC
      COMMON /INITAL/ANYTHP,MAT
      CHARACTER*1 NUMRIC(10)
      CHARACTER*3 NAMTYP(16)
*      added by Nhan
      CHARACTER*1 LORS
      PARAMETER (ISGWTH=1, INTWTH=3, IFDWTH=15)
*     XREF CONTROLS PRINTING OF SYMBOL AND LITERAL CROSS REFERENCE TABLE
*     HOUSE controls printing of housing directory
*     LRSRVD -- WILL CONTAIN POINTER TO LIST OF LISTS IN GRAMMAR
*               (USED IN PARSERS (I) AND (II) TO ENTER RESERVED WORDS
*               INTO NEXT LEVEL GRAMMAR)
      DATA NILNM/'NIL'/
      DATA NUMRIC/'0','1','2','3','4','5','6','7','8','9'/
      DATA NAMTYP/'DEF','LEX','G/O','ADD','ATT','REG','TYP',7*'   ',
     =  'INT','   '/
      DATA GONAME/'ELEM','SYM','SAVEPTR','PTR','SAVELIST','LOOKUP',
     ='CONS','CAT','TXT','TYP','IDIOM','DERIV','END'/
      INCLUDE 'asf.fcm'
*
*               SPECIAL FIELD OF THE HEAD OF A BNF DEFINITION
*
*     INITIALIZE LIST SPACE POINTERS
*
      TLIST=.FALSE.
      LRSRVD=0
      CALL ZINIT
      RDLINT=.FALSE.
      MAT=0
      DO I=1,LXLEN
      LXADR(I)=0
      ENDDO
*                            I. READ IN GRAMMAR
*                                A. INITIALIZE SYMBOL TABLE
*                                  1. READ IN GRAMMAR SYMBOL TABLE FILE
      IF(GRMSTF.NE.0) THEN
*            grammar s.t. on separate unit
        REWIND (UNIT=GRMSTF)
        PRINT 23,GRMSTF
* skip past the line SYMBOL TABLE
        CALL READST(GRMSTF,*1030,.TRUE.)
        CLOSE(UNIT=GRMSTF)
        GRMSTF=0
      ELSE
        PRINT 23,GRMOBF
  23  FORMAT(/'GRAMMAR SYMBOL TABLE read from UNIT',I3)
        CALL READST(GRMOBF,*1030,.TRUE.)
      END IF
      REWIND (UNIT=GRMOBF)
*                         2. SET ADDRESSES OF SYMBOL AND LITERAL HEADS
*                                      TO ZERO
      DO I=1,STLNTH
      STADDR(I)=0
      STREFC(I)=0
      ENDDO
*                                    3. CREATE HEAD FOR SYMBOL -NIL- IN
*                                       IN WORD 0 OF LIST SPACE
      IGNORE=GCONS(0,HEAD,GETST(NILNM,0))
*                                    4.  IF RUNNING LISP, CREATE HEADS
*                                         LISP ATOMS
      NREC=0
      PRINT *,'grammar read-in begins.'
*                               B. READ GRAMMAR RECORD
*                                  1. IF WE HIT EOF, GO TO II.
  210 CALL GRREAD(GRMOBF,*400)
*                                     (A) SKIP  COMMENT RECORDS
      IF(TOST .EQ. 0) GO TO 210
      CALL INIGET
*                                  2. SAVE RECORD NAME
      NREC=NREC+1
      if(nrec.gt.reclim)call exitr('*** RECLIM too small')
      RNAME(NREC)=RCDNAM
      FRSTIG(NREC)=IG+1
*                                  4. SAVE CURRENT POSN IN GRAMAR
      LOCREC=IG
*                               C. LOAD RECORD INTO LIST SPACE
      LOCHD=LOAD(.FALSE.)
      IF(LOCHD.LE.0) THEN
        IF(LOCHD.LT.0) THEN
          PRINT 241, RCDNAM
  241 FORMAT(' *** invalid interpret field in record ',A)
        ELSE
          PRINT 246, RCDNAM
  246 FORMAT(' *** no head in record ',A)
        END IF
      ELSE
      END IF
*                               D. RECORD ADDRESS OF HEAD OF RECORD
      INDEX=CAR(LOCHD)-SOS
      IF(STADDR(INDEX).NE.0) THEN
*                                  2. IF SYMBOL IS ALREADY DEFINED,
*                                     STORE NEW VALUE IN CSR OF OLD HEAD
*                                     AND ISSUE WARNING (EXCEPT FOR BNF
*                                     DEFINITIONS.
        ITYPE=AND(STTYPE(INDEX),15)
        IF(ITYPE .NE. DTYPE .AND. CDR(STADDR(INDEX)) .NE. 0)
     *PRINT 251,STNAME(INDEX)
  251 FORMAT(' *** duplicate definition for ',A,' (last definition used
     *)')
          CDR(STADDR(INDEX))=CDR(LOCHD)
        ELSE
          STADDR(INDEX)=LOCHD
        END IF
*                                  3. IF LIST, SAVE ADDRESS ON LRSRVD
*                                     (LIST OF LISTS)
      IF(TOST .EQ. 5) THEN
        LRSRVD=GCONS(LRSRVD,0,LOCHD+1)
*                               E. FOR RESTRICTION RECORDS:
      END IF
      GO TO 210
*
  400 PRINT 401, NREC
  401 FORMAT(/' grammar read-in complete.'//1X,I5,' records passed.')
        CLOSE(UNIT=GRMOBF)
        GRMOBF=0
      FRSTIG(NREC+1)=IG+1
*                            II. CREATE HEADS FOR SYMBOLS OF
*                                CERTAIN TYPES
      IST=STLNTH
*                               A. LOOP THROUGH SYMBOL TABLE
*                                  1. LOOP THROUGH HASH TABLE
  420 KHASH=0
  425 KHASH=KHASH+1
      IF(KHASH.GT.128) GO TO 500
      INDEX=HASHLK(KHASH)
      IF(INDEX .EQ. 0) GO TO 425
      GO TO 435
*                                  2. LINK THROUGH SYMBOL TABLE LIST
*                                     FOR THIS HASH VALUE
  430 INDEX=STLINK(INDEX)
      IF(INDEX .EQ. 0) GO TO 425
*                               B. CREATE HEAD
*                                  1. SKIP IF NO TYPE OR IF SYMBOL IS
*                                     WD LINE NUMBER
  435 ITYPE=AND(STTYPE(INDEX),15)
      IF(ITYPE .EQ. 0 .OR. ITYPE .EQ. SPTYPE) GO TO 430
      BITSS=0
      NAME=STNAME(INDEX)
      ADDR=STADDR(INDEX)
      IF(ITYPE .NE. ADTYPE) THEN
        IF(ITYPE .EQ. DTYPE) THEN
*                                  2. FOR SYMBOLS OF TYPE DEFINITION,
*                                     AND TYPELIST
*                                     (A) COPY BITSS INDICATING LISTS OF
*                                         WHICH SYMBOL IS A MEMBER TO
*                                         SPECIAL FIELD OF HEAD
          BITSS=AND(STTYPE(INDEX)/16,KOPY)
        ELSE IF(ITYPE .EQ. TPTYPE) THEN
*                                     (B) create type list -ATOM- if not
*                                         present in grammar
          IF(NAME .EQ. 'ATOM') THEN
            IF(ADDR .EQ. 0) THEN
              ADDR=GCONS(0,HEAD,0)
              STADDR(INDEX)=ADDR
            END IF
            BITSS=ATOMIC
          END IF
        ELSE
*                                  3. FOR SYMBOLS OF TYPES ATOMIC, GEN/
*                                     OPERATOR, REGISTER, CONSTANT,
*                                     AND LITERAL, CREATE HEAD, UNLESS
*                                       ALREADY CREATED BY DEFLAT)
          IF(ADDR .EQ. 0) THEN
            ADDR=GCONS(0,HEAD,0)
            STADDR(INDEX)=ADDR
          END IF
          IF(ITYPE .NE. 16 .AND. ITYPE .NE.ATTYPE) THEN
            IF(ITYPE .EQ. LTYPE) THEN
*                                     (A) FOR ATOMIC SYMBOLS, LOOK UP
*                                         NAME ON LXLIST AND REPLACE
*                                         ENTRY IN LXLIST WITH POINTER
*                                         TO HEAD
               DO I=1,LXLEN
               IF(LXSYM(I) .EQ. NAME)LXADR(I)=ADDR
               ENDDO
               BITSS=ATOMIC
*                                        (1) FLAG SYMBOLS BEGINNING
*                                            NULL... AS NULL ATOMICS
               IF(NAME(1:4) .EQ. 'NULL' ) BITSS=ATOMIC+OTOMIC
            ELSE IF(ITYPE .EQ. GTYPE) THEN
*                                     (B) FOR GENERATORS AND OPERATORS,
*                                         LOOK NAME UP ON GONAME
*                                         (1) FOR GENERATOR, SAVE  NUMBER
*                                           IN DECREMENT FIELD OF HEAD
              DO I=1,NUMGEN
              IF(NAME .EQ. GONAME(I)) GO TO 445
              ENDDO
       Print *,'Error in gtype'
       stop
  445         CDR(ADDR)=I
            ELSE IF(ITYPE .EQ. INTYPE) THEN
*                                     (D) FOR CONSTANTS, STORE VALUE IN
*                                         SUCCESSOR FIELD OF HEAD
              CDR(ADDR)=STTYPE(INDEX)/16
              BITSS=CNSTBT
            ELSE
              CALL FILL ('***** symbol ')
              CALL FILLTR (NAME)
              CALL FILL (' of invalid type')
              CALL PRNT
              GO TO 430
            END IF
          END IF
        END IF
      END IF
*                                  4. STORE FLAG BITSS IN SPECIAL OF
*                                     HEAD
  460 IF(ADDR .NE. 0)CSR(ADDR)=HEAD+BITSS
*                               C. IF COMPILING COPY NAME INTO HIGH
*                                  PART OF STNAME
        CALL ADDCNT (IST,STLIM,'ST',1)
        INM=IST
        STNAME(IST)=STNAME(INDEX)
*                               D. INSERT POINTER TO NAME IN ADDRESS
*                                  FIELD OF HEAD
      IF(ADDR .NE. 0)CAR(ADDR)=INM
*                               E. FOR REFERENCE TABLE, WRITE OUT
*                                  TYPE OF SYMBOL
  468 IF(XREF)WRITE (UNIT=REFFIL,FMT=470) NAME,NAMTYP(ITYPE)
  470 FORMAT('S',A20,'T',A3)
      GO TO 430
*                            III. STORE SYMBOL AND LITERAL ADDRESSES IN
*                                 GRAMMAR
*                               A. LOOP OVER MAJOR RECORDS
 500  DO 580 IREC=1,NREC
      FW=FRSTIG(IREC)
      LW=FRSTIG(IREC+1)-1
*                               C. SCAN RECORD FOR SYMBOL AND LITERAL
*                                  REFERENCES
      DO 560 IW=FW,LW
      IF(.NOT.ATOMP(IW)) THEN
*                                  1. DO FIRST SPECIAL, THEN ADDRESS
*                                     FIELD
      DO  K=1,2
      IF(K .EQ. 1) THEN
        ADDR=CSR(IW)
      ELSE
        ADDR=CAR(IW)
      END IF
      IF(ADDR.GE.SOS) THEN
        IF(ADDR.LT.SOL) THEN
*                                  2. PROCESS SYMBOL REFERENCE
          NST=ADDR-SOS
          ADDR=STADDR(NST)
          IF(ADDR .EQ. 0) PRINT 535, STNAME(NST),RNAME(NREC)
  535 FORMAT(' *** Undefined symbol ',A,' referenced in ',A)
          LORS='S'
        ELSE
*                                  3. PROCESS LITERAL REFERENCE
          NST=ADDR-SOL
          ADDR=STREFC(NST)
          IF(ADDR .EQ. 0) THEN
*                                     (A) CREATE LITERAL HEAD IF THIS IS
*                                         FIRST REFERENCE
              CALL ADDCNT (IST,STLIM,'ST',1)
              INM=IST
              STNAME(IST)=STNAME(NST)
            ADDR=GCONS(0,(HEAD+ATOMIC+LTOMIC),INM)
            STREFC(NST)=ADDR
          END IF
          LORS='L'
      END IF
*                                  4. STORE ADDRESS INTO LIST ELEMENT
      IF(K .EQ. 1) THEN
        CSR(IW)=ADDR
      ELSE
        CAR(IW)=ADDR
      END IF
*                                  5. write record for reference table
      IF(XREF) WRITE (UNIT=REFFIL,FMT=552)LORS,STNAME(NST),RNAME(nREC)
  552 FORMAT(A1,A,1X,A)
      END IF
      ENDDO
      END IF
  560 CONTINUE
  580 CONTINUE
*
      PRINT 585, IG
  585 FORMAT(/' Grammar occupies',I6,' list-space items')
      NASFW=IG+2
*
 1000 N=0
      DO I=1,STLNTH
      IF(STNAME(I) .NE. ' ') THEN
      N=N+1
      IF(STTYPE(I) .EQ. 0) STTYPE(I)=IGTYPE
      END IF
      ENDDO
      PRINT 1020, N, STLNTH
 1020 FORMAT(1X,I5,' of ',I5,' SYMBOL TABLE entries used '/'1')
      RETURN
 940  CALL EXITR('EOF encountered while reading symbol table')
 1030 CALL EXITR(' *** Object grammar file empty -- run aborted *')
      END
