      SUBROUTINE GETCHR (CHR,TYPE)
***********************************************************************
*     GETCHR returns in CHR the next character from the input stream.
*     After column 80 of a line, GETCHR returns a blank and then
*     column 1 of next line.  IF SOURSW=.TRUE., input lines are
*     accumulated in the array SOURCE.

*     Exceptions:   If the next line begins with an *, GETCHR
*     returns SEOR (end of line indicator) and then, on the
*     next call, column 1 of the new line.  If an end-of-file is read,
*     GETCHR returns SEOR Is returned and terminates on next call.
***********************************************************************
      IMPLICIT INTEGER(A-Z)
      SAVE COLUMN,CARD
      INCLUDE 'chartrn.fcm'
      DIMENSION K(65)
      CHARACTER*80 CARD
      CHARACTER*1 CHR
      PARAMETER (WORDLEN=28)
      INCLUDE 'grio.fcm'
      DATA COLUMN/80/
      DATA K/BLANK,3*ISPEC,SDOLR,2*ISPEC,IAPOS,4*ISPEC,ICOMMA,SHYPH,
     +IPER,ISPEC,0,1,2,3,4,5,6,7,8,9,7*ISPEC,26*IALPHA,6*ISPEC/
      COLUMN=COLUMN+1
      IF(COLUMN.LE.80) THEN
        CHR=CARD(COLUMN:COLUMN)
      ELSE IF(COLUMN.EQ.81) THEN
        CHR=' '
        TYPE=EOL
        RETURN
      ELSE
        CALL GETLIN(CARD,.TRUE.,*10)
        IF(SOURSW) THEN
          CALL ADDCNT (SRCLEN,SRCLIM,'SOURCE',1)
          SOURCE(SRCLEN)=CARD
        END IF
        COLUMN=1
        CHR=CARD(1:1)
      END IF
      N=ICHAR(CHR)-32
      IF (N.EQ.TAB-32) THEN
        TYPE=K(33)
        CHR=' '
      ELSE
        IF (N.LT.0.OR.N.GT.65) THEN
          TYPE=IBAD
        ELSE
          TYPE=K(N+1)
        ENDIF
      END IF
      RETURN
*
  10  TYPE=SEOR
      CHR=' '
      RETURN

***********************************************************************
*     NEWLIN advances to the next card in the input stream.
***********************************************************************

      ENTRY NEWLIN
      CALL GETLIN (CARD,.FALSE.,*20)
      IF(SOURSW) THEN
        CALL ADDCNT (SRCLEN,SRCLIM,'SOURCE',1)
        SOURCE(SRCLEN)=CARD
      END IF
      COLUMN=0
      RETURN
*
  20  CALL EXITR('**** Internal error in NEWLINE')
*
      ENTRY SKTCNT
  22  IF(CARD(1:1).EQ.'*') RETURN
      CALL GETLIN (CARD,.FALSE.,*23)
      GO TO 22
  23  CALL EXITR('**** Internal error in SKTCNT')
***********************************************************************
*     GETSET resets the input scan to the first column of the current
*     line.
***********************************************************************

      ENTRY GETSET
      COLUMN=0
      RETURN
      END
*
      SUBROUTINE GETLIN (LINGOT,CONTIN,*)
      IMPLICIT INTEGER (A-Z)
      SAVE LINBUF,INFLSV
      INCLUDE 'common.fcm'
      INCLUDE 'nodray.fcm'
      INCLUDE 'printr.fcm'
      CHARACTER*80 LINGOT,LINBUF
      CHARACTER*1 FC
      LOGICAL EOF,BREAK,CONTIN,ALINFL
      DATA ALINFL/.FALSE./,EOF/.FALSE./,BREAK/.FALSE./
      IF(EOF) THEN
        CALL EXITR('----END OF FILE encountered on input----')
      END IF
      IF(BREAK) THEN
        BREAK=.FALSE.
        LINGOT=LINBUF
        GO TO 30
      END IF
   10 READ(SINPSR,FMT=21,END=90) LINBUF
   21 FORMAT(A80)
      LL=TRMLEN(LINBUF)
* skip blank lines
      IF(LL .EQ. 0) GO TO 10
      FC=LINBUF(1:1)
* make control images upper case
      IF(FC.NE.'*') THEN
      LINGOT=LINBUF
      ELSE
        DO I=1,80
*       IF(LINBUF(I:I).GE.'a'.AND.LINBUF(I:I).LE.'z') THEN
*         LINGOT(I:I)=CHAR(ICHAR(LINBUF(I:I))-32)
*       else
          LINGOT(I:I)=LINBUF(I:I)
*       END IF
      ENDDO
      END IF

*           ECHO LINE JUST READ

   30 PRINT 15, LINBUF(1:LL)
   15 FORMAT(1X,A)
      RETURN

   90 CONTINUE
      IF(ALINFL) THEN
      ALINFL=.FALSE.
      SINPSR=INFLSV
      GO TO 10
      END IF
        CALL EXITR('EOF ENCOUNTERED ON INPUT')
* This entry is used to change the file which is being
* read by the GETLIN call.
      ENTRY GTLNSF(ALIN)
      INFLSV=SINPSR
      SINPSR=ALIN
      ALINFL=.TRUE.
      RETURN
      entry outimag(fileot)
      write(unit=fileot,fmt='(a)') linbuf(1:trmlen(linbuf))
      return
      END
