*  M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
*  (c) 2005 All rights reserved.
*  Read Terms of Use at http://mlp-xml.sourceforge.net.
*  Contact medical_language_processing@gmail.com
*
      SUBROUTINE GETFLD (FIELD,WIDTH)
************************************************************************
*   
*        GETFLD extracts the next WIDTH bits from the object buffer
*        and returns them in FIELD .
*   
************************************************************************

      IMPLICIT INTEGER (A-Z)
      PARAMETER(BPW=32)
      INCLUDE 'common.fcm'
      INCLUDE 'grio.fcm'
      INTEGER BITLFT,OBJWRD,MASK(15)
      SAVE BITLFT,OBJWRD
      DATA MASK /1,3,7,15,31,63,127,255,511,1023,2047,4095,8191,16383,
     *32767/
*           BPW = bits per word in object buffer

      IF(WIDTH .LE. BITLFT)THEN 
        ISX=OBJECT(OBJWRD)
        BITLFT=BITLFT-WIDTH
        IF(BITLFT.GT.0) ISX=RSHIFT(ISX,BITLFT)
        FIELD=AND(ISX,MASK(WIDTH))

      ELSEIF (BITLFT.EQ.0)THEN
        BITLFT=BPW-WIDTH
        OBJWRD=OBJWRD+1
        IF(OBJWRD.GT.OBJLEN) CALL EXITR('Object buffer empty')
        FIELD=AND(RSHIFT(OBJECT(OBJWRD),BITLFT),MASK(WIDTH))
      ELSE
*                     field is split between two words
        BIT2GO=WIDTH-BITLFT
        ISX=LSHIFT(AND(OBJECT(OBJWRD),MASK(BITLFT)),BIT2GO)
        OBJWRD=OBJWRD+1
        IF(OBJWRD.GT.OBJLEN) CALL EXITR('Object buffer empty')
        BITLFT=BPW-BIT2GO
        FIELD=AND(RSHIFT(OBJECT(OBJWRD),BITLFT),MASK(BIT2GO))+ISX
      ENDIF

      RETURN


*-----------------------------------------------------------------------
*   
*        INIGET IS THE INITIALIZATION ENTRY FOR GETFLD.
*   
*-----------------------------------------------------------------------

      ENTRY INIGET
      OBJWRD=0
      BITLFT=0
      RETURN
      END

      SUBROUTINE PUTFLD (FIELD,WIDTH)

************************************************************************
*   
*        PUTFLD inserts 'FIELD' into the next 'WIDTH' bits of the OBJECT
*        buffer.
*   
************************************************************************
      IMPLICIT INTEGER (A-Z)
      PARAMETER(BPW=32)
      INCLUDE 'common.fcm'
      INCLUDE 'grio.fcm'
      INTEGER BITLFT,OBJWRD,MASK(15)
      SAVE BITLFT,OBJWRD
      DATA MASK /1,3,7,15,31,63,127,255,511,1023,2047,4095,8191,16383,
     *32767/

      IF(WIDTH.LE.BITLFT) THEN
        BITLFT=BITLFT-WIDTH
        ISX=RSHIFT(OBJECT(OBJLEN),BITLFT)+FIELD
        OBJECT(OBJLEN)=LSHIFT(ISX,BITLFT)
      ELSE IF(BITLFT.EQ.0) THEN
        BITLFT=BPW-WIDTH
        OBJLEN=OBJLEN+1
        IF(OBJLEN.GT.OBJLIM) CALL EXITR('OBJECT BUFFER FULL')
        OBJECT(OBJLEN)=0
        OBJECT(OBJLEN)=LSHIFT(FIELD,BITLFT)
      ELSE
*                     FIELD MUST BE SPLIT BETWEEN TWO WORDS
        BIT2GO=WIDTH-BITLFT
        ISX=RSHIFT(FIELD,BIT2GO)
        OBJECT(OBJLEN)=OBJECT(OBJLEN)+ISX
        OBJLEN=OBJLEN+1
        IF(OBJLEN.GT.OBJLIM) CALL EXITR('OBJECT BUFFER FULL')
        OBJECT(OBJLEN)=0
        BITLFT=BPW-BIT2GO
        OBJECT(OBJLEN)=LSHIFT(AND(FIELD,MASK(BIT2GO)),BITLFT)
      END IF
      RETURN

*   -----------------------------------------------------------------------
*   
*        INIPUT is the initializing entry for PUTFLD.
*   
*   -----------------------------------------------------------------------

      ENTRY INIPUT
      BITLFT=0
      OBJLEN=0
      RETURN
      END
