*  M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
*  (c) 2005 All rights reserved.
*  Read Terms of Use at http://mlp-xml.sourceforge.net.
*  Contact medical_language_processing@gmail.com
*
      SUBROUTINE FRETRE (IXR7)
************************************************************************
*      
*     MRKFRE and FRETRE function together to free all nodes in a parse
*     subtree.  MRKFRE marks node IXR7 and all nodes below IXR7 in the
*     parse tree for freeing.  Each node is marked by zeroing NDSPFB oF
*     the node;  in addition, all nodes to be freed are chained, with
*     links in NDUPLF of the node and variable TOFREE pointing to the
*     head of the chain.  MRKFRE scans the tree in a bottom-up, right-
*     to-left sequence.  FRETRE frees all nodes marked by MRKFRE;  the
*     argument passed to FRETRE is ignored.
*      
************************************************************************
      IMPLICIT INTEGER (A-Z)
      INCLUDE 'common.fcm'
      INCLUDE 'nodray.fcm'
      INCLUDE 'nddfty.fcm'
      INCLUDE 'asf.fcm'
      INCLUDE 'nodefs.fcm'
*      
    5 IF(TOFREE.EQ.0) RETURN
      N=TOFREE
      TOFREE=NDUPLF(TOFREE)
      CALL FRENOD (N)
      GO TO 5
*      
      ENTRY MRKFRE(IXR7)
      TOFREE=0
      SXR7=XR7
      XR7=IXR7
   10 CALL DNRIT
      IF(PASS) GO TO 10
*                            if at starting node, done
   20 IF(XR7.EQ.IXR7) GO TO 40
      LXR7=XR7
      CALL LEFT1
      IF(.NOT.PASS) GO TO 30
*     NDSPFB(LXR7)=0
      NODE(LXR7+5)=0                                                                
*     NDUPLF(LXR7)=TOFREE
      NODE(LXR7+0)=TOFREE                                                           
      TOFREE=LXR7
      GO TO 10
*      
   30 CALL UPONE
*     NDSPFB(LXR7)=0
      NODE(LXR7+5)=0                                                                
*     NDUPLF(LXR7)=TOFREE
      NODE(LXR7+0)=TOFREE                                                           
      TOFREE=LXR7
      GO TO 20
*                            finally free root node
*  40 NDSPFB(IXR7)=0
   40 NODE(IXR7+5)=0                                                                
*     NDUPLF(IXR7)=TOFREE
      NODE(IXR7+0)=TOFREE                                                           
      TOFREE=IXR7
      XR7=SXR7
      RETURN
      END
