*  M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
*  (c) 2005 All rights reserved.
*  Read Terms of Use at http://mlp-xml.sourceforge.net.
*  Contact medical_language_processing@gmail.com
*
      PROGRAM COMPILER

      IMPLICIT INTEGER (A-Z)
      INCLUDE 'common.fcm'
      INCLUDE 'chartrn.fcm'
      INCLUDE 'nodray.fcm'
      INCLUDE 'gencom.fcm'
      INCLUDE 'parblk.fcm'
      INCLUDE 'grio.fcm'
      INCLUDE 'printr.fcm'
      INCLUDE 'filedeflun.fcm'
      COMMON/LKDBLK/LRSRVD
      LOGICAL RDFLG
      COMMON /LNCTRB/LINLIM,NODLIM
      PARAMETER (GLOBAL=16)
      CHARACTER*10 IROOT

      PARAMETER (LXLEN=15)
      CHARACTER*10 LXSYM(LXLEN)
      COMMON/LEXSYM/LXSYM
      COMMON/LEXLST/LXADR(LXLEN)

      CHARACTER*1 CHR

*-----------------------------------------------------------------------

*                  DATA FOR ROOT NODES

*        NUMBER OF ROOT NODE KEYWORDS
      PARAMETER (NROOTS=5)
*        NAMES OF ROOT NODES
      CHARACTER*(WORDLEN) ROOTNM(NROOTS)
*        associated control card keywords
      CHARACTER*(WORDLEN) ROOTKY(NROOTS)

*        LOCATION OF NODES IN GRAMAR--filled in after call to LKED
      INTEGER ROOTLC(NROOTS),ROOTMD(NROOTS)
*        corresponding value of pmode


*                  Data for keyword variables

*     SWITCHES:

      PARAMETER (NMKVAR=12)
      CHARACTER*10 KEYVAR(NMKVAR)

*     LOCAL SWITCHES:
*        OBJSW -- .TRUE. to write object records out on OUTFIL
*        TREESW -- .TRUE. to print tree (CALL  OUTPUD) after each parse
*        VERBOS -- .TRUE. to produce cell count, timing messages

      PARAMETER (NMCTRS=3)
      CHARACTER*6 KEYCTR(NMCTRS)
      LOGICAL VALUE,ERRFLG

      PARAMETER (IDTLIM=8)
      CHARACTER*80 IDNTFN(IDTLIM)
      COMMON/IDNTFC/IDNTFN
      COMMON/IDNTFN/IDTLEN
      LOGICAL DELETE,MATCH,LOCAL
      PARAMETER (LNNAMR=15)
      CHARACTER*(WORDLEN) UPRECN(LNNAMR,2),UPSBP(2)
      LOGICAL UPSBPF(2),MAJMAT
      CHARACTER*(WORDLEN) UPSARN(2)
      INTEGER UPIDCT(2)
      PARAMETER (ISGWTH=1,INTWTH=3,IFDWTH=15)
      DATA UPSARN/'NAMREC','THRREC'/
      DATA ROOTKY/'WDWORD','WDCAN','RESTR','LISTS','BNF'/
      DATA ROOTNM/'WDWORDSENT','WDCANSENT','RLSENT','LIST','DEFINITION'/
      DATA RDFLG/.FALSE./
      DATA KEYCTR/'LINLIM','NODLIM','LWIDTH'/
      DATA KEYVAR/'TRACE','XREF','LXTRAC',
     ='TSTTRC','PUTTRC','OBJSW','TREESW','VERBOS','OPRINT','MARPRT',
     ='RECURTRACE','DRAWSW'/

      DATA ROOTLC /NROOTS*0/
      DATA ROOTMD/4,3,2,2,1/
      DATA SUBSCB/CMPLBT/

      INCLUDE 'asf.fcm'

*        determine if the input command and sentence file is the standard input

      fptr=0
      CALL SETFIL(1)

*                             I. read next card
*                               A. get next input line
  100 SRCLEN=0
      SOURSW=.TRUE.
      CALL NEWLIN
  101 CALL GETCHR (CHR,NCHR)
      if(chr.ne.'*')go to 500
*                             II. analyze control card

*                               A. pack name following *
      CALL GETCHR (CHR,NCHR)
      CALL PAKNAM (CHR,NCHR,ERRFLG)
*                                  1. check if blank or - after * : comment
      IF(NAME .EQ. ' ') GO TO 260
      IF(NAME .EQ. '-') GO TO 265
*                                  2. check character following name
*                                     (A) blank: root node specification
*                                        or update directive

      IF(NCHR.EQ.BLANK) GO TO 200
*                                     (B) equals sign:  assignment
      IF(CHR .EQ. '=') GO TO 300
*                                     (C) open paren:  function call
      IF(CHR .EQ. '(') GO TO 400
*                                     (D) else error
      PRINT 160
  160 FORMAT(' ***Invalid character follows keyword--card ignored')
      GO TO 100
*
  200 CONTINUE
*                               C. process root node specifier
*                                  or update directive
*                                  1. look name up on list of keywords
*                                     associated with root nodes
      DO 210 I=1,NROOTS
      IF(NAME .EQ. ROOTKY(I)) GO TO 220
  210 CONTINUE
      IF(NAME .EQ. 'INSERT') GO TO 800
      IF(NAME .EQ. 'DELETE') GO TO 801
* *END is a no op get next image
      IF(NAME .EQ. 'END') GO TO 100
*
      IF(NAME .EQ. 'XZMARKZX') THEN
* write the image to the output
      call outimag(outfil)
      go to 100
      ENDIF
*                                  2. not on list--error
  212 PRINT *,'***No such root node keyword'
      GO TO 100
*                                  3. check that root node appeared
*                                     in grammer
  220 IF(ROOTLC(I) .NE. 0) GO TO 230
      PRINT *,' ***Root node not in grammar'
      GO TO 100
*                                  4. for the first root node specifier
  230 IF(GRROOT .EQ. 0) THEN
        IF(EXTYP .EQ. UPDATM) THEN
*                            in modify mode read in symbol table
*                            of grammer to be modified
          IF(GRUPST .EQ. 0) THEN
            REWIND (UNIT=GRUPF)
            CALL READST(GRUPF,*998,.TRUE.)
            REWIND (UNIT=GRUPF)
          ELSE
            REWIND (UNIT=GRUPST)
            CALL READST(GRUPST,*9988,.TRUE.)
            CLOSE(UNIT=GRUPST)
            GRUPST=0
          END IF
        ELSE
*                                     else initialize symbol table
*                                     (A) zero and blank everything
          DO 236 J=1,128
  236     HASHLK(J)=0
          FREELK=1
          DO 240 J=1,STLNTH
          STNAME(J)=' '
          STTYPE(J)=0
          STREFC(J)=0
*                                     (B) link all entries into free list
  240     STLINK(J)=J+1
          STLINK(STLNTH)=0

        END IF

        IF(LRSRVD .NE. 0) THEN
*                                     (C) ADD RESERVED WORD TO SYMBOL
*                                         TABLE
          ILIST=LRSRVD
*                                        (1) GET FIRST ELEMENT OF LIST,
*                                            WHICH SHOULD BE A NUMBER.
*                                            SAVE ITS VALUE AS TYPE TO
*                                            BE ASSIGNED
  242     IELEM=CAR(ILIST)
          NTYPE=CAR(IELEM)
          IF(.NOT.NUMBRP(NTYPE)) THEN
            PRINT *,' *** Format error in RESERVED list--first element n 
     *ot an integer'
          ELSE
            NTYPE=CDR(NTYPE)

*                                        (2) GET NEXT ELEMENT
  245       IELEM=CDR(IELEM)
            IF(IELEM .EQ. 0) GO TO 248
            J=CAR(IELEM)
*                                        (3) SKIP ELEMENT IF NOT A
*                                            LITERAL
            IF(AND(CSR(J),(HEAD+LTOMIC)) .EQ. (HEAD+LTOMIC)) THEN
              J=CAR(J)
              NAME=STNAME(J)
*                                        (4) add symbol to SYMBOL TABLE
*                                            if not there and assign type
              K=GETST(NAME,NTYPE)
*                                        (5) assure one reference so
*                                            symbol cannot be deleted
*                                            by a *FREE()
              STREFC(K)=STREFC(K)+1
            END IF
            GO TO 245
*                                        (6) get next list, if any
  248       ILIST=CDR(ILIST)
            IF(ILIST .NE. 0) GO TO 242
          END IF
        END IF
      END IF
*                                  5. SET PMODE (FOR LEX) AND FIRST
*                                     (POSITION OF ROOT NODE IN GRAMAR)
  250 PMODE=ROOTMD(I)
      GRROOT=ROOTLC(I)
      IROOT=ROOTKY(I)
      GO TO 100
*                               D. process comments
  260 DERIV=0
      GO TO 270
  265 DERIV=1
*                                  1. SKIP BLANKS
  270 K=2
  271 K=K+1
*                                  2. COMPLETELY BLANK CARDS ARE IGNORED
      IF(K.GE.80) GO TO 100
      CALL GETCHR (CHR,NCHR)
      IF(NCHR .EQ. BLANK) GO TO 271

*                                  3. PACK NAME TO NEXT BLANK OR COLON
      CALL PAKSET
      CALL PACKEM ('*')
  275 CALL PACKEM (CHR)
      CALL GETCHR (CHR,NCHR)
      IF(NCHR .NE. SEOR.AND.CHR.NE.':'.AND.NCHR.NE.BLANK) GO TO 275
      RCDNAM=NAME
*                                  4. READ CARDS UP TO NEXT NON-COMMENT
  285 CALL NEWLIN
*                                     (A) IN WD, EACH COMMENT CARD
*                                         (* --- SEE ---) A SEPARATE RCD
      IF(IROOT .EQ. 'WDWORDSENT' .OR.IROOT .EQ.'WDCANSENT') GO TO 290
      CALL GETCHR (CHR,NCHR)
      IF(CHR .NE. '*') GO TO 290
      CALL GETCHR (CHR,NCHR)
      IF(NCHR .EQ. BLANK) GO TO 285
  290 SRCLEN=SRCLEN-1
      IF(OBJSW.AND.OUTFIL.NE.0) THEN
*                                 5. IF OBJSW IS ON, WRITE COMMENTS
*                                     OUT AS OBJECT RECORD
        IDWDCT=0
        TOST=0
        STPTR=0
        OBJLEN=0
        CALL GRWRIT(OUTFIL)
      END IF
*                                  7. MOVE LAST CARD READ (THE NON-
*                                     COMMENT CARD) DOWN TO BEGINNING
*                                     OF SOURCE BUFFER
      SOURCE(1)=SOURCE(SRCLEN+1)
      SRCLEN=1
      CALL GETSET
      GO TO 101
*                               E. PROCESS ASSIGNMENT
*                                  1. search list of keyword variables
*                                     (A) switch
  300 DO 310 I=1,NMKVAR
  310 IF(NAME .EQ. KEYVAR(I)) GO TO 320
*                                     (B) counter
      DO 312 I=1,NMCTRS
  312 IF(NAME .EQ. KEYCTR(I)) GO TO 330
*                                     (C) sentence ID
  315 PRINT *,'*** Not a keyword variable ',NAME
      GO TO 100
*                                  2. ANALYZE RIGHT SIDE OF ASSIGNMENT
  320 CALL GETCHR (CHR,NCHR)
*                                     (A) T  (TRUE)
      IF(CHR .NE. 'T') GO TO 325
      VALUE=.TRUE.
      GO TO 340
*                                     (B) F  (FALSE)
  325 IF(CHR .NE. 'F') GO TO 350
      VALUE=.FALSE.
*                                  3. assign value to variable switch
  340 SWTCHS(I)=VALUE
      GO TO 100
*                                     (C) INTEGER
  330 CALL GETCHR (CHR,NCHR)
      IVALUE=0
      GOTO 336
  335 CALL GETCHR (CHR,NCHR)
      IF(NCHR .EQ. BLANK) GO TO 380
  336 IF(NCHR.GT.9) GO TO 350
      IVALUE=IVALUE*10+NCHR
      GO TO 335
*                                     (D) ERROR
  350 PRINT 355
  355 FORMAT('*** Right side of assignment invalid')
      GO TO 100

  380 GO TO (381,382,383,384), I
  381 PARLIM=IVALUE
      GO TO 100

  382 LINLIM=IVALUE
      GO TO 100
  383 NODLIM=IVALUE
      GO TO 100
  384 RM(WUTIX(PRUNIT))=MIN(IVALUE,130)
      GO TO 100

  400 CONTINUE
*                            F. PROCESS ROUTINE CALL
*                               1.  check for execution type
      IF(NAME .EQ. 'COMPILE') THEN
        EXTYP=COMPIL
        GO TO 480
      ELSE IF(NAME .EQ. 'MODIFY') THEN
        EXTYP=UPDATM
        KURRN=0
        GO TO 480

       ELSE IF(NAME .EQ. 'LKED') THEN
*                               1. *LKED(.,.) -- call linkage editor
        CALL LKED(GRINFL,GRINST)
        NAS=IG+2
*                                     (A) SAVE POSITION OF ROOT DEFS
          DO 420 I=1,NROOTS
          J=LOOKST(ROOTNM(I))
          IF(J .NE. 0) ROOTLC(I)=STADDR(J)
  420     CONTINUE
          GRROOT=0
        GO TO 100
*                                  2. *DUMP(...) -- CALL DUMP ROUTINE
      ELSE IF(NAME .EQ. 'DUMP') THEN
        CALL CCDUMP
        GO TO 100
*                                  3. *CLOSE() -- WRITE S.T. ON UNIT
      ELSE IF(NAME .EQ. 'CLOSE') THEN
        IF(OBJSW.AND.OUTFIL.NE.0) THEN
          IF(EXTYP .EQ. UPDATM) THEN
*                                      (A) IF UPDATE MODE, COPY
*                                          REMAINING RECORDS FROM OLD
*                                          TO NEW GRAMMAR
            IF(GRUPF.NE.0) THEN
  440         CALL GRREAD(GRUPF,*450)
              CALL GRWRIT(OUTFIL)
              GO TO 440
            END IF
          END IF
  450       IF(OUTST .NE. 0)ENDFILE(UNIT=OUTFIL)
*                                        (B) IF THERE WERE COMPILATION
*                                            ERRORS, ANALYZE ARGUMENT TO
*                                            CLOSE:
*                                             A.. -> ABORT
*                                             N... -> DON'T WRITE SYMBOL TABLE
*                                             NO ARGUMENT -> WRITE S.T.
            IF(PARERR)THEN
              CALL GETCHR(CHR,NCHAR)
              IF(CHR .NE. ')')THEN
                IF(CHR .EQ. 'A') THEN
                  CALL EXITR('***Compilation errors - program termi
     *nated')
                ELSE IF(CHR .EQ. 'N')THEN
                  PRINT 452
 452  FORMAT(/'*** Compilation errors above - SYMBOL TABLE will not be w
     *ritten'/)
                  GO TO 100
                ELSE IF(CHR .NE. 'R') THEN
                  PRINT *,' *** Invalid argument to close - ignored'
                ELSE
                END IF
              END IF
            END IF
            IF(OUTST .EQ. 0)THEN
              FILWR=OUTFIL
            ELSE
              REWIND (UNIT=OUTST)
              FILWR=OUTST
            END IF
            CALL WRITST(FILWR)
            ENDFILE (UNIT=FILWR)
            REWIND (UNIT=FILWR)
        END IF
        GO TO 100
*                                  4. FREE() -- PUT UNREFERENCED SYMBOL
*                                     TABLE ENTRIES ON FREE LIST
      ELSE IF(NAME .EQ. 'FREE') THEN
      DO 465 INDEX=1,STLNTH
      IF(STNAME(INDEX) .NE. ' '.AND.STREFC(INDEX) .EQ. 0)
     *CALL RMVST (INDEX)
  465 CONTINUE
      GO TO 100
      ELSE
      print *, 'Bad control image'
      ENDIF

  480 CONTINUE
*
*     LOCAL COUNTERS:
*        LINLIM -- maximum number of lines output per sentence
*        NODLIM -- maximum number of nodes attached / sentence
      PARLIM=99
      LINLIM =2000
      NODLIM=100000
      GRROOT=0
      CALL EXCON
      GO TO 100

*                            III. PARSE SENTENCE
*                               A. check that a root node has been
*                                  selected
  500 CALL GETSET
        IF(GRROOT .EQ. 0) THEN
          CALL EXITR(' ***No root node selected--run aborted')
        END IF
        CALL COMPCN
        GO TO 101
*                            IV. PROCESS UPDATE DIRECTIVE
*                               A. ANALYZE DIRECTIVE
  800 DELETE=.FALSE.
       GO TO 805
  801 DELETE=.TRUE.
*                                  1. IF NOT IN UPDATE MODE, ERROR
  805 IF(EXTYP .NE. UPDATM) GO TO 880
       ITHRU=0
       PRIDCT=UPIDCT(1)
       LASTRN=KURRN
*                                  2. PACK RECORD NAME
  810 CALL GETCHR (CHR,NCHR)
      IF(NCHR .EQ. BLANK) GO TO 810
      IF(NCHR .EQ. SEOR) GO TO 100
      DO 860 IU=1,2
      UPIDCT(IU)=0
      UPSBPF(IU)=.FALSE.
  820 CALL PAKNAM (CHR,NCHR,ERRFLG)
      IF(ERRFLG) GO TO 890
      IF(.NOT.DELETE .AND. NAME.EQ.'FRONT')GO TO 100
      IF(IU.EQ.1) THEN
         IF(UPRECN(UPIDCT(IU)+1,IU).NE.NAME) THEN
           UPRECN(UPIDCT(IU)+1,IU)=NAME
           MAJMAT=.FALSE.
         END IF
      ELSE
         UPRECN(UPIDCT(IU)+1,IU)=NAME
      END IF
*                                   (A)  CHECK FOR IDIOM JOINER
      IF(CHR .NE. '_') GO TO 850
      CALL GETCHR (CHR,NCHR)
      CALL ADDCNT (UPIDCT(IU),LNNAMR,UPSARN(IU),1)
      GO TO 820
*                                  3. pack subpart name, if any
  850 IF(NCHR .EQ. BLANK) GO TO 900
      IF(NCHR .EQ. ICOMMA) GO TO 852
      IF(NCHR .NE. SDOLR.AND.NCHR.NE.IPER) GO TO 890
      CALL PAKNAM (CHR,NCHR,ERRFLG)
      IF(ERRFLG) GO TO 890
      UPSBP(IU)=NAME
      UPSBPF(IU)=.TRUE.
      IF(NCHR .EQ. BLANK)GO TO 900
      IF(NCHR .NE. ICOMMA) GO TO 890
  852 CALL GETCHR(CHR,NCHR)
      ITHRU=1
  860 CONTINUE
*                               B. search for record
  900 IU=1
      IF(PRIDCT.NE.UPIDCT(1))MAJMAT=.FALSE.
  901 MATCH=.FALSE.
*                                  1. READ NEXT RECORD
  902 CALL GRREAD(GRUPF,*990)
      KURRN=KURRN+1
*                                    (A) SUBSTATEMENTS, NUMBERED LINES
*                                     IN WORD DEFINITIONS, AND
*                                     *- COMMENTS (INDICATED BY
*                                      TOST=0,DERIV=1)
      LOCAL=TOST .EQ. 3 .OR. TOST.EQ.7.OR.(TOST.EQ.0.AND.DERIV.EQ.1)
      IF(LOCAL) GO TO 930
      MAJMAT=.FALSE.
*                                  2. COMPARE WITH NAME OF MAJOR RECORD
*                                     SOUGHT.
      IF(UPRECN(1,IU) .NE. RCDNAM)GO TO 940
  921 IF(UPIDCT(IU) .NE. IDWDCT)GO TO 940
      DO 922 I=1,IDWDCT
  922 IF(UPRECN(I+1,IU) .NE. IDWORD(I)) GO TO 940
      MAJMAT=.TRUE.
*                                     (B) MAJOR RECORD NAMES MATCH. IF
*                                         MAJOR RECORD NAME ON UPDATE
*                                         DIRECTIVE IS NOT QUALIFIED
*                                         BY A MINOR RECORD NAME WE
*                                         HAVE A MATCH, ELSE NO MATCH
      IF(UPSBPF(IU))GO TO 940
      GO TO 932
*                                     (C) CURRENT RECORD IS A MINOR REC-
*                                         ORD, MATCH ONLY IF RECORD NAME
*                                         ON UPDATE DIRECTIVE IS QUALI-
*                                         FIED BY A MINOR RECORD NAME
*                                         EQUAL TO CURRENT RECORD NAME
  930 IF(.NOT.MAJMAT)GO TO 940
      IF(RCDNAM .NE. UPSBP(IU)) GO TO 940
*                                4. HAVE FOUND RECORD
*                                    -- FOR *INSERT, WRITE RECORD OUT
*                                     AND RE-ENTER MAIN LOOP
  932 MATCH=.TRUE.
*                           IF *DELETE  THEN  DONT WRITE RECORD
      IF(DELETE)GO TO 957
      GO TO 955
*                            NO MATCH
*          If second half of DELETE thru dont write out
  940 IF(IU .EQ. 2) GO TO 957
*                                     (B) WRITE RECORD BACK OUT
  955 IF(OUTFIL.NE.0 .AND.OBJSW)CALL GRWRIT(OUTFIL)
*                                IF A MATCH, MUST BE *INSERT - DONE
      IF(MATCH) GO TO 100
*                                IF NOT, CONTINUE TO SEARCH
      GO TO 902
*                               C. DELETE RECORD
  957 IF(TOST .NE. 0) THEN
      CALL INIGET
      IF(RCDNAM .EQ. 'GLOBAL') THEN
*                                  1. GLOBAL LIST
        DMASK=COMPL(GLOBAL)
      ELSEIF(RCDNAM .EQ. 'ATTRIBUTE') THEN
*                                  2. ATTRIBUTE LIST
        DMASK=COMPL(0)
        TOST=0
      ELSE
*                                  3. FOR ALL RECORDS EXCEPT GLOBAL AND
*                                     ATTRIBUTE LISTS
        DMASK=COMPL(0)
        TOST=0
      END IF
*
 961  CALL GETFLD (IGNORE,ISGWTH)
      DO 965 I=1,2
      CALL GETFLD (INT,INTWTH)
      IF(INT .EQ. 7)GO TO 1000
      IF(INT .NE. 0) THEN
        CALL GETFLD (IFLD,IFDWTH)
        IF(INT .EQ. ISYM .OR. INT .EQ. ILIT) THEN
          IF(STREFC(IFLD) .EQ. 1) THEN
            CALL RMVST (IFLD)
          ELSE
            STREFC(IFLD)=STREFC(IFLD)-1
            STTYPE(IFLD)=AND(STTYPE(IFLD),DMASK)
          END IF
        END IF
      END IF
  965 CONTINUE
      IF (TOST.EQ.5) THEN
        IF(RCDNAM.EQ.'STRING') THEN
          DMASK=STGBIT*16
          TOST=0
        ELSE IF (RCDNAM.EQ.'MINLIST') THEN
          DMASK=MINFLG*16
          TOST=0
        ELSE IF (RCDNAM.EQ.'RECURSIVE') THEN
          DMASK=RECBT*16
          TOST=0
        END IF
      END IF
      GO TO 961
      END IF
*
 1000 IF(.NOT.MATCH) GO TO 902
*     If not a thru or the second half of a *DELETE thru then done
      IF(ITHRU.EQ.0 .OR.(ITHRU.NE.0.AND.IU .EQ. 2)) GO TO 100
*                  If major rec name not same in second half of
*                  thru make MAJMAT false.
      IU=2
      IF(UPRECN(1,1).EQ.UPRECN(1,2)) THEN
        IF(UPIDCT(1).EQ.UPIDCT(2)) THEN
          DO 1003 I=1,UPIDCT(1)
 1003     IF(UPRECN(I,1).NE.UPRECN(I,2))GO TO 1004
          GO TO 901
        END IF
      END IF
 1004 MAJMAT=.FALSE.
      GO TO 901
*
  990 PRINT 991,UPRECN(1,IU)
  991 FORMAT(/9X,A/' *** This record cannot be found in grammar'/
     =   '        New grammar will not be written'/)
      OBJSW=.FALSE.
      IF(GRUPF.EQ.0) GO TO 100
      REWIND (UNIT=GRUPF)
      KURRN=LASTRN
      DO 995 I=1,LASTRN
  995 CALL GRREAD(GRUPF,*998)
      GO TO 100
*                                     (D) delete thru till find match
  890 PRINT *,'*** Error in record name--UPDATE directive ignored'
      GO TO 100
  880 PRINT *,'*** Not in UPDATE mode--This control card ignored'
      GO TO 100
  905 CALL EXITR('No input file')
  998 CALL EXITR('File positioning error on GRUPF')
 9988 CALL EXITR('File positioning error on GRUPST')
      END
      BLOCK DATA
      IMPLICIT INTEGER (A-Z)
      INCLUDE 'common.fcm'
      INCLUDE 'nodray.fcm'
      INCLUDE 'printr.fcm'
      PARAMETER (APTRS=LNSTAC+1)
      COMMON/LOADCM/SOL,SOS,LOCREC
      COMMON/TSTAT/TSTAT
      LOGICAL TSTAT
*
*
*     SOS and SOL are offsets used by load in storing symbol table
*     references.  They are constrained by the requirement that
*     HEAD-SOL and SOL-SOS both be greater than STLNTH.
*
      DATA SOS,SOL/34000,38000/
      DATA ZLIM/ZLIMP/,NDLIM/NODLNG/
      DATA TSTAT/.FALSE./
      DATA NSTACK/LNSTAC/,APTR/APTRS/
*     DATA ECHO/.TRUE./
*
      DATA INUNIT/5/,OTUNIT/6/,PRUNIT/6/,WRUNIT/0/
      DATA COL/5*1,2,1/,INDENT/7/,RM/5*72,80,72/
      DATA (LINE(I),I=1,7)/7*' '/
      DATA LINEP(1)/' '/,LINEP(2) /' '/
      END
