/* M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
   (c) 2005 All rights reserved.
   Read Terms of Use at http://mlp-xml.sourceforge.net.
   Contact medical_language_processing@gmail.com
*/
// ***********************************************************************
// *    This routine executes the operator WRITE(M N)
// *        M=1 write to DIAG file
// *        M=2 write to INFO file
// *        M=3 write to standard output file

// *        N=1 write sentence ID
// *        N=2 write name of current node/list element/word into buffer
// *        N=3 write words subsumed by current node into buffer (25 char.)
// *        N=4 flush buffer onto current WRITE file
// *        N=5 write parenthesized representation of parse tree
// *        N=7 write parenthesized representation of parse tree, including
// *            related word forms for each sentence word.
// *        N=6 write sentence text)
// *        N=8 write parenthesized representation of parse sub-tree
// *        N=A Literal:  write literal into buffer (25 characters)

// *     If STREAM=.FALSE.
// *        lines of up to KTMAX characters may be written
// *        characters written past the end of the line are lost
// *        for literals and words subsumed by a node, the buffer column
// *             counter (KOUNTW) is always advanced by 25 columns
// *     If STREAM=.TRUE.
// *        lines are at most 80 characters long
// *        if an item cannot fit on the current line, the buffer is
// *             flushed and the item written on the next line, starting
// *             in column 1
// ************************************************************************

#include <iostream.h>
#include "symtab.h"
#include "common.fcm"
#include "nodefs.fcm"
#include "lispdefs.fcm"
#define TRUE 1
#define FALSE 0
extern int subttol(int, int);
extern void plist(int, int, int);
extern void plistnn(int, int, int);
extern void prnt();
extern void prntif();
extern int printSent(int, int, int, int);
extern void setFillUnit(int);
extern void resetFillUnit();
extern void fill(const char *);
extern char * subsumfb(int,char *);
extern int treeToList(int);
extern char * nodnam(int, char*);
extern SymbTable sytab;
static int entrycnt=0; //** debug
int wrtitr(int fout, int argin){
	int wrttyp,  sxr7,  foutun=0, slist, ltree;
entrycnt++; //** debug
	//fout = CDR(CAR(argin));
	//fout = CAR(CAR(argin));
	//fout = sytab.retsthostp(fout);
	if(fout==1) foutun = writef;
	else if(fout == 2) foutun = infofil;
	else if(fout == 3) foutun = PRUNIT;
	if(!foutun) return FALSE;
	setFillUnit(foutun);

//	argin = CAR(CDR(argin));
	if((CSRINT(argin) & LTOMIC)) fill(STNAME(CAR(argin)));
	else {
//		wrttyp=CDRADDR(argin);
		wrttyp=CARADDR(argin);
		wrttyp = sytab.retsthostp(wrttyp);

#if 0
//      LWIDTH=RM(WUTIX(OTUNIT))
      IF(STREAM) THEN
        RM(WUTIX(OTUNIT))=80
      ELSE
        RM(WUTIX(OTUNIT))=KTMAX
      END IF
#endif
//  180 KPREV=COL(WUTIX(OTUNIT))
// *     IF(.NOT.STREAM) COL(WUTIX(OTUNIT))=KPREV+25
	switch (wrttyp){
	case 1:
// *  10 IF(.NOT.STREAM) THEN
	fill (sentid);
	break;

	case 2: //  write node name/list element/word
	if(list==1) plist(xr7,FALSE,foutun);
	else {
		char nambuf[50];
        	if(!list) fill(nodnam(xr7, nambuf));
        	else{
          		fill(SENTWD(xr7));
          		for(int jjj=1; jjj<=SENTE6(xr7)-1; jjj++){
            			fill((char *)"_");
            			fill(SENTWD(xr7+jjj));
	      			}//for
        		}//else
        	}//else
	break;

	case 3: // write words subsumed
{
//   30 KPREV=COL(WUTIX(OTUNIT))
	char texbuf[700];
	if(list!=0) break;
	fill(subsumfb(xr7,texbuf));
// *     IF(.NOT.STREAM) COL(WUTIX(OTUNIT))=KPREV+25
}
	break;

	case 4: // flush buffers
	prnt();
	break;

	case 5: // write sentence
	printSent(1,nwordSent,3,foutun);
	break;

	case 6: // write a list pointed by xr7
	if(list == 1) plistnn(xr7,FALSE,foutun);
	break;

	case 8: // write parse tree
	sxr7=xr7;
	slist=list;
	ltree=treeToList(FALSE);
	if(ltree==0)cerr<<"treetolist failed";
	plist(ltree,FALSE,foutun);
	xr7=sxr7;
	list=slist;
	break;

	case 7: // write parse tree with word forms
		sxr7=xr7;
		slist=list;
		ltree=treeToList(TRUE);
		plist(ltree,TRUE,foutun);
		xr7=sxr7;
		list=slist;
		break;

	case 9: // write a sub-tree pointed by XR7
		if(list) break;
		sxr7=xr7;
		ltree= subttol(xr7,TRUE);
		plist(ltree,FALSE,foutun);
		xr7=sxr7;

// *   free the space occupied by the tree listed
		break;

// *   free the space occupied by the tree listed
//      GO TO 190
	} // switch
	}//else


//  190 RM(WUTIX(OTUNIT))=LWIDTH
//      CALL OTUSEL(PRUNIT)
	resetFillUnit();
	return TRUE;
}
