/* M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
   (c) 2005 All rights reserved.
   Read Terms of Use at http://mlp-xml.sourceforge.net.
   Contact medical_language_processing@gmail.com
*/
#include <string.h>
#include <iostream.h>
#include <fstream.h>
#include <iomanip.h>
#include "symtab.h"
#include "common.fcm"
#include "nodefs.fcm"
#include "lispdefs.fcm"

extern SymbTable sytab;
extern void flushbuf(int);
extern int empty(),down(), oupone(), right(), oright(), odown(), oleft();
extern char * nodnam(int,char*);
extern int printSent(int,int,int,int);

static int split(int), drawFrame(void);
static int son(char *,int), bro(char* , int);
static void outputTree(int),deleteBufs(void);

#define MAXLIN 70
#define MAXFRM 35
#define MAXARL 200
#define NONEM 40
#define TRUE 1
#define FALSE 0
#define FRAMELININIT 21

static struct framstrc {char * linlocP; char* lincurP; int leng;}
	framelin[MAXLIN+1];
static void elongBuffer(framstrc ,int );
static int numoflines;
static int iline, nline, iframe, nframe, root[MAXFRM+1], maxcol,
	maxprt,sonflg,start,frwka, bufreq;
struct {int nav; int upn;}anonem[NONEM];
static const char * labels = "0123456789abcdefghijklmnopqrstuvwxyz";

struct NAsetstr{int attrb; int value; short valtyp; int hous;};
extern int getNAfornode(int, struct NAsetstr*, int);
extern int isNAfornode(int);

inline int MAX(int a, int b){if(a>=b) return a;else return b;};
inline int MIN(int a, int b){if(a>=b) return b;else return a;};

static void int2str(int num, char* strg){
char * stp=strg;
char cc[10];
if(!num){*stp='0';*(stp+1)='\0';return;}
int i=0;
while(num){
int rem=num % 10;
cc[i++]='0'+rem;
num /= 10;
}
stp[i]='\0';
int k=0,j=i-1;
for(;j>=0;j--,k++) stp[k]=cc[j];
return;
}


void tdraw(int,int,int);
void treeDraw(int wst, int wed){
	tdraw(1,wst,wed);
	return;
}

void subtreeDraw(int treeroot){
	tdraw(treeroot,0,0);
	return;
}
/*
************************************************************************
 TDRAW draws the parse tree.  TDRAW begins by trying to draw the
 tree in a single frame (screen or page-full).  If it doesn't fit,
    it splits off a subtree, places its root node in array ROOT,
    and tries redrawing the main tree (with the subtree replaced
    by a link '<n>').  This is repeated until the main tree fits
    in a frame.  The same process is then applied to each subtree
    split off from the main frame.
**********************************************************************
*/

static void ordtree(int strtxr7){
	char nambuf[50];
	int nancrt=0, kount=0, upxr7=0, s, nt;
	char * nameP;
	xr7=strtxr7;
	while(1) {
		NDWKSP(xr7)=0;
		nameP=nodnam(xr7, nambuf); //get name of present node
//cout<<"ordtre: nodnam at "<<xr7<<" "<<nameP<<endl;// **debug

//                   skip NULLs and empty SAs
	if(!((strcmp(nameP,"NULL")==0)
		|| ((strcmp(nameP,"SA")==0) && empty()))) {
int ct;
	if(ct=isNAfornode(xr7)){
		NDWKSP(xr7) |= (++kount);
		if(ct==1 || ct==3){ // node has NA's

{        		if((strcmp(nameP,"NON-EMPTY")==0) && nancrt < NONEM){
struct NAsetstr NAlist[20];
int nnas=getNAfornode(xr7, NAlist, 20);
for(int i=0; i<nnas; i++){
if(NAlist[i].value==0)continue;
if(NAlist[i].value==-1)continue;
if(NAlist[i].valtyp != 0)continue;


				anonem[nancrt].nav=NAlist[i].value;
				anonem[nancrt].upn=upxr7;
				nancrt++;
	}//for
				}
}
			}
		}//if node has NA or is value of one
        }// if NULL
	else NDWKSP(xr7) |= 0x100;//mark to be skipped

	upxr7=xr7;
	if(down()) continue;

	do {
		if(xr7 == strtxr7){s=0;break;}
		if(s = oright()) break;
		} while((xr7!= strtxr7) && (s=oupone()));

	if(!s) break;
	} // while

	for(int ii=0;ii<nancrt;ii++){
		int nj=anonem[ii].nav;
		if(!NDWKSP(nj)&0xffff0000) NDWKSP(nj) += (ii+1)<<16;
		}
}// func end

//  --------------------------------------------------------------

static int getLineBufs(int numLines, int bufsiz){
	for(int i=0;i<numLines;i++){
		framelin[i].linlocP= new char [bufsiz];
//int px =(int)framelin[i].linlocP; // **debug
//cout<<"new buf "<<px<<endl;
if(framelin[i].linlocP == 0) {cerr<<"bad new"<<endl; return -1;}
		framelin[i].lincurP=framelin[i].linlocP;
		framelin[i].leng=bufsiz-1;
		}
	numoflines=numLines;
	return 0;
}

//  --------------------------------------------------------------

void tdraw(int treeStart, int wdBeg, int wdEnd){
	char hexc[3];
	int savxr7=xr7,savlist=list;
#if 0
//           longest line user wishes printed
      if(rightcol && drtrfl) THEN
        maxprt=rghtcol;
	TREOTLUN=DRTRFL
      else
        maxprt=getrtmar(PRUNIT)-1;
        TREOTLUN=6
      }
#endif
	maxprt=500;
	maxprt=lwidth;
	list=0;
	int s;
#if 0
nt=nts;
int nact=0;
char nambuf[50];
while(nt){
nact++;
cout<<"node name "<<nodnam(NAPNPA(nt),nambuf)<<endl;
if(NAVALA(nt)>=0){//  has a value
cout<<"value name "<<STNAME(CAR(NANAMA(nt)))<<endl;
}
nt=NAFLBL(nt);
}
cout<<"total items "<<nact<<endl;
#endif
//             scan tree in preorder, assigning ordinal to each
//             node (ordinal is saved in NDWKSP of node)
	ordtree(treeStart);
	maxcol=maxprt;
	bufreq=maxprt+1;
	int lincnt=0;
	iframe = nframe = 0;

//                 initialize list of root nodes of frames
	int  tall=0;
	root[0]=treeStart;
        	*coutP<<"\f";
	if(wdBeg>0 && wdEnd>0)
		lincnt += 3+printSent(wdBeg,wdEnd,1,PRUNIT);
	getLineBufs(FRAMELININIT, bufreq);

//                   try to draw next frame
	int ret;
//int prevsplit=0, newsplit;// **debug
	while(1) {
	xr7 = root[iframe];
//cout<<"tdraw: trying to draw frame starting at "<<xr7<<" iframe "<<iframe<<endl;// **debug
//int begtr=xr7;// **debug
	if((ret=drawFrame())<0) {deleteBufs(); return;} // bad return quit

	if(ret==0){
//                   subtree doesn't fit in frame, split off parts
//                   of subtree and start again
//char pbuf[50];
//nodnam(begtr,pbuf);// **debug
//cout<<"tdraw: tree starting at "<<begtr<<" "<<pbuf;// **debug
//nodnam(xr7,pbuf);// **debug
//cout<<" fails at "<<xr7<<" "<<pbuf <<" does not fit"<<endl;// **debug
//prevsplit=newsplit;// **debug
	if(split(root[iframe])>0){
//newsplit=xr7;// **debug

if(nframe>MAXFRM){
*coutP<<"\n**Error in drawing tree, too many frames"<<endl;
	xr7=savxr7; list=savlist;
	deleteBufs();
return;
}
		root[++nframe]=xr7;
		NDWKSP(xr7) |= nframe<<9; 
//if(prevsplit==xr7){// **debug
//cout<<"tdraw: spliting tree at same point "<<xr7<<endl;//*debug
//}// **debug
//nodnam(xr7,pbuf);// **debug
//cout<<"tdraw: tree split at "<<xr7<<" "<<pbuf<<endl;// **debug
		continue;
		}
// get a new set of much larger buffers and try to draw the sub tree
	*coutP<<"Tree too wide ... cannot split into frames"<<endl;
	xr7=savxr7; list=savlist;
	deleteBufs();
	return; 
        }//if tree does not fit

//                   subtree fits in frame, print it
	if(lincnt+nline > 55) {
        *coutP<<"\f";
        lincnt=0;
	}
	outputTree(nline);

//                   if more frames, loop
	if(++iframe > nframe)break ;
	} // while
#if 0
  200
      if(nframe == MAXFRM) THEN
        cout<<"*** Tree too large ... frame limit exceeded"<<endl;
      END IF
      if(split(root[iframe])<0) maxcol=lstcol;
#endif

	deleteBufs();

//     print the node attributes

 //  prntif();
	int hdfprt=0;

	xr7=treeStart;
struct NAsetstr *NAset = new struct NAsetstr[60];
	while(1) {// loop over all nodes in tree
//get list of node attributes for this node. returns attribute value if any
// and type of value list or node. the return is zero if none there
//char bbb[40];
//cout<<"node processed="<<xr7<<" "<<nodnam(xr7,bbb)<<endl;
		int a;
		if((a=NDWKSP(xr7)&0xff)){
			int numOfNAs=getNAfornode(xr7,NAset, 60);
			if(numOfNAs){
// delete erased entries and flags from the list
	for(int i=0;i<numOfNAs;i++) {
		if(NAset[i].value== -1){//NA is erased
		int att= NAset[i].attrb;
	 	NAset[i].attrb = 0;
		for(int k=i+1;i<numOfNAs;k++) {
			if(att == NAset[k].attrb){ NAset[k].attrb = 0; break;}
			}//for
			}//if
		}//for
				if(!hdfprt){
				*coutP<<"\n\n     *** Node Attributes ***"<<endl;
				hdfprt=1;
				}
				int pnflg=FALSE;

//         print the node attributes of the current node

	int naval;
	for(int i=0;i<numOfNAs;i++) {
		int att=NAset[i].attrb;
		if(!att) continue;
		if(!pnflg) {
			flushbuf(2);
                	*coutP<<"\nNode ID: ";
                	*coutP<<hex<<a<<":: "<<dec;
                	pnflg=TRUE;
			}//if

		else *coutP<<" ; ";

		*coutP<<STNAME(CAR(att));
		if((naval=NAset[i].value)){//NA has a value
		if(NAset[i].valtyp == 0){//NA value is a node
			*coutP<<" ->"<<hex<<(NDWKSP(naval)&0xff)<<dec;
			}//if

		else {// NA value is a list
			*coutP<<" =";
			if(ATOMP(naval)) *coutP<<" "<<STNAME(CAR(naval));
			else {
				do {
					*coutP<<" "<<STNAME(CAR(CAR(naval)));
// output subattributes, if any
int sbcnt=0, sbatix;
if(( sbatix=CSR(naval)) != 0){
*coutP<<'[';
if(ATOMP(sbatix)) *coutP<<STNAME(CAR(sbatix));
else {
while(sbatix){
*coutP<<STNAME(CAR(CAR(sbatix)))<<' ';
sbatix=CDR(sbatix);
}
}//else a list
*coutP<<']';
} //if a sub att
					}while(naval=CDR(naval));
				}//else
			}//else NA is a list
		}// if has a value
		}//for
		}//if NA exist for this node
}

        if(odown()) continue;
	while(1) {
if(xr7 == treeStart){s=0;break;}
		if((s=oright())) break;
		if(!(s=oupone())) break;
		}// while
	if(!s) break;
	} // while 1
	if(!hdfprt) *coutP<<"No node attributes"<<endl;
*coutP<<endl;flushbuf(2);
	delete NAset;
	*coutP<<'\f';
	xr7=savxr7;
	list=savlist;
	return ;
}

/*
   ***********************************************************************
   DRWFRM tries to draw the subtree of the parse tree with root root[iframe]
   in the frame buffer.  DRWFRM returns with +1 if the tree fits in the
   buffer; returns 0 if the tree does not fit, and -1 if an error encountered.
   ***********************************************************************
*/
//   SONFLG=TRUE if we have gone down in tree but have not yet drawn a son

int drawFrame(){
static const char * msgUnExOv = "*** Unexpected frame overflow";
//                   off-frame connector
static char ofc[4]={'<','\0','>','\0'};
	char name[50], *nameP, nambuf[30];
	int rootNode = root[iframe];
//                   clear frame buffer
	for(int i=0;i<numoflines;i++){
		framelin[i].lincurP=framelin[i].linlocP;
		}

//           enter frame number (except for 0th frame) and root node

	nline = iline = 0;
	start=0;
	int n5,ll=0,nr;
	if((n5=NDWKSP(xr7))&0xffff00ff) {
		n5 &= 0xff;
        	name[ll++] ='*';
		nr=n5>>4; n5 &= 0xf;
		if(nr) name[ll++]=*(labels+nr);
		name[ll++] = *(labels+n5);
        	name[ll++] = '*';
		}

	char * fstp=framelin[0].lincurP;
	strcpy(&name[ll],nodnam(xr7, nambuf));
/*
	strcat(name, "_"); // **debug
	ll=strlen(name); // **debug
	int2str(xr7,&name[ll]); // **debug
*/
	ll=strlen(name);

	if(iframe == 0){
		strcpy(fstp,name);
		framelin[0].lincurP += ll;
		}//if
	else {
 		*fstp++ = '<';
		*fstp++ = *(labels+iframe);
 		*fstp++ = '>';
		framelin[0].lincurP += 3;
        	if(son(name,ll)<0){
			*coutP<<msgUnExOv<<endl;
			return 0;
			}
		}//else
	sonflg=FALSE;

	int skpflg;
	while (1) { //  major loop
//             get next node of parse tree, scanning in preorder
		if((skpflg=odown()))sonflg=TRUE;
else{if(xr7 == rootNode) return 1;}

		while(1) {
		if(!skpflg){
			if(!oright()) {
				if(!oupone()){
					*coutP<<"*** Internal error in DRWFRM"<<endl;
					return 0;
					}//if
				if(xr7 == rootNode) return 1;
				if(!sonflg) iline -= 2;
				else sonflg=FALSE;

				continue;
				}//oright
			}//skpflg

		skpflg=0;
//	 have we reached the root of any subtree?
if(int frmn=((NDWKSP(xr7)>>9)&0x1f)){
//	int j=0;
//	for(int i=1;i<=nframe;i++){
//		if(root[i] == xr7){ j=i; break;}
//		}//for

//	if(j) {
//                        yes, print off-frame connector (*n*)
//                        and continue scan above this node

		ofc[1]=*(labels+frmn);

		if(sonflg){
			if(son(ofc,3)<=0){
				*coutP<<'\n'<<msgUnExOv<<endl;
				return 0;
				}//if
			sonflg=FALSE;
			}//if
		else  {
			if(bro(ofc,3)<=0){
				*coutP<<msgUnExOv<<endl;
				return 0;
				}//if
			}//else
			continue;
//		} // if j
		} // if a subtree

//                   skip NULLs and empty SAs
	if(NDWKSP(xr7) & 0x100) continue;
	nameP=nodnam(xr7, nambuf);// get name of present node
	break;
//	if (!((strcmp(nameP,"NULL")==0) || 
//		((strcmp(nameP,"SA")==0) && empty()))) break;
	}// while

/*
// put nodenumber for debug
strcat(nambuf,"_");// **debug
ll=strlen(nambuf);// **debug
int2str(xr7,&nambuf[ll]);// **debug
*/

//                   draw node
	int la, lb=0, ll=0;
	if((la=NDWKSP(xr7)&0xffff00ff)){
          	lb=la>>16;
		la &= 0xff;
        	name[ll++]='*';
		nr=la>>4; la &= 0xf;
		if(nr) name[ll++]=*(labels+nr);
		name[ll++]=*(labels+la);
        	name[ll++]='*';
		}//if GC not 0

	strcpy(&name[ll],nameP);
	ll=strlen(name);

        if(lb){
		name[ll++]='[';
		int npp=anonem[lb-1].upn;
		nameP=nodnam(anonem[lb-1].upn, nambuf);
		int lc=strlen(nameP);
		strcpy(&name[ll],nameP);
		ll += lc;
		name[ll++]=']';
		name[ll]='\0';
		ll=strlen(name);
		strcat(name,"_");
		int2str(xr7,&name[ll]);
		ll=strlen(name);
		} //if lb

	if(sonflg){
		if(son(name,ll)<=0)return 0;
		sonflg=FALSE;
		}//if
	else { if(bro(name,ll)<=0) return 0;}

//               for atomic nodes (except for literal and null atomics)
//               draw words beneath node
	int tombts = NDSPFB(xr7)&(ATOMIC+LTOMIC+OTOMIC);
	if(!(tombts & OTOMIC)){
	if(tombts & ATOMIC){
        	int fw=NDWPNC(xr7);
        	int lw=NDWPCP(xr7);
if(fw==0) nameP= (char *) "not-filled";
else
        	nameP=SENTWD(fw);
        	ll=strlen(nameP)+1;
		name[0]='"';
		strcpy(&name[1],nameP);

        	if(fw+1 < lw) { //an idiom
			for(int iw=fw+1;iw<lw;iw++){
	        		name[ll++]=' ';
				nameP=SENTWD(iw);
				strcpy(&name[ll],nameP);
				ll += strlen(nameP);
				} //for
			}//if  lw>fw

	        	name[ll++]='"';
	        	name[ll]='\0';
			if(son(name,ll)<=0) return 0;
			iline -= 2;
			}// if not Otomic
			}// if Atomic

//                   get next node
		}//while

//         tree doesn't fit in frame, return to split off part of tree
}

/*
***********************************************************************
     SON adds a node with name LABEL to the tree being drawn,
     immediately below the most recently drawn node.  SON
     returns +1 if the node fits in the current frame; and -1
     if it does not fit.
***********************************************************************
*/

static int son(char *label, int width){
	framstrc * frsil;
	char * spp1, * spp2, *spp1e, *spp2e;
	int spp1ln, spp2ln;
	int flag=0;
//cerr<<"son "<<iline<<" "<<nline<<" "<<label<<" "<<start<<endl;

//      check for sufficient space in frame ... at least 2 lines

//                        at least WIDTH columns
	if(start+width > maxcol) return 0;

// see if lines in buffer to proceed else resuest more space
	if(iline == nline){ // we on last line
		flag=1;//last line got bufs
		frsil=&framelin[iline+1];
		if(nline+2 >= numoflines) flag=2;//no push down - need bufs
		} //if on last drawn line

	else { // not on last line

//           if position of son already occupied, push down
//              rest of tree by two lines

		frsil=&framelin[iline+2];
	if(start > 1 && frsil->lincurP-frsil->linlocP >= start){
		if(nline+2>MAXLIN) return -1;

//  see if there are availible buffers. If not request new ones.
		if(nline+2 >= numoflines) flag=3;//push down need new bufs
		else  flag=4;//push down no new bufs
			} //if space occupied - push down

			} // else - not on last line
	if(flag) { //on last line and/or need bufs
		nline += 2;
		if(flag == 2 || flag == 3) { // need more buffers
			if(numoflines+2 > MAXLIN) return 0;//too big a tree
			spp1 = new char [bufreq];
//cout<<"new buf spp1 "<<((int)spp1)<<endl;
			spp1ln = bufreq-1;
			spp2 = new char [bufreq];
//cout<<"new buf spp2 "<<((int)spp2)<<endl;
			spp2ln=bufreq-1;
			numoflines += 2;
			} // if - more buffs
		else {//flag ==4 or flag == 1 have bufs
			frsil=&framelin[nline];
			spp2=frsil->linlocP;
			spp2ln=frsil->leng;
			spp1=(frsil-1)->linlocP;
			spp1ln=(frsil-1)->leng;
			} // else flag == 4

		if(flag>2){ // line occ need to push down
			frsil=&framelin[nline];
			framstrc * frsil2=frsil-2;
			while(frsil2> &framelin[iline]) *frsil-- = *frsil2--;
			}// if need to push down - occupied

		if(flag > 1) {
// set initial information of new buiffers and shifted bufs
			frsil = &framelin[iline+1];
			frsil->linlocP=spp1;
			(frsil++)->leng=spp1ln;
			frsil->linlocP=spp2;
			frsil->leng=spp2ln;
			}//if new bufs save info
		spp1e=spp1+start;
		spp2e=spp2+start;

		if(flag>2){// a push down
			framstrc * frsil2=&framelin[iline+3];
			int nmv=frsil2->lincurP-frsil2->linlocP;
			strncpy(spp1,frsil2->linlocP,nmv);
			strncpy(spp2,frsil2->linlocP,nmv);
			spp1 += nmv;
			spp2 += nmv;
			}

		} // if - need to mod buffers

	else { // flag==0,  space to right
		frsil = &framelin[iline+1];
		spp1 = frsil->lincurP;
		spp1e = (frsil++)->linlocP+start;
		spp2 = frsil->lincurP;
		spp2e = frsil->linlocP+start;
		} //else flag ==0

//                   insert vertical bar to connect son to parent
	if(start<=maxcol) {
		frsil=&framelin[iline+1];
		while(spp1 < spp1e)*spp1++ = ' ';
		*spp1++ = '|';
		(frsil++)->lincurP = spp1;

//                  insert son
		while(spp2 < spp2e)*spp2++ = ' ';
		strcpy(spp2,label);
		frsil->lincurP = spp2+width;
			}

	iline += 2;
	if(iline>nline)nline=iline;
	return 1;
}

/*
***********************************************************************
     BRO adds a node with the name LABEL to the tree
     currently being drawn.  This node is added to the right of
     the most recently drawn node.  BRO returns +1 if the node
     fits in the current frame and 0 if it does not fit.
***********************************************************************
*/
       
static int bro(char * label, int width){
//	int below,here;
	char* strpe,* strP;
	framstrc * frsil=&framelin[iline];

//    here=framelin[iline].ncol;
	strP=frsil->lincurP;
	strpe=strP+3;
//                below = width of line below current line

	if(iline < nline) {
	framstrc * frsil2=&framelin[iline+2];
	char * blpp= frsil2->lincurP - frsil2->linlocP + frsil->linlocP;
	if(blpp>strP) strpe=blpp+3;
}
//below=framelin[iline+2].ncol-here;

//      else below=0;

//       the new node is placed 4 columns to the right of the end of
//       the current line or the line below, whichever extends further
//       (ignoring BELOW at this point would produce taller, narrower trees)

//      start=MAX(here,below)+4;
	start=strpe - frsil->linlocP;
//cerr<<"bro "<<iline<<" "<<nline<<" "<<label<<" "<<start<<endl;

//                   if node won't fit, return
	if(start+width > maxcol)
		return 0;
//                   add --- and node name to frame buffer

	while(strP<strpe)*strP++ ='-';
        if(start<=maxcol) strcpy(strP,label);

	frsil->lincurP=strP+width;
//int sell=88;// **debug
//if(root[iframe]==sell){
//cout<<"bro: iline is "<<iline<<" nline is "<<nline<<endl;//*debug
//outputTree(nline);// **debug
//}// **debug
	return 1;
}


/*
***********************************************************************
     SPLIT is invoked when the current subtree will not fit in the
     frame buffer;  xr7 points to the node of the parse tree we were
     trying to draw when the frame buffer overflowed.  SPLIT identifies
     a subtree of the current subtree and splits it off, adding its
     root to the ROOT array.

        We require that the root of the subtree which is split off be
     an ancestor of node xr7 .  We first seek an ancestor node with
     no siblings;  if none exists, we try to split at the parent of
     node xr7.  If even this is not possible (because the parent of
     xr7 is the root of the current subtree), or if the frame limit
     is exceeded, 0 is returned .
************************************************************************
*/

static int split (int rootNode){
       
	int txr7=xr7, sxr7, pass ;

//                   go up in parse tree
	do {
		pass = oupone();
//cout<<"split: oupone "<<xr7<<endl;// **debug
		if(xr7 == rootNode) {

//     cannot find any ancestor with no siblings, so try to split at
//     parent of node which caused frame buffer to overflow

			xr7=txr7;
			pass= oupone();

			if(xr7 == rootNode){
				xr7=txr7 ; return 0;
				}

			return 1;
			}

//  try to go left and right; if either is possible, continue ascending tree

		sxr7=xr7;
		pass= oleft();
		xr7 = sxr7;
		if(pass) continue;
		pass= oright();
		xr7=sxr7;
		} while (pass);

//  neither is possible, add current node as root of a new frame and return
	return 1;
}

#if 0
// if a subtree cannot be split and the line is longer than one which
// can be printed elongBuffer is called to get a longer line. The print
// routine will print this longer subtree in vertical slices.
// sunbro = 0 if called from son and 1 if called from bro


static void elongBuffer(framstrc bfP,int sonbro){
	char * olbP,newbP,olbsav;
	olbp=bfP->linlocP;
	olbsav=olbp;
	olbpe=bfP->lincurP;
	int newlen=bfP->leng+50;
	newbP=new char [newlen];
	bfP->linlocP = newbP;
	while(olbp<olbpe) *newbP++ = *olbp++;
	bfP->lincurP = newbP;
	delete olbsav;
	return ;
}
#endif


static void outputTree(int nline){
int indent=10;
#if 0
for(int i=0;i<=nline;i++){
char* xx=framelin[i].linlocP;
while(xx<framelin[i].lincurP&&*xx!='\0') *coutP<<*xx++;
*coutP<<endl;
}
#endif
	*coutP<<"\n\n";
	for(int ia=0;ia<=nline;ia++){
		*framelin[ia].lincurP='\0';
		*coutP<<setw(indent)<<" "<<(char *)framelin[ia].linlocP<<endl;
		}
	return;
}

void deleteBufs(void){
	for(int i=0; i<numoflines;i++){
//int px =(int)framelin[i].linlocP;
//cout<<"delete buf "<<px<<endl;
		delete framelin[i].linlocP;
		}
	return;
}
