/* M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
   (c) 2005 All rights reserved.
   Read Terms of Use at http://mlp-xml.sourceforge.net.
   Contact medical_language_processing@gmail.com
*/
#include <string.h>
#include <iostream.h>
#include <fstream.h>
#include <stdlib.h>
#include "symtab.h"

extern fstream *coutP;

extern char *storestrg(char *);
	int SymbTable::ihash(const char * syp){
	return *syp-32;
}

extern void exitr(int, const char *);

int STLNTH;
int SYMTABADDSIZE;
int SYMSTRINGSTORSIZE;
int SYMSTRINGSTORADDSIZE;
char *symStringStor;
SymbTable::SymbTable() {
	STLNTH=5000; // from 2500 Nhan
	SYMTABADDSIZE=2000; // from 1500
	SYMSTRINGSTORSIZE=20000;
	SYMSTRINGSTORADDSIZE=8000;
	freelk=0; sttoridx=0; sttoridxAdd=0;
	symtab = symtabPtr = new symtabst[STLNTH+1];
	symtabAdd = symtabAddPtr = new symtabAddst[SYMTABADDSIZE+1];
	for(int i=0;i<=STLNTH;i++){
		symtab[i].staddr=0;
		symtab[i].stlink=0;
		symtab[i].sttype=0;
		symtab[i].strefc=0;
		symtab[i].stopoth=0;
		symtab[i].stname_ptr=0;
		}
	for(int i=0;i<=SYMTABADDSIZE;i++){
		symtabAdd[i].stname_ptr=0;
		symtabAdd[i].staddr=0;
		symtabAdd[i].glbFlg=0;
		}

	symStor[0].alloc = SYMSTRINGSTORSIZE;
	symStor[0].storPtr = symStor[0].beg = new char[symStor[0].alloc];
	symStor[0].size = 0;
	symStor[1].alloc = SYMSTRINGSTORSIZE/2;
	symStor[1].beg = 0;
	symStor[2].alloc = SYMSTRINGSTORSIZE/2;
	symStor[2].beg = 0;
	symStor[3].alloc = SYMSTRINGSTORSIZE/2;
	symStor[3].beg = 0;

	symStor[4].alloc = SYMSTRINGSTORADDSIZE;
	symStor[4].storPtr = symStor[4].beg = new char[symStor[4].alloc] ;
	symStor[4].size = 0;
	symStor[5].beg = 0;
	symStor[5].alloc = SYMSTRINGSTORADDSIZE/2;
	symStor[6].beg = 0;
	symStor[6].alloc = SYMSTRINGSTORADDSIZE/2;
	symStor[7].beg = 0;
	symStor[7].alloc = SYMSTRINGSTORADDSIZE/2;

	symtabAddPtr = &symtabAdd[0];
	stindexMapPtr = &stindexMap[0];
	wd2grPtr = &wd2gr[0];

	for(int i=0;i<128;i++) hashlk[i]=0;
	permSymbolEnd=0;
}

SymbTable::~SymbTable() {
	delete symtab;
}

void SymbTable::alphInit(){hashstep=-1;alpharet=0;}

void SymbTable::gramfin(){//the grammar has been read delete address areas
	delete symtabAddPtr;
	symtabAddPtr = 0;
	int temtot=0;
	for(int i=4; i<8; i++){
		if(symStor[i].beg){
			temtot += symStor[i].size;
			delete symStor[i].beg;
			symStor[i].beg = 0;
			}
		}
	*coutP<<"Total temp symbol space= "<<temtot<<endl;
	return;
}
int SymbTable::stlength(){return sttoridx;}

int SymbTable::addst (const char *nm, int sytype, int opoth, int indxInFile) {
	int tpfl;
	if(sttoridx >= STLNTH)return -1;

	if(sytype<0) stindexMap[indxInFile] = 0;
	else {
		char * sts;
		tpfl = sytype==4 && *nm =='$'
		&& (strcmp(nm,"$RARE") != 0);
		sts = storSymbStrng(nm,tpfl);
		if(tpfl){ // add symbol to the address symbol table
			STINDEXMAP[indxInFile] = -(++sttoridxAdd);
//			symtabAdd[sttoridxAdd].stname_ptr = sts;
			(symtabAddPtr+sttoridxAdd)->stname_ptr = sts;
//			symtabAdd[sttoridxAdd].glbFlg = opoth&1;
			(symtabAddPtr+sttoridxAdd)->glbFlg = opoth&1;
//			symtabAdd[sttoridxAdd].staddr=0;
			(symtabAddPtr+sttoridxAdd)->staddr=0;
			}// if
		else {
			stindexMap[indxInFile] = ++sttoridx;
			//stindexMapRev[sttoridx] = indxInFile;
			symtab[sttoridx].stname_ptr = sts;
			symtab[sttoridx].sttype = sytype;
			symtab[sttoridx].stopoth = opoth;
			symtab[sttoridx].staddr=0;
			symtab[sttoridx].strefc=0;
			symtab[sttoridx].stlink=0;
			}// else
		}
	return 1;
}
#if 0
// merge a symbol from the separate WD symbol and maintain a
// separate index translator
int SymbTable::mergwd(const char *nm,int typ , int ref) {
	ix=lookst(nm);
	if(ix){
	stx=sytyp[ix]{
	if(sytyp[ix]!=typ){
	}
}
wdindextr[++wdindx]=
}
symtab[sttoridx].strefc=ref;
return sttoridx;
}
#endif

char * SymbTable::storSymbStrng(const char * string, int type){
	char * tpt;
	int idt;
	if(type)idt=4;
	else idt=0;
	if(symStor[idt+1].beg)idt++;//try entry 1 or 5
	if(symStor[idt+1].beg)idt++;//try enrty 2 or 6
	if(symStor[idt+1].beg)idt++;//try enrty 3 or 7
	int slen=strlen(string)+1;
	int nln = symStor[idt].size + slen;
	if(nln > symStor[idt].alloc){
	idt++;
	if(idt== 4 || idt==8){*coutP<<"Too too many symbols. Storing "<<string<<endl;exit(1);}
	symStor[idt].storPtr = symStor[idt].beg = new char[symStor[idt].alloc] ;
	symStor[idt].size = 0;
	nln=slen;
		}
	symStor[idt].size = nln;

	tpt=strcpy(symStor[idt].storPtr,string);
	symStor[idt].storPtr += slen;
	return tpt;
}

int SymbTable::getNextAlpha(){
	if(alpharet){temp=alpharet;alpharet=symtab[alpharet].stlink;return temp;}
	while(++hashstep<128){
	if((alpharet=hashlk[hashstep])){temp=alpharet;
	alpharet=symtab[alpharet].stlink;return temp;}
	}
	return 0;
}


// ************************************************************************
//    LOOKST searches the symbol table for -nm-, returning the
//    index of the symbol table entry if it appears, else 0.
// ************************************************************************

int SymbTable::lookst(const char * nm) {
// *                  get hash table pointer
	int link = hashlk[ihash(nm)];
	while(link){
//             compare symbol table entry with -nm-
//             If 0 (no list/end of list), return 0
//             match -- return index of symbol table entry
// cerr<<"lookst "<<link<<" "<<symtab[link].stname_ptr<<" "<<nm<<endl;
      if(strcmp(symtab[link].stname_ptr,nm)== 0)return link ; 
//              no match -- get next symbol table entry
      link=symtab[link].stlink;
}
	if(!permSymbolEnd) return 0 ;//if still loading permanant

// check if in temp symbol area
	for(int i=permSymbolEnd+1;i<=sttoridx;i++)
	if(strcmp(symtab[i].stname_ptr,nm)== 0)return i ; 

	return 0;
}

// ************************************************************************
//    PUTST creates a new symbol table entry containing nm, and
//    returns the index of this entry.
// ************************************************************************

int SymbTable::putst(const char *nm) {
/*
The general logic for allocating space in the symbol table is:
During the reading of the symbol table from the file the addsym function
is used and symbols are added sequentially to the table, except for symbol
of statements $xxx, which go to a temporary table and are discarded
after the grammar is loaded. There are other symbols which are generated
as part of initialization for various functions and constitute permanant
symbols. These are also added sequentially to the symbol table if not
already there. The symbol table object is informed that there is no
longer any permanant symbols. Any new symbols are part of the parsing
process for a sentence or tree and are discarded at the end of a parse or
transformation. 
The temporary symbols are allocated first, to any slots which have
previously been returned (though there will likely be none of these).
*/
	if(permSymbolEnd==0){ // are all the permanent symbols in

//                  store -nm- in table
		symtab[++sttoridx].stname_ptr=storSymbStrng(nm,0);
//                  link entry into symbol table
	int     nhash=ihash(nm);
		symtab[sttoridx].stlink=hashlk[nhash];
		hashlk[nhash]=sttoridx;
		return sttoridx ;
		}//if

	else { // this is a temp symbol do not link
//                  get free symbol table entry
		if(freelk != 0) {
			int link=freelk;
			freelk=symtab[freelk].stlink;
			return link;
			}
		else {
			if(sttoridx>=STLNTH)
	exitr(7, " ***** Symbol table full, run terminated");
			symtab[++sttoridx].stname_ptr=storSymbStrng(nm,0);
			symtab[sttoridx].strefc=0;
			symtab[sttoridx].staddr=0;
			return sttoridx; ;
			}//else
		} //else
}
// ************************************************************************
//      RMVST removes symbol table entry index from symbol table
// ************************************************************************

int  SymbTable::rmvst (int idx) {
//                      Determine on which linked list of symbol
//                      table this entry appears
	int  k=ihash(symtab[idx].stname_ptr);
	int link=hashlk[k];
//                         check if entry sought is first one on list
	if(link == idx){
//                                A. YES--RESET HASHLK TO NEXT LIST MEMBER
	hashlk[k]=symtab[idx].stlink;
}
	else {
//                         Search list for entry
		while(1){
			link=symtab[link].stlink;
//                                A. IF END OF LIST HIT FIRST, ERROR
			if(link==0) {
    		*coutP <<"**** RMVST has found error in symbol table linkage\n";
      				return 1 ;
				}
      			if(symtab[link].stlink==idx) {
//                    Splice entry out of list
      				symtab[link].stlink=symtab[idx].stlink;
				break ;
				} 
			} 
		} // else
//                            Place entry on free list
	symtab[idx].stlink=freelk;
	freelk=idx;
//                                A. clear out name, type
	symtab[idx].stname_ptr=(char *)(NULL);
	symtab[idx].sttype=0;
      	return 0;
      	}

int SymbTable::getst(const char * nme, int jytyp) {
int idx=lookst(nme);
      if(idx==0)idx=putst(nme);
      if(jytyp!=0) settyp (idx,jytyp);
      return idx;
     }

// ************************************************************************
//      SETTYP or's SYTYP into STTYPE(INDEX).  If the type field (bits 0
//      to 3) of STTYPE(INDEX) are nonzero and different from the type
//      field of SYTYP, an error message is printed.
// ************************************************************************

int  SymbTable::settyp (int idx,int sytyp)
{
	if((retsttype(idx) != 0) && ((sytyp & 0xf) != 0)) {
		if(retsttype(idx) != (sytyp & 0xf)){
		*coutP << " *** Type of symbol "<<symtab[idx].stname_ptr
			<< " conflicts with prior usage\n";
     		return 1 ;
			}
		}
	symtab[idx].sttype =  symtab[idx].sttype | sytyp ;
	return 0;
	}


//   Set up chains of entries with same hash value (chains are built
//   in alphabetical order so that reference map and housing directory
//   will appear in alphabetical order)

void SymbTable::sortstlink(){
	int j,lastj,ih,i;
	for(i=1;i<=sttoridx;i++){
//cout <<i<< " start processing st order\n";
		if(symtab[i].stname_ptr != (char *)NULL ){ 
			ih=ihash(symtab[i].stname_ptr);
			j=hashlk[ih];
		if(j==0 || (j!=0 && strcmp(symtab[j].stname_ptr,symtab[i].stname_ptr) > 0)) {
		symtab[i].stlink=j;
		hashlk[ih]=i;
		}
		else{
			lastj=j;
			j=symtab[j].stlink;
			while(j != 0) {
		if( strcmp(symtab[j].stname_ptr,symtab[i].stname_ptr) > 0) break;
		lastj=j;
		j=symtab[j].stlink;
			}//while
		symtab[i].stlink=j;
		symtab[lastj].stlink=i;
		} // else
		}// if empty entry
		} // for
#if 0
		for( i=sttoridx+1;i<=STLNTH;i++){
		symtab[i].stname_ptr=(char *)NULL;
		symtab[i].sttype=0;
		symtab[i].strefc=0;
	}
#endif

//       Chain together available space in symbol table
//       and clear reference and count entries
#if 0
	for(i=STLNTH;i>0 ;i--){
		if(symtab[i].stname_ptr==(char *)NULL) {
		symtab[i].stlink=freelk;
		symtab[i].strefc=0;
		symtab[i].staddr=0;
		freelk=i;
		}
	}
#endif
}

void SymbTable::symtabprint(){
for(int i=1;i<=sttoridx;i++) {*coutP << i<< "  ";
if( symtab[i].stname_ptr != (char *)NULL)
*coutP <<" " << symtab[i].stname_ptr
<< " "	<< symtab[i].sttype
<< " "	<< symtab[i].staddr
<< " "	<< symtab[i].strefc << "\n";
else *coutP <<i<< " <empty entry>\n";
}
}

void SymbTable::permSymbolDone(){
*coutP<<"Number of permanant Symbols = "<<sttoridx
<<"  Allocated Space = "<<STLNTH
<<"\nNumber of Address Symbols = "<<sttoridxAdd
<<"  Allocated Space = "<<SYMTABADDSIZE;
	int temtot=0;
	for(int i=0; i<4; i++){
		if(!symStor[i].beg)break;
		temtot += symStor[i].size;
		permSymbolEndSlot = i;
		}
*coutP<<"\nSize of Text Store for Perm. Symbols = "<<temtot<<endl;
	permSymbolEnd=sttoridx;
	permSymbolTextEnd=(char *)symStor[permSymbolEndSlot].storPtr;
	permSymbolTextSizeEnd=symStor[permSymbolEndSlot].size;
	return;
}

void SymbTable::freeTempSymbols(int endOfPermList){
	sttoridx = permSymbolEnd;
	for(int i=1;i<=permSymbolEnd;i++){
		if(symtab[i].staddr>endOfPermList) symtab[i].staddr=0;
		if(symtab[i].strefc>endOfPermList) symtab[i].strefc=0;
		} 
for(int i=permSymbolEndSlot+1;i<4;i++){
if(symStor[i].beg){
delete symStor[i].beg;
symStor[i].beg=0;
symStor[i].size=0;
symStor[i].storPtr=0;
}
}
	symStor[permSymbolEndSlot].storPtr = permSymbolTextEnd;
	symStor[permSymbolEndSlot].size = permSymbolTextSizeEnd;
	return;
}
