/* M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
   (c) 2005 All rights reserved.
   Read Terms of Use at http://mlp-xml.sourceforge.net.
   Contact medical_language_processing@gmail.com
*/
#include <iostream.h>
#include <fstream.h>
#include <iomanip.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "symtab.h"
#include "common.fcm"
#include "gencom.fcm"
#include "lispdefs.fcm"

#define TRUE 1
#define FALSE 0
#define SBPLIM 25
#define SUBPARTREC_TYPE 7
#define WDWITHCANFORMREC_TYPE 6
#define WDWITHATTRIBREC_TYPE 8

static void adjustdef(int);
extern fstream *getstptr(int);
extern int load(int);
extern void iniget(unsigned int *,int);
extern int cat(int, int);
extern int append(int, int);
extern int litral(char *);
extern int gcons(int,int,int);
extern void exitr(int, const char *);
#define SENTOKARLEN 1500
static char senToksAr[SENTOKARLEN], *senToksP;
extern void errmgp(int,int,int,int);
extern SymbTable sytab;

void plist(int,int,int);
//         table of special form names
//         table for subparts
static int isbp;
struct sbptstr{ char * sbpnamp; int sbpadr; short sbpsti;
	char sbpref; char sbpdef; };
static struct sbptstr sbpttbla[SBPLIM];
static struct sbptstr *sbpttbl=sbpttbla;

static int lexerr;
static int ncsf;
#define CSFTABLEN 500
static unsigned int csftab[CSFTABLEN];

struct def_ptr_st{int wordInSen; int groupPos;};

void readCanonData(int wdextf){
	unsigned int *csftabP=csftab, trd;
	fstream *wdextFileP = getstptr(wdextf);
	*wdextFileP>>hex>>trd;
	ncsf=0;
	while(trd){
		*(csftabP++)=trd; ncsf++;
		if(ncsf>CSFTABLEN){
		cerr<<"csftable overflow"<<endl;
		cerr<<"the last value read was "<<hex<<trd<<endl;
		exit(12);
			}//if
		*wdextFileP>>trd;
		}//while
	*wdextFileP>>dec;

	int nwd;
	for(int px=0; px<ncsf; px += nwd){
		int idx = sytab.getTransWDIdx(csftab[px]>>8);
		nwd = csftab[px++] & 0xff;
		sytab.setstcanf(idx, px);
		}//for

	*wdextFileP>>totalNumSent; //number of sentences
	return ;
}

static void scerrmsg(int type, char * nameP, char *dwordP){
	lexerr=TRUE;
	if(type <= 0){
		if(type < 0)
	*coutP <<" *** Invalid interpret field in "<< nameP<<endl;
		else
	*coutP << " *** No head in record "<<nameP<<endl;
		}//if

	else {
	switch (type){

	case 1:
		*coutP <<"*** Undefined canonical form "<<nameP;
		if(dwordP != (char *)NULL) *coutP<<"in "<<dwordP;
		*coutP<<endl;
		break;

	case 2:
		*coutP <<"*** Undefined special form "<<nameP;
		if(dwordP != (char *)NULL) *coutP<<" in "<<dwordP;
		*coutP<<endl;
		break;

	case 3:
		*coutP <<"*** Undefined subpart symbol "<<nameP
		<<" in defn of "<< dwordP <<endl;
		break;

	case 4:
		*coutP <<"*** Undefined symbol "<< nameP
		<<" in defn of "<< dwordP <<endl;
	}//switch
	}//else
	return;
}//func end

// - - - - - - - - - - - - - - - - - - - - - - - - - - 

// *                          and plural attributes on category list
static void fixupattr(int defpt){
//static char *fxattl[10]={"SINGULAR","PAST","M","F","PERS3","PRESNT","FUT",
//"IMP","COND","PLURAL"};

	int catl,flg, curatt, prevatt, nextatt, sattlst;
	char *namP;
// return;
	catl=CDRADDR(defpt);
	while(catl) {//loop through catagory list
		flg=0;
	prevatt=catl;
	curatt=CSRADDR(prevatt);
	while(1){//loop over att list
		nextatt=CDRADDR(curatt);
		sattlst=CARADDR(curatt);
		if(!ATOMP(sattlst)){ //this is a list
			if(!flg){CSRADDR(prevatt)=sattlst; flg=1;}
			else CDRADDR(prevatt)=sattlst;
			while(CDRADDR(sattlst))sattlst=CDRADDR(sattlst);
			CDRADDR(sattlst)=nextatt;
			curatt=sattlst;
			}//if a sublist
		if(nextatt==0)break;
		prevatt=curatt;
		curatt=nextatt;
		}//while on att list
#if 0
int carm = CARADDR(catl);
char *a1=STNAME(CARINT(carm));
int carcarm=CARINT(carm);//synbol list pointer
int csrm= CSRINT(catl);//att list pointer
int cdrp=csrm;
if(cdrp==0)continue; // cat has no atts
while(1){//over att list makor items
int jrg;
if((jrg=CDRINT(CARINT(csrm)))){ //an attrib sublist
CSRINT(catl)=CDRINT(csrm);
CDRINT(CSRINT(catl))=CARINT(csrm);
}// the att item is a list
break;
if((cdrp=CDR(cdrp))==0)break;// no more
}//while over att list
#endif
		catl=CDRINT(catl);
		} // while over cats
	return;
}//func end

//      - - - - - - - - - - - - - - - - - - - - - - - - - - - -

//                      Process subpart record

static void procSubPart(int startOfDef, int symidx, char * dwordP){
	int i;

//                                   1. Is it already in table
	for(i=0;i<isbp;i++) if(sbpttbl[i].sbpsti == symidx) break;

	if(i<isbp){
//                               2. yes, it is in table
//                                    subpart was already once
//                                    in this word, print warning
	if(sbpttbl[i].sbpdef != 0)*coutP<<"* Multiply defined subpart "
		<<dwordP<<" in word record "<<dwordP
		<<" (Last definition used)"<<endl;
//                                      (B) store new address in table
      		sbpttbl[i].sbpadr=startOfDef;
		} // if
	else {
//                                   3. no, add it to table
 		sbpttbl[isbp].sbpsti = symidx;
		sbpttbl[isbp].sbpadr = startOfDef;
		sbpttbl[isbp].sbpref = 0;
		sbpttbl[isbp].sbpnamp = dwordP;
		sbpttbl[isbp++].sbpdef = 1;
		}// else
	return ;
}

//  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

struct wdgrpst{int frstgw; int lastgw;};
static int endWordProc(int headp, struct wdgrpst *info, int nent, char * dwordP){
	int addr,ksym, j, idxInFile;

//cerr<<"endproc frst last categ "<<frstgw<<" "<<lastgw<<endl;
//for(int lgrp=frstgw;lgrp <= lastgw;lgrp++){
//cerr<<"befor ed d s a "<<lgrp<<" " << CDR(lgrp)<<" "<<hex<<CSR(lgrp)<<dec<<" "<<CAR(lgrp)<<endl; }
#if 0
{
int idexs,ixf;
cout<<"At entry to endW head="<<headp<<endl;
for(int ll=0; ll < nent; ll++){
for(int ii=info[ll].frstgw;ii <= info[ll].lastgw;ii++){
cout<<ii<<": " <<CDR(ii)<<" " <<CSR(ii)<<" " <<CAR(ii)<<" ";
if((CAR(ii)-SOS)>0){
if(CAR(ii)<SOL)ixf=(CAR(ii)-SOS) ;
else ixf= (CAR(ii)-SOL) ;
idexs= sytab.getTransWDIdx(ixf) ;
if(idexs>0)cout<< STNAME(idexs)<<"  "<<ixf;
else  cout<<idexs;
}
else cout<<"no car";
if(CSR(ii) & HEAD){cout<<endl;continue;}
if((CSR(ii)-SOS)>0&CSR(ii)<SOL){
idexs=sytab.getTransWDIdx((CSR(ii)-SOS)) ;
if(idexs>0)cout<<" "<<STNAME(idexs);
else  cout<<" "<<idexs;
}
cout<<endl; }
cout<<endl;}
cout<<endl;
}
#endif
//                   Change entries in grammar for this word
//                   from symbol table pointers to addresses
//cout<<"word processing "<<dwordP<<endl;
	for(int lp=0;lp < nent;lp++){
	for(int lgrp=info[lp].frstgw;lgrp <= info[lp].lastgw;lgrp++){
		ksym=CSRINT(lgrp);
		if((ksym & HEAD)){
	 		if((idxInFile=(CARINT(lgrp)-SOS))>0){
				if((sytab.getTransWDIdx(idxInFile))<0)continue; //** get rid
				CARADDR(lgrp)=STADDR(sytab.getTransWDIdx(idxInFile));
//cout<<"swd:head "<< lgrp<<" "<<STNAME(sytab.getTransWDIdx(idxInFile))<<endl;
				}//if
			} //if head

		else { // not a head

        		for(int i=0;i<2;i++) {
        			if(i==1)ksym=CARINT(lgrp);

				if((idxInFile = ksym-SOS)<0)continue;
				if(ksym<=SOL){ // a symbol
					ksym=sytab.getTransWDIdx(idxInFile);
					if(ksym < 0){//  subpart--look up on subpart table

					addr=0;
					for(j=0;j<isbp;j++) {
					if(sbpttbl[j].sbpsti == -ksym) {
						addr = sbpttbl[j].sbpadr;
						sbpttbl[j].sbpref=1;
						break;
						} // if
						} // for

					if(!addr) {
					if(j<isbp)
					scerrmsg(3, sbpttbl[j].sbpnamp, dwordP);
					else *coutP<<"Undefined subpart symbol with "
						<<"WD file index "<<idxInFile
						<<" in word "<<dwordP<<endl;
						return -1;
						}//if no addr
						} // if subpart

					else { //not subpart
//                         other symbol--get address from staddr
					if(!(addr=STADDR(ksym))){
						scerrmsg(4,STNAME(ksym),dwordP);
						return -1; }
//cout<<"swd:symb "<< lgrp<<" "<<STNAME(ksym)<<endl;// **debug
						}//else other sym no subpart
					}//if symbol

          			else {// literal: if undefined create new literal
				ksym=sytab.getTransWDIdx(ksym-SOL);
				if(!(addr = STREFC(ksym))){
					addr=gcons(0,(HEAD+ATOMIC+LTOMIC),ksym);
//                                   save address of literal in STREFC
				   	SETSTREFC(ksym,addr);
					} //if undefined
					}//else- literal

//                               store address in grammar
				if(i!=1) CSRADDR(lgrp)=addr;
				else CARADDR(lgrp)=addr;
				} // for i
			} // else not head
		} //for on lgrp
		} //for on lp
#if 0
{
cout<<"finish endW"<<endl;
for(int ll=0; ll < nent; ll++){
for(int ii=info[ll].frstgw;ii <= info[ll].lastgw;ii++){
cout<<ii<<": " << CDR(ii)<<" "<<CSR(ii)<<" "<<CAR(ii);
int hh=CAR(ii);
if(hh && hh<40000) {cout<<"   "<< CDR(hh)<<" "<<CSR(hh)<<" "<<CAR(hh);
if(!ATOMP(hh)){hh=CAR(hh);
if(hh && hh<40000) cout<<"   "<< CDR(hh)<<" "<<CSR(hh)<<" "<<CAR(hh);}}
cout<<endl; }
cout<<endl;}
}
#endif
//JR extern void adjustdef(int);
adjustdef(CDR(headp));

	return 0 ;
}

//-----------------------------------------------------------

/*
Because of the nature of the rls and the needs of the rest of the
parsing process is is necesary to make and adjustment of the word
definitions
*/
static void adjustdef(int catlist){
	int attf;
	for(int catdic=catlist;catdic;catdic=CDR(catdic)){
		if(!(attf=CSR(catdic))) continue;//no attribs
		if(!((CSR(CAR(attf))) & HEAD)){//not atomic 
			int attl=CDR(attf);
			CSR(catdic)=attl;
			while(CDR(attl))attl=CDR(attl);
			CDR(attl)=CAR(attf);
			}//if
		if(attf=CSR(catdic)) adjustdef(attf);
		}//for;
	return;
}//end of func

// - - - - - - - - - - - - - - - - - - - - - - - - - - 

char * appendSymToSentPile(char *sword){
	char * svp;
	svp=strcpy(senToksP,sword);
	senToksP += strlen(sword)+1;
	return svp;
	}

// - - - - - - - - - - - - - - - - - - - - - - - - - - 

void clearDef(int defInGroup,int ntoksdef,
		struct def_ptr_st ptr2defs[]){
	for(int i=0; i<ntoksdef; i++){
		if(ptr2defs[i].groupPos == defInGroup)
		SENTE6(ptr2defs[i].wordInSen)=-1;
		}
	return;
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - 

int scanwd(int wdextf, int parskp){

	int idexOfCan, idexOfSymb, isente, ctlw;
	struct wdgrpst wdinfo[40];
	int retValue=1;
	int wdobjlen;
	int numDefGrp;
	struct def_ptr_st ptr2defs[30];
	int defInGroup,ntoksdef;
	unsigned int wdobject[200], *wdbfP, *wdbfEndP;
	char recNameAr[300], *recNameP, *currWord;
	char * recnamParr[80], *pronamP, *recnamP, **wdtokP;
	int numInfoEnt=0, kat, nsymwd,homoflag,grpProc,nwdbuf;
	int lochd, icf, categ,idiomWordCount,tost,frmlst,form;

	senToksP=senToksAr;

//
	fstream *wdextFileP=getstptr(wdextf);
//                                    read WD data for sentence

// At the start of reading in the sentence data the temp WD file
// is positioned after the canonical forms and the number of sentences.
	char inb[100];
	*wdextFileP>>nwordSent; // number of words in sentence
	if(wdextFileP->eof())exitr(0, "EOF encountered on input");
	if(nwordSent>149)*coutP<<"sentence too long "<<nwordSent;
	wdextFileP->ignore(50,'\n'); //skip over newline

//cerr<<"nwordSent "<<nwordSent<<endl;
//                              if the number of words in the sentence is
//                              zero , there was error in lexical scan
      //if(!nwordSent) return -1;
//                          read in sentence tokens, identification
	if(parskp) {
		*wdextFileP >> numDefGrp;
		}
	lexerr=FALSE;
	wdextFileP->get(sentid,SENTIDLEN,'\n'); // read sentence ID
if(*sentid == '\0') *sentid = ' ';
//cerr<< " sentid "<<sentid<<endl;
	for(int p=0;p<nwordSent;p++) {// put sen tokens in pile
		*wdextFileP>>senToksP;
		wdextFileP->setf(ios::skipws);
		//*wdextFileP>>ws; // skip the white space
//cerr<< " sentok "<<senToksP<<endl;
// put sen word text into word pile and put address into symbol table
		SENTE1(p+1)=senToksP;
		SENTE2(p+1)=0;
		SENTE3(p+1)=0;
		SENTE4(p+1)=0;
		SENTE5(p+1)=0;
		SENTE6(p+1)=-1;

		senToksP += strlen(senToksP)+1;
		}

 	homoflag=0;

	*wdextFileP >> numDefGrp; // read number of groups of defs
//cerr<<"DB:nmbfs "<<numDefGrp<<endl;

	grpProc=0;
int grpstart;// **debug**
	while(grpProc++ < numDefGrp) {
grpstart=ig+1;// **debug**
//   Read in a unit of input. This consists of the the material for
//   a single group of word definitions

	*wdextFileP >>ntoksdef; // lines in def to word pointer table
//cerr<< "DB:ntoksdef "<<ntoksdef<<flush;
	for(int i=0;i<ntoksdef;i++)
		*wdextFileP >> ptr2defs[i].wordInSen>>ptr2defs[i].groupPos;

//for(int i=0;i<ntoksdef;i++)
//cerr<<"DB:ptrstodefs "<<ptr2defs[i].WordInSen<<" "<<ptr2defs[i].groupPos <<endl;

//                 Read in record names, idioms (if any), and compiled code
	*wdextFileP >> nsymwd;
//cerr<<"nsymwd "<<nsymwd<<endl;
	recNameP=recNameAr;
//					1. put rec names in pile
	for(int i=0;i<nsymwd;i++){
		*wdextFileP>>recNameP;
// put def word into word pile and put address of word into array
		recnamParr[i]=recNameP;
		recNameP += strlen(recNameP)+1 ;
		}
	wdtokP=recnamParr;
	pronamP = *wdtokP;
//cerr<< "prototype name "<<pronamP<<endl; // **debug

//for(int i=0;i<nsymwd;i++) cerr<<"symbols for group " <<recnamParr[i]<<endl;

//				Read object data
	*wdextFileP>>nwdbuf;
	*wdextFileP>>hex;
	wdbfEndP=wdobject;
	for(int i=0;i<nwdbuf;i++) *wdextFileP>>*(wdbfEndP++); 
	*wdextFileP>>dec;

//cerr <<hex;
//for(int i=0;i<nwdbuf;i++)cerr <<"object in arr "<<wdobject[i]<<endl; 
//cerr <<dec;

	defInGroup=0;
	isbp=0;
	frmlst=0;


//                             Unpack one record from buffer
	wdbfP=wdobject;
	while(wdbfP<wdbfEndP){
//				Decode control word
	ctlw = *(wdbfP++);
#define CW_NIDWD 26
#define CW_NIDWDLEN 6
#define CW_CANIDX 16
#define CW_CANIDXLEN 10
#define CW_RECTYP 12
#define CW_RECTYPLEN 4
#define CW_OBJLEN 12
	idiomWordCount = (ctlw>>CW_NIDWD)&((1<<CW_NIDWDLEN)-1);
	idexOfSymb = (ctlw>>CW_CANIDX) & ((1<<CW_CANIDXLEN)-1);
	tost = (ctlw>>CW_RECTYP) & ((1<<CW_RECTYPLEN)-1);
	wdobjlen = ctlw & ((1<<CW_OBJLEN)-1);
//cerr<< "control word "<< tost <<" "<<idiomWordCount<<" "<<wdobjlen<<" "<<idexes<<endl;

	if(tost == SUBPARTREC_TYPE){// Subpart record
		recnamP=*(wdtokP++) ;
		iniget(wdbfP,wdobjlen);
		wdbfP += wdobjlen;
//int lts; // **debug
//lts=ig+1; // **debug
		wdinfo[numInfoEnt].frstgw=ig+1;
		int lochds = load(ig);
		wdinfo[numInfoEnt++].lastgw=ig;

#if 0
for(int i=lts;i<=ig;i++){
cout<<recnamP<<" "<<i<<" "<<CDR(i)<<" "<<hex<<CSR(i)<<dec<<" "<<CAR(i)<<" "<<endl;}
cout <<endl;
#endif
		int hdsub=CDR(lochds);
		if(CAR(hdsub)<SOS)hdsub=CAR(hdsub);
		procSubPart(hdsub, idexOfSymb,  recnamP);
		continue;
		}//subpart


//        not a subpart.  New definition
		if(defInGroup!=0){ //  Complete processing of previous word
			if((retValue=endWordProc(lochd, wdinfo, numInfoEnt, currWord))>=0) {
;
#if 0
for(int pp=0;pp<numInfoEnt;pp++){
for(int hh=wdinfo[pp].frstgw;hh<=wdinfo[pp].lastgw;hh++){
if(CSR(hh)&ATOMIC !=0){
cout<<hh<<":"<<CDR(hh)<<"  "<<CSR(hh)<<" "<<CAR(hh)<<" "<<STNAME(CAR(hh))<<endl;
continue;
}
if(CAR(hh)<grpstart)
cout<<hh<<": "<<CDR(hh)<<"  "<<CSR(hh)<<" "<<CAR(hh)<<" "<<STNAME(CAR(CAR(hh)))<<endl;
else cout<<hh<<": "<<CDR(hh)<<"  "<<CSR(hh)<<" "<<CAR(hh)<<endl;
}//for
cout<<endl;
}//for
cout<<endl;
//plist(categ,0,PRUNIT); // **debug
		//		fixupattr(categ);
//plist(categ,0,PRUNIT); // **debug
#endif
}
		else clearDef(defInGroup,ntoksdef,ptr2defs);
			}//if

		numInfoEnt=0;
		recnamP=*(wdtokP++) ;
		currWord = recnamP;
//cerr<<"record name being processed "<<recnamP<< endl; // **debug


		if(tost != WDWITHATTRIBREC_TYPE){ //  Unpack category list
			iniget(wdbfP,wdobjlen);
			wdbfP += wdobjlen;
			} //if tost 8

		else { // Unpack canonical form
			wdbfP += wdobjlen;
			idexOfCan = sytab.getTransWDIdx(idexOfSymb);
			if(!(icf=sytab.retstcanf(idexOfCan)))
			{scerrmsg(1,STNAME(idexOfCan),recnamP);continue;}
			iniget(&csftab[icf],(csftab[icf-1]&0xff));
			}//else for canonical form def
//int lts; // **debug
//lts=ig+1; // **debug
		wdinfo[numInfoEnt].frstgw=ig+1;
		lochd = load(ig);
		wdinfo[numInfoEnt++].lastgw=ig;
#if 0
for(i=lts;i<=ig;i++){
cout<<recnamP<<" "<<i<<" "<<CDR(i)<<" "<<hex<<CSR(i)<<dec<<" "<<CAR(i)<<endl;}
cout <<endl;
#endif
		if(lochd <= 0)
		{scerrmsg(lochd,recnamP,(char *)NULL);continue;}
		defInGroup++;


//cerr<< "record name from pointer "<<*(wdtokP-1)<<endl;
	for(int i = 0; i < isbp; i++) sbpttbl[i].sbpdef=0;

int frmwd;
	char ** idmst=wdtokP;
	frmwd = form = gcons(0,0,litral(recnamP));
	for(int i=0; i<idiomWordCount; i++) {
		frmwd = CDR(frmwd)=gcons(0,0,litral(*(wdtokP++)));
		}

//           complete category list and add to FORMS list
//                1. kat = category list without head
	kat=CDR(lochd);
//                2. prefix kat with word FORM and add to forms list
//                   [note:  it is important that FRMLST be
//                       extended by modifying the existing
//                       list, because it is extended after
//                       pointers to frmlst have been placed
//                       in the list of category lists]

	frmlst=cat(frmlst,gcons(0,0,gcons(kat,0,form)));

//                   3. categ = kat prefixed word form
//                       [forms list], for insertion into SENTE2(.) list
	categ=gcons(kat,frmlst,form);

//            look for word in sentence
	for(int i=0 ; i<ntoksdef;i++){
		if(defInGroup == ptr2defs[i].groupPos){
        	isente = ptr2defs[i].wordInSen;

//            insert category list from word defn
//              into category list of sentence word
        	if(!SENTE2(isente)){
//                                   1. word has no prior category list
			SENTE2(isente)=categ;
			SENTE6(isente)=idiomWordCount+1;
			}//if
        	else {
//                                   2. sentence word has other category
//                                      sublists. Append current category
//                                      list to old catagory lists.
			SENTE3(isente)++;
			homoflag=1;
			*coutP<<"*** "<<recnamP;
			for(int ix=0; ix<idiomWordCount; ix++) *coutP<<' '<<*(idmst++);
			*coutP<<" appears more than once in WD (a homograph)"<<endl;

			SENTE2(isente)=append(SENTE2(isente),categ);
			} //else
		} // if this def is used

// 		  		 check if word appears again in sentence
  		} // for on def used table
	} // while on defs in the groups

// 				   complete processing of last word
	if((retValue=endWordProc(lochd, wdinfo, numInfoEnt, currWord))>=0)
{
;
#if 0
cout<<pronamP<<endl;
for(int pp=0;pp<numInfoEnt;pp++){
for(int hh=wdinfo[pp].frstgw;hh<=wdinfo[pp].lastgw;hh++){
if(CSR(hh)&ATOMIC !=0){
cout<<hh<<": "<<CDR(hh)<<"  "<<CSR(hh)<<" "<<CAR(hh)<<" "<<STNAME(CAR(CAR(hh)))<<endl;
continue;
}
if(CAR(hh)<grpstart)
cout<<hh<<": "<<CDR(hh)<<"  "<<CSR(hh)<<" "<<CAR(hh)<<" "<<STNAME(CAR(CAR(hh)))<<endl;
else cout<<hh<<": "<<CDR(hh)<<"  "<<CSR(hh)<<" "<<CAR(hh)<<endl;
}//for
cout<<endl;
}//for
cout<<endl;
//plist(categ,0,PRUNIT); // **debug
//		fixupattr(categ);
;
#endif
//plist(categ,0,PRUNIT); // **debug
;
}
	else clearDef(defInGroup,ntoksdef,ptr2defs);

// 		 check that every subpart has been referenced
	for(int i=0;i<isbp;i++)
	if(!sbpttbl[i].sbpref)
	*coutP <<"* Line "<<sbpttbl[i].sbpnamp
		<<" not referenced in definition of "
		<<pronamP<<" or its derivatives"<<endl;

	} // while on number of def groups for sentence

//    - - - - - - - - - - - - - - - - - - - - - - - - - - - -

//                       scan for words not defined
	char *sfnameP;
  int    iword=0;
	int frstUndef=0;
	while(++iword <= nwordSent){
	if(SENTE6(iword) == 1) continue;
	if(SENTE6(iword) > 1){
		for(int i=iword+1;i<=iword+SENTE6(iword)-1;i++) SENTE6(i)=0 ;
	if(SENTE2(iword)){iword += SENTE6(iword)-1; continue; }
		}//if

	pronamP=SENTWD(iword) ;
	if(frstUndef ==0)frstUndef=iword;

	errmgp(10,iword,0,0);
	lexerr = TRUE;
	} // while on words
	SENTE2(nwordSent+1)=0;
	if(lexerr == TRUE)return -frstUndef;
//plist(SENTE2(1),0,PRUNIT);
	return 1;

#if 0
// *   the homograph controls must be set up
      numhomo=0;
      firsthomo=0;
      sechomo=0;
      if(homoflag) {// then
        for(i=1;i<=nwordSent;i++){
        if(SENTE3(i)){ // then
          numhomo++;      
          if(numhomo<5){ //then
            homowrd[numhomo]=i;
            homocnt[numhomo]=SENTE3(i)+1;
          }//endif
          SENTE3(i)=0;
        } //endif
        }
     } 
// *
#endif
}
void switchSentArray(int falg) {
return;
}
