/* M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
   (c) 2005 All rights reserved.
   Read Terms of Use at http://mlp-xml.sourceforge.net.
   Contact medical_language_processing@gmail.com
*/
#include <fstream.h>
#include "common.fcm"
#include "nodefs.fcm"
#include "lispdefs.fcm"
#include "symtab.h"
#define TRUE 1
#define FALSE 0
extern int search(int,int);
extern int largo(int);
extern int nodtst(int);
extern void getreg(int, int *, int *);
extern void fill(const char *);
extern char * subsum(int,char *);
extern char * nodnam(int, char*);
extern void plist(int,int,int);
extern int oupone(void);
static int ctt=0;// **debug
extern SymbTable sytab;

//  find the first item on the list pointed to by xr7 which is on the
//  list pt2. Return this value.
int s7(int pt2){
	int sxr7=xr7, sf;
	do {
		if(sf=search(pt2,CAR(xr7))) return sf;
		}while(xr7=CDRADDR(xr7));
	xr7 = sxr7;
	return FALSE;
}

// ---------------------------------------------------------------

int isit(int argin){
	int ixr7,ilist;

	if((CSRINT(argin)&(HEAD+REGBIT))==(HEAD+REGBIT)){
	getreg(argin,&ixr7, &ilist);

//       if argument is a register containing a word, return + only

//       if currently looking at word pointed to by register
	if(ilist==2) return ((list==2) && (xr7 == ixr7));
		}

	argin=largo(argin);
//              at a node ...
//                  test if name of node is on list -argin-
	if(list==0) return nodtst(argin);

	else {
		if(list==1) return (search(argin,CARADDR(xr7))!=0);
//                 at a list element ...
//                      test if CAR is on list -argin-

		else{

//            at a word ...
//                  test if any element of catagory list is on list -argin-;
//                  if so, look at first such  element of catagory list

/*
int c2=SENTE2(xr7);
int c3=SENTE3(xr7);
cout<<endl;
cout<<"*** sente2 *** "<<(SENTE2(xr7))<<endl;
plist(SENTE2(xr7),FALSE,PRUNIT); cout<<endl;

cout<<"*** sente3 *** "<<(SENTE3(xr7))<<endl;
plist(SENTE3(xr7),FALSE,PRUNIT); cout<<endl;
*/

		int  sxr7;
//if(SENTE3(xr7) && xr7<word) sxr7=CAR(SENTE3(xr7));
//if(SENTE3(xr7) && xr7<word) sxr7=CDR(SENTE2(xr7));
sxr7=CDR(SENTE2(xr7));
/*
cout<<"\nCAR of sxr7"<<endl;
plist(CAR(sxr7),FALSE,PRUNIT);
cout<<"\nCDR of CAR of sxr7"<<endl;
plist(CDR(CAR(sxr7)),FALSE,PRUNIT);
cout<<"\nCAR of CDR of sxr7"<<endl;
plist(CAR(CDR(sxr7)),FALSE,PRUNIT);
cout<<"\n argin"<<endl;
plist(argin,FALSE,PRUNIT);
*/
//cout<<"V="<<(LOOKST("V"))<<" N="<<(LOOKST("N"))<<" TV="<<(LOOKST("TV"))<<endl;
		for ( ; sxr7; sxr7=CDRADDR(sxr7)){
//this is a hack the dict def structure should be fixed
int catl=CAR(sxr7);
/*
int xx=CAR(CAR(catl));
xx=catl;
if(ATOMP(xx)) cout<<(STNAME(CAR(xx)))<<endl;
else{cout<<(CSR(xx))<<" "<<(CAR(xx))<<"  "<<hex
<<(CSR(xx))<<" "<<(CAR(xx))<<dec<<endl;}
*/
	if(!(ATOMP(catl))) continue;
	for(int lstp=argin; lstp; lstp=CDR(lstp)){
//cout<<"catl="<<(STNAME(CAR(catl)))<<"  "<<(CAR(catl))<<endl;
//cout<<"argin="<<(STNAME(CAR(CAR(lstp))))<<"  "<<(CAR(CAR(lstp)))<<endl;
		if(catl == CAR(lstp)){
			//if(search(argin,catl)){
				xr7=sxr7; list=1;
				return TRUE;
				}//if
			}//if
			}//for
		return FALSE;
		}//else
	}//else not reg
}//func end

int searchCatList(int wordNum, int symb){
	int catl=SENTE2(wordNum);
	for(; catl; catl=CDR(catl)){
		if(ATOMP(CAR(catl)) ==0) continue;
		if(CAR(catl) == symb){
			return catl;
			}//if
		}//for
	return 0;
}

/*
 ***********************************************************************
      NODTST returns TRUE if the current node (pointed to by XR7) is on
      the list pointed to by ilist, otherwise FALSE.  If the list is a
      named list (ILIST points to a head) and is associated with a flag
      bit (which appears in the decrement field of the head of the list)
      NODTST checks whether this bit is set in Node(XR7+5).  Otherwise,
      NODTST must search the list for the name of the node (Node(XR7+7)).
 ***********************************************************************
*/

int nodtst(int ilist){
	if(!ilist) return FALSE;

	if(!ATOMP(ilist)){
//                   unnamed list -- search it for name of node
		if(!NDNONT(xr7)) return (search(ilist,NDHDBA(xr7))!=0);
		}
	 else{ // ATOMP
		if(CSRINT(ilist) == HEAD){
//          named list without bit flag -- search for name of node
		if(!NDNONT(xr7)){
			if(search(CDRADDR(ilist),NDHDBA(xr7))) return TRUE;
			}
			return FALSE;
			}

		else {
//                 named list with bit flag -- test whether bit is on
          	if(((CSRINT(ilist)&(~HEAD))&NDSPFB(xr7))) return TRUE;
			return FALSE;
			}
		}//else Atomp
}


// ************************************************************************
// *     PRTLOC is used as part of the restriction/transformation tracing
// *     mechanism.  If the current location is the node of the parse tree,
// *     PRTLOC prints the node name and the words subsumed by the node;
// *     If the current location is a list, that list is printed.
// ************************************************************************

void prtloc(void){
	char txtarr[400];
	fill(" -> ");
	if(list == 2){//sentence word
	fill("\"");
int wc,ii;
	fill(SENTWD(xr7));
	if((wc=SENTE6(xr7))>1){
	for(ii=xr7+1;ii<xr7+wc;ii++){
		fill("_");
		fill(SENTWD(ii));
		}
		}
	fill("\"");
	return;
	}

	if(!list){ //a node
ctt++;
char * ppp=nodnam(xr7, txtarr); // **fix this
        fill(ppp);

//          prints words subsumed unless node is empty
		if(NDWPNC(xr7) == 0) return;
		if(NDWPNC(xr7) == NDWPCP(xr7)) return;
		fill("=");
		fill(subsum(xr7,txtarr));
		return;
		}

//              list -- print the list
	plist(xr7,FALSE,PRUNIT);
	return;
	}

// ---------------------------------------------------------

int empty(void){
	int fw, lw;

//       if not looking at a node, exit -

	if(list) return FALSE;
	fw=NDWPNC(xr7);
	lw=NDWPCP(xr7);
	if(lw == 0)

//         Node is incomplete -- compare first word subsumed by node with
//         pending word in parsing process (if equal, node is empty)
		return (fw == word);
      else
//         node has been completed -- compare first and last words
//         subsumed by node (if equal, node is empty)
		return (fw == lw) ;
      }
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

int uptrn(int argin){
	int arg1,arg2,arg3,sxr7;
	sxr7=xr7;
	arg1=largo(CARADDR(argin));
	arg2=CDRADDR(argin);
	arg3=0;
	if(arg2) {//THEN
        arg3=CDRADDR(arg2);
        arg2=largo(CARADDR(arg2));
        if(arg3)arg3=largo(CARADDR(arg3));
      }
	while(1){
//  get parent of current node
// *                   if none exit -
		if(!oupone())break;//GO TO 9

// *       if parent's symbol matches arg1 member, exit +
		if(nodtst(arg1)) return TRUE;//GO TO 10

// *           if parent's symbol matches arg3 member, exit -
		if(nodtst(arg3)) break;//GO TO 9

// *                 if node not a string, loop
		if(!NDSTGT(xr7)) continue;//GO TO 1
// *      else, if symbol does not match ARG2 member, exit -
		if(!nodtst(arg2)) break;//GO TO 1
		} //while
	xr7=sxr7;
	return FALSE;
      }

// - - - - - - - - - - - - - - - - - - - - - - - - - - 
// *****  lin is the current sublevel
// *****  got2 is 1 if proper sublevel was reached
// *****  l2b  is the sublevel to be searched
int dntrn(int argin){
int arg1,arg2,arg3,lin,l2go,l2b,got2,sxr7;
	sxr7=xr7;
	arg1=largo(CARADDR(argin));
	arg2=CDRADDR(argin);
	arg3=0;
	if(arg2 != 0){
		arg3=CDRADDR(arg2);
		arg2=largo(CARADDR(arg2));
		if(arg3 != 0)arg3=largo(CARADDR(arg3));
		}


	l2b=1;
	lin=0;
	got2=0;
	l2go=l2b-lin;
// *****  see if allowed to descend
// *       if current sublevel=0, is ok
	while(1){
	do {
		if(lin) {
		if(nodtst(arg3)) break;
// *       if current node is not a string, is ok
		if(NDSTGT(xr7)) if(!nodtst(arg2)) break;
			} //if
// *****  can a level be descended
// *       not if down = 0
		if(NDBALP(xr7)==0) break;
// *       nor if node is ATOMIC
		if(NDATMT(xr7)) break;
// *****  can descend
		xr7=NDBALP(xr7);
		lin++;
// *      if not yet at sublevel to be searched, loop
		} while(--l2go);

	if(l2go==0) {
		got2=1;

		while(1){
		if(nodtst(arg1)) return TRUE;
		if(NDRTPT(xr7)==0) break;
		xr7=NDRTPT(xr7);
			} // while
		} //if l2go==0
	else {
// *****  cannot descend
		if(lin==0){
			if(got2==0){xr7=sxr7; return FALSE;}
			l2b++; got2=0; l2go=l2b-lin; continue;
			} // if
		else  if(NDRTPT(xr7)) { xr7=NDRTPT(xr7); continue;}
		}// else l2go !=0
// *****  ascend a level
		do {
			while(NDFILT(xr7)==0) {
if(NDUPLF(xr7)==0){ 
int gg=0;
}
xr7=NDUPLF(xr7); 
}
			xr7=NDUPLF(xr7); // go up
			if(--lin ==0) break;
      			} while(NDRTPT(xr7) ==0);

	if(lin!=0){ xr7=NDRTPT(xr7); l2go=l2b-lin;}
	else {
		if(got2==0){xr7=sxr7; return FALSE;}
		l2b++; got2=0; l2go=l2b-lin;
		}

	} // big while
}

#if 0
//      SUBROUTINE DNTRN
// ****  lin is the current sublevel
// ****  got2 is 1 if proper sublevel was reached
// ****  l2b  is the sublevel to be searched
// ****  l2go is the = of siblevels to descend

int dntrn(){
	int arg1,arg2,arg3,got2,lin,l2go,l2b,sxr7;
	sxr7=xr7;
	arg1=largo(CARADDR(arg));
	arg2=CDRADDR(arg);
	arg3=0;
	if(arg2) {
        arg3=CDRADDR(arg2);
        arg2=largo(CARADDR(arg2));
        if(arg3) arg3=largo(CARADDR(arg3));
	}
	l2b=0;
	lin=0;
L11:
	 l2b++;
      got2=0;
L15:
	l2go=l2b-lin;

goto L2;

// ****  can a level be descended
//        not if down = 0
L3:
	 if(NDBALP(xr7) == 0) goto L4;
//        nor if node is atomic
      if(NDATMT(xr7)) goto L4;

// ****  CAN DESCEND
      xr7=NDBALP(xr7);
      lin++;
      l2go--;

//      if not yet at sublevel to be searched, loop
	if(l2go) goto L2;
	got2=1;
L8:
	if(nodtst(arg1)) return TRUE;
	if(NDRTPT(xr7) == 0) goto L14;
	xr7=NDRTPT(xr7);
	goto L8;

// ****  CANNOT DESCEND
L4:
	 if(lin) goto L90;
L110:
	if(got2) goto L11;
	xr7=sxr7;
	return FALSE;

L90:
	 if(NDRTPT(xr7) != 0) goto L55;

// ****  ascend a leveL

L14:
    while(!NDFILT(xr7)){// GO TO 13
      xr7=NDUPLF(xr7);
	} //while
	xr7=NDUPLF(xr7);
      lin--;
      if(lin == 0) goto L110;
      if(NDRTPT(xr7) == 0) goto L14;
      xr7=NDRTPT(xr7);
      goto L15;

// ****  see if allowed to descend
//        IF CURRENT SUBLEVEL=0, IS OK

L2:
	 if(lin == 0) goto L3;
	 if(nodtst(arg3)) goto L4;

//       if current node is not a string, is ok
	 if(!(NDSTGT(xr7))) goto L3;
      if(nodtst(arg2)) goto L3;
      goto L4;
L55:
	  xr7=NDRTPT(xr7);
      goto  L2;
}
#endif
