/* M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
   (c) 2005 All rights reserved.
   Read Terms of Use at http://mlp-xml.sourceforge.net.
   Contact medical_language_processing@gmail.com
*/
      //SUBROUTINE NEWLOCALREG (IREG,IXR7,ILIST)
// ************************************************************************
// *     Functions NEWLOCALREG, SETREG, and GETREG allocate, assign to, and
// *     retrieve from the registers used in restrictions and
// *     transformations.

// *        RESTRICTION LANGUAGE provides dynamic name scoping
// *     parameters and registers declared local to a routine are
// *     accessible only to that routine[** ns  and any routines it calls].
// *** I think this is wrong I have removed it from the code]
// *     assignments to registers which have not been declared local or
// * are one of the parameters are
// *     created as global.

// *        Register values are stored in regstk. The structure regstk[I]
// *     has items: 
// *      1. reg specifies a register (points to symbol head for that register)
// *      2. xr7 and list hold the value of that register
// *     (item list = 0, 1, or 2 to indicate that item xr7 points to
// *     a node in the parse tree, a list element, or a sentence word,
// *     respectively).  Local values (values assigned to parameters and
// *     explicitly declared registers) are stored in regstk[0], ...,
// *     regstk[localreg-1], with the most recently allocated registers
// *     last. Global values are stored in regstk[globalreg], ...,
// *     regstk[REGLIM-1].
// ************************************************************************
#include <iostream.h>
#include <fstream.h>
extern fstream *coutP; // JR: could not include common.fcm, conflicts


const char * msgNumRegEx= "**** Number of register assignments exceeds limit";
#define REGLIM 90
#define REGSAVL 50

extern void exitr(int, const char *);

struct regstruc {int reg; int xr7; int list;} regstk[REGLIM];
struct regsavstr { regstruc *savP; int local; int global;
	int *localStkP; int localStkLen; int avail;} regSave[REGSAVL];
static int local_reg=0, local_reg_start, global_reg=REGLIM;
static int local_save,local_save_stk[20];
//static int regsavcnt=0; 

void reg_local_push(){
/* debug
cout<<"\nbefore local push "<<"local_save="<<local_save<<" local_reg="<<local_reg
<<" local_reg_start="<<local_reg_start
<< "\nlocal_save_stk="<<local_save_stk[0]<<"  "
<<local_save_stk[1]<<"  "
<<local_save_stk[2]<<"  "
<<local_save_stk[3]<<endl;
*/
	local_save_stk[local_save++]=local_reg;
	local_reg_start=local_reg;
/* debug
cout<<"\nafter local push "<<"local_save="<<local_save<<" local_reg="<<local_reg
<<" local_reg_start="<<local_reg_start
<< "\nlocal_save_stk="<<local_save_stk[0]<<"  "
<<local_save_stk[1]<<"  "
<<local_save_stk[2]<<"  "
<<local_save_stk[3]<<endl;
*/
}

void reg_local_pop(){
/*
cout<<"before local pop "<<"local_save="<<local_save<<" local_reg="<<local_reg
<<" local_reg_start="<<local_reg_start
<<endl;
*/
	local_reg=local_save_stk[--local_save];
if(local_save==0)
	local_reg_start = 0;
else
	local_reg_start=local_save_stk[local_save-1];
/*
cout<<"after local pop "<<"local_save="<<local_save<<" local_reg="<<local_reg
<<" local_reg_start="<<local_reg_start
<<endl;
*/
}

void regInit(void){
	for(int i=0;i<REGSAVL;i++) if(regSave[i].savP) {
		delete regSave[i].savP;
		regSave[i].savP = 0;
		regSave[i].avail = 0;
		}
local_reg=0; local_reg_start=0, global_reg=REGLIM; local_save=0; 
local_save_stk[0]=0;
	return;
}

static regstruc * regsavt;
int regsave(void){
	int regsavidx, i;
// get available save position
	for(regsavidx=0;regsavidx<REGSAVL;regsavidx++) {
		if(regSave[regsavidx].avail == 0){
		int regSavSiz = local_reg+(REGLIM-global_reg);
		regsavt=0;
// request a save area
		if(regSavSiz>0) regsavt= new regstruc[regSavSiz];
		regSave[regsavidx].savP = regsavt;
		regSave[regsavidx].local = local_reg; 
		regSave[regsavidx].global = REGLIM-global_reg; 
// save local registers
	for(i=0; i<local_reg; i++) *regsavt++ = regstk[i];
// save glogal registers
	for(i=global_reg; i<REGLIM; i++) *regsavt++ = regstk[i];
	regSave[regsavidx].avail = 1;
#if 0
cerr <<"at save point "<<regsavidx+1<<endl; // ** debug
cerr<<"Locals "<<local_reg<<endl;// **debug
for(i=0;i<local_reg;i++)// **debug
cerr<<regstk[i].reg<<" "<<regstk[i].xr7<<" " <<regstk[i].list<<endl;// **debug
cerr<<"Globals "<<global_reg<<endl;
for(i=global_reg;i<REGLIM;i++)// **debug
cerr<<regstk[i].reg<<" "<<regstk[i].xr7<<" " <<regstk[i].list<<endl;// **debug
#endif
	if (local_save){
		int * locsvp = new int[local_save];
		regSave[regsavidx].localStkP = locsvp;
		for( i=0;i<local_save;i++) *locsvp++ = local_save_stk[i];
		}
	else regSave[regsavidx].localStkP = 0;
	regSave[regsavidx].localStkLen = local_save;
	return regsavidx+1;
	} //if
	} //for
*coutP<<"no reg save position"<<endl;
	return 0; // could not find save area
}


void regrestore(int itmsaved){
	int i;
	itmsaved--;
	regstruc * regsavt = regSave[itmsaved].savP ;
	if(regsavt==0){//nothing saved
		local_reg = 0 ; 
		global_reg = REGLIM ; 
		}
	else {
		local_reg = regSave[itmsaved].local ; 
		global_reg = REGLIM-regSave[itmsaved].global ; 
		for(i=0; i<local_reg; i++) regstk[i] = *regsavt++;
		for(i=global_reg; i<REGLIM; i++) regstk[i] = *regsavt++;
		}
	local_save = regSave[itmsaved].localStkLen ;
	int *locsvp = regSave[itmsaved].localStkP ;
	for( i=0; i<local_save; i++) local_save_stk[i] =  *locsvp++ ;
#if 0
cerr <<"at restore point "<<itmsaved+1<<endl; // **debug
cerr<<"Locals "<<local_reg<<endl; // **debug
for(i=0;i<local_reg;i++) // **debug
cerr<<regstk[i].reg<<" "<<regstk[i].xr7<<" " <<regstk[i].list<<endl; // **debug
cerr<<"Globals "<<global_reg<<endl; // **debug
for(i=global_reg;i<REGLIM;i++) // **debug
cerr<<regstk[i].reg<<" "<<regstk[i].xr7<<" " <<regstk[i].list<<endl; // **debug
#endif
	return;
}

void regsavedel(int itmsaved){
	if(regSave[itmsaved-1].localStkLen){
		delete regSave[itmsaved-1].localStkP;
		regSave[itmsaved-1].localStkP = 0;
		}
	delete regSave[itmsaved-1].savP ;
	regSave[itmsaved-1].savP = 0 ;
	regSave[itmsaved-1].avail = 0 ;

//cerr<<"deleting save info at save point "<<itmsaved<<endl; // **debug
	return ;
}

void regsaveclear(void){
	int itmsaved;
//cerr<<"clearing all save info "<<endl;
	for(itmsaved=0;itmsaved<REGSAVL;itmsaved++){
		if(regSave[itmsaved].savP != 0){
			if(regSave[itmsaved].localStkLen){
				delete regSave[itmsaved].localStkP;
				regSave[itmsaved].localStkP = 0;
				}//if
			delete regSave[itmsaved].savP ;
			regSave[itmsaved].savP = 0 ;
			} //if
		}//for
	return ;
}

// ***********************************************************************
// *    NEWLOCALREG allocates a new instance of a local register REG and
// *    initializes it to the value (in_xr7,in_list).  (Registers are
// *    deallocated by resetting local_reg.)
// ************************************************************************

void newlocalreg(const int reg, const int in_xr7, const int in_list){
      if(local_reg >= global_reg) exitr(18, msgNumRegEx);
      regstk[local_reg].reg=reg;
      regstk[local_reg].xr7=in_xr7;
      regstk[local_reg].list=in_list;
      local_reg++;
      return;
}

// ************************************************************************
// *     SETREG assigns the value (IXR7,ILIST) to register REG.  SETREG
// *     assigns the value to the most recently created local instance,
// *     if one exists;  otherwise it makes a global assignment.
// ************************************************************************

void setreg( int reg,  int in_xr7,  int in_list){
//      Search for local instance
      for(int i=local_reg-1;i>=local_reg_start;i--){
		if(regstk[i].reg == reg){
			regstk[i].xr7=in_xr7; // Assign new value
			regstk[i].list=in_list;
			return;
		}
	}
{
//      Not found, search for a prior global asssignment
	for(int i=global_reg;i<REGLIM;i++){
		if(regstk[i].reg != reg) continue;
		regstk[i].xr7=in_xr7; // Assign new value
		regstk[i].list=in_list;
		return;
		}
}

//      No prior global assignment, add a new global assignment entry
	global_reg--;
	if(local_reg >= global_reg) exitr(18, msgNumRegEx); //Error - regstk full
	regstk[global_reg].reg=reg;
	regstk[global_reg].xr7=in_xr7;
	regstk[global_reg].list=in_list;
}

// ************************************************************************
// *     GETREG returns in IXR7 and ILIST the current value of register
// *     REG:  the value of the most recently created local instance,
// *     if one exists, otherwise its global value.  If the register is
// *     undefined (has not been assigned a value), GETREG returns with
// *     ixr7=ilist=0 
// ************************************************************************

void getreg(int reg, int * ixr7P, int * ilistP){
	int i;
// *      Search for local instance
	for(i=local_reg-1;i >= local_save_stk[local_save-1];i--){
		if(regstk[i].reg == reg) {
// *          Return value
			*ixr7P=regstk[i].xr7;
			*ilistP=regstk[i].list;
			return;
			}//if
		}// for

// *      Not found, search for a global asssignment
{
	for(i=global_reg;i<REGLIM;i++){
		if(regstk[i].reg == reg){
// *          Return value
			*ixr7P=regstk[i].xr7;
			*ilistP=regstk[i].list;
			return;
			}//if
		} //for
}

// *        Not found, register is undefined
	*ixr7P=0;
	*ilistP=0;
	return;
}
// *        UPDATE REGISTERS
// *                  if the value of a register is a Node which has not
// *                  been deleted, the register is unchanged. If the
// *                  value is a Node n which has been copied to n1,...,nk
// *                  and then deleted, the value of the register is
// *                  changed from n to n1 (the first copy). If the value
// *                  is a Node which has been deleted but not copied, the
// *                  register is marked as undefined.
#include "nodefs.fcm"
#include "common.fcm"
void updateRegisters(void){
int nd;
{
	for(int i=0; i<local_reg; i++){
		if(regstk[i].list)continue; //a list
        	if(nd=regstk[i].xr7) if(!NDSPFB(nd)) regstk[i].xr7=NDGCPS(nd);
		}//for
}

{
	for(int i=global_reg; i<REGLIM; i++){
		if(regstk[i].list) continue; //not a register
        	if(nd=regstk[i].xr7) if(!NDSPFB(nd)) regstk[i].xr7=NDGCPS(nd);
		} // for
}
// Update registers  in the stack saves
{
	int itmsaved,i, reg_tmp, nd;
	for(itmsaved=0;itmsaved<REGSAVL;itmsaved++){
		if(regSave[itmsaved].savP == 0)continue;
		regstruc * regsavt = regSave[itmsaved].savP ;
		reg_tmp = regSave[itmsaved].local + regSave[itmsaved].global ; 
		for(i=0; i<reg_tmp; i++, regsavt++) {
			if(regsavt->list) continue;
			if((nd = regsavt->xr7) == 0) continue;
			if(NDSPFB(nd) == 0)regsavt->xr7 = NDGCPS(nd);
			}//for
		}//for
}
}
