/* M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
   (c) 2005 All rights reserved.
   Read Terms of Use at http://mlp-xml.sourceforge.net.
   Contact medical_language_processing@gmail.com
*/
/*
*******************************************************************
     A left-recursive construction in the grammar would cause a top-
     down parser such as our routine PARSER to enter an infinite loop.
     To avoid this, parser calls recurs to keep track of those nodes
     which can appear in left-recursive loops.  (Such nodes must be
     flagged explicitly by the grammar writer by placing them on the
     recursive list.)  The routine recurs enforces the requirement that
     A subtree containing N-1 occurrances of a recursive Node named T
     at a word W be completed successfully before it will permit a
     tree with n occurrances of that recursive node at word w to be
     built.  Note that this requires that the option of a definition
     which leads to a left recursive loop must be the last option in a
     BNF definition.

          For each word in the sentence, for each recursive definition,
     the parser maintains (through calls on RECURS) the following three
     Counters:

        appearance-count:   the number of Nodes corresponding to this
                            definition which appear in the current tree
                            beginning at this word
        completion-count:   the number of nodes corresponding to this
                            definition which appear in the current tree
                            beginning at this word and have been
                            completed
        success-count:      the maximum number of occurrances of a node
                            corresponding to this definition beginning
                            at this word which have all been success-
                            fully completed (at any time during the
                            parsing of this sentence)

     These counters are maintained on lists pointed to by elements of
     the fifth column of SENTE.  SENTE5(word) points to a list of
     elements, each of which holds the three counters for a
     particular recursive definition in the following lithp format:
          definition-name
             [ ( SUCCESS-COUNT [ APPEARANCE-COUNT ] COMPLETION-COUNT )]
          RECURS is invoked at five points in the routine PARSER;
     it is passed a single argument, whose value is 0, 1, 2, 3, OR 4.
     the value of the argument, the point in the parse where recurs is
     called with this argument, and the operations performed by RECURS
     are tabulated below.

        0    Initialization       clear recur array

        1    When a recursive     if there is an element corresponding
             Node is about to        to this definition at this word
             be attached             then if APPEARANCE-COUNT!=SUCCESS
                                                               -COUNT
                                             then return FALSE
                                             else APPEARANCE-COUNT =
                                                   APPEARANCE-COUNT + 1
                                                  return TRUE
                                     else set up an element for this
                                        definition at this word with
                                           APPEARANCE-COUNT = 1
                                           COMPLETION-COUNT = 0
                                           SUCCESS-COUNT = 0
                                           and return TRUE

        2    When a recursive     COMPLETION-COUNT = COMPLETION-COUNT+1
             node is completed,   IF COMPLETION-COUNT .EQ. APPEARANCE-
             before any wellf.                                  COUNT
             restrictions on         THEN SUCCESS-COUNT = APPEARANCE-
             it are executed                                    COUNT

        3    When descending      COMPLETION-COUNT = COMPLETION-COUNT-1
             through a
             recursive Node

        4    When a recursive     APPEARANCE-COUNT = APPEARANCE-COUNT-1
             Node is detached
***********************************************************************
*/

#include <iostream.h>
#include <fstream.h>
#include "common.fcm"
#include "nodefs.fcm"
#include "lispdefs.fcm"
#include "symtab.h"
#define TRUE 1
#define FALSE 0
static int lcnt=0;// **debug
extern int gcons(int, int, int);
extern void prnt(void);
extern void flushbuf(int);
extern SymbTable  sytab;


int recurs(int type){

	int pointr,m,iw,nodndx,pass=TRUE;
	if(!type){
// 				I. type=0:  clear recur
	for(m=1;m<=nwordSent;m++) SENTE5(m)=0;
	return TRUE;
	}
//                             II. Get current Node name and Word
      if(type == 1) {nodndx=CAR(elemt); iw=word;}
      else { nodndx=CAR(NDHDBA(xr7)); iw=NDWPNC(xr7);}

if(rectrc)*coutP<< "Call to recurs ("<<type<<") for node "
<<STNAME(nodndx)<<" starting at word "<<iw<<endl;

//                             III. Look for element in recursives list
//                                  corresponding to current def + word
	int l=SENTE5(iw);
	while(l){// GO TO 60
		if(CAR(l) == nodndx) break;
		l=CDR(l);
		}//while
	if(!l){
//				A. not there
//				1. if i=1 create element and return TRUE
// 60
	if(type != 1) {//GO TO 70
//				2. if type  != 1 error

   *coutP<<"***** No recursive element for "<<STNAME(nodndx)
	<< " starting at word "<<iw<<endl;
	return FALSE;
	}

	pointr=gcons(0,1,0);
lcnt++;
	if(pointr<=0)return -1;
	SENTE5(iw)=gcons(SENTE5(iw),pointr,nodndx);
lcnt++;
	if(SENTE5(iw)<=0)return -1;
		}// if l!=0
	else {
// 				B. found it
// 80
	pointr=CSR(l);

	switch(type){
	case 1:

//                             IV. type=1:  attaching new element
	if(CSR(pointr)<= CAR(pointr)){
// 				A. appearance-count?=success-count
//                                   1. Increment appearance-count by 1
// 
		(CSR(pointr))++;
//                                   2. return TRUE
		} //if
	else {
//                                B. appearance count^success-count
//                                   1. If trace is on, print message
		if(trace){ flushbuf(2); *coutP<<" >>>>> Recursion"<<endl; }
//                	              2. return FALSE
		pass=FALSE;
		}
	break;
//                             V.  type=2:  Node completed
//                                A. Increment completion-count by 1
	case 2:
//                                B. If completion-count=appearance-count,
//                                   set success-count=completion-counT
	if(++(CDR(pointr)) == CSR(pointr)) CAR(pointr)=CSR(pointr);
	break;
//                             VI. type=3:  Descending through node,
//                                 decrement completion-count by 1
	case 3:
		(CDR(pointr))--;
		break;
//                             VII. type=4:  detaching node,
//                                  decrement appearance-count by 1
	case 4:
		(CSR(pointr))--;
		break;
	} // switch

	}//else l!=0
//                             VIII. If recursion trace is on, print
//                                   counter values after call
	if(rectrc)
	*coutP<<"      After call Appearance count= "<<CSR(pointr)
	<<"  Completion count= "<<CDR(pointr)
	<<"  Success count="<<CAR(pointr);
	return pass;
}
