/* M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
   (c) 2005 All rights reserved.
   Read Terms of Use at http://mlp-xml.sourceforge.net.
   Contact medical_language_processing@gmail.com
*/
#include <ctype.h>
#include <iostream.h>
#include <string.h>
#include <fstream.h>
#include <stdlib.h>
#include "lispdefs.fcm"
#include "common.fcm"
#include "gencom.fcm"

#include "symtab.h"
extern void exitr(const char * msg);
char* storestrg(char*);
SymbTable sytab;
int gcons(int,int,int);

fstream *getstptr(int);
int readstskip(int grunitn){
	char rdbuf[90];
	fstream *stFileP;
	stFileP=getstptr(grunitn);
//cerr <<grunitn<<"  " << " in readst at top\n";
	while(stFileP->getline(rdbuf,89)){
		if(stFileP->eof()) return -1; // no find symbol table
		if(rdbuf[0]=='S') return 0;
		}//while
}//end of func

// - - - - - - - - - - - - - - - - -- - - - - - - - - - - - - 

int getNextSymTabRec(fstream *stFileP, char * rdbufPtr,int *type,int *opoth) {
	char chr, *tpt;
	int ccc, tpopoth, irefc, ret=1;
//	if(!(stFileP->get())){return -1;}
	if((ccc=(*stFileP).get())==EOF){return -1;}
	stFileP->get(rdbufPtr,30);
	tpt=strchr(rdbufPtr,' ');// find the first blank
	if(tpt == rdbufPtr) ret = 0;
	else {

//if(*rdbufPtr==' '){cerr<< "blank detected at " << i+1<< "\n";

//cerr<<rdbufPtr<<endl;
//if(tpt!=*rdbufPtr)cerr << "length not equal\n"; }
		*tpt ='\0';
//cerr << "after out\n";
		*stFileP >> tpopoth >> irefc;
		*type= tpopoth & 0xf;
		*opoth = tpopoth>>4;
//cerr << "parar "<< i<<" "  << *type << " " << *irefc << "\n";

		} // else
	do { stFileP->get(chr); }while (chr != '\n');
	return ret;
}//end of func

// ************************************************************************
// *     READST reads in the symbol table from unit UNITN.
// ************************************************************************

int readst(int grunitn){
char rdbuf[90];
int rdret, stIndexFile = 0;
char *rdbufPtr=rdbuf;
fstream *stFileP;
stFileP=getstptr(grunitn);

//     Read in symbol table

int type, opoth, lensy;
int stover=0;
//cerr<<"starting reading st\n";
type=0;opoth=0;
while((rdret = getNextSymTabRec(stFileP, rdbufPtr, &type, &opoth))>=0){
stIndexFile++;
	if(rdret==0)continue; // empty line in symtable file
//cout<<rdbufPtr<<endl;// **debug**
if(sytab.addst(rdbufPtr, type, opoth, stIndexFile)<0){stover=1;break;}
}// while
lensy=sytab.stlength();
	if(lensy==0) {
//     Return if file is empty
        *coutP << "No symbol table\n" ;
//        exitr (" No symbol table");
	}
if(stover==0){
*coutP << "Number of symbols " << lensy << "\n";
//sytab.symtabprint();
}
#if 0
else{
      lensy=STLNTH;
    2 READ(UNIT=UNITN,FMT=11,END=13)NAME,EXES,ITYPE,IREFC
      nrem++;
      GO TO 2
   13 LENSY=I-1
	if (nrem==0) *coutP << " No. of symbols read = " << lensy <<"\n";
	else cout << "No. of symbols read = " << lensy
 	<<"  No. remaining  = " << nrem;
}// else
#endif
sytab.sortstlink();
      return 0 ;
#if 0
   cout<<" **** Symbol table length = "<<lensys<<"  Allocated space = "<< istl
     <<" Run aborted")
      exitr("SYMTSM")
#endif
}

void mergeSymt(int wdsymt){
//                   Merge symbol table from the WD file with
//                   the grammar which has already been loaded
	int in,type, opoth, refc, wdstix=0;
	char rsname[30];
//                                   Read in WD symbol table
	*coutP<<"\nWD symbol table read from UNIT "<<wdsymt<<endl;
	fstream * wdstFileP=getstptr(wdsymt);
	char *sname=rsname;
	while(getNextSymTabRec(wdstFileP,sname,&type,&opoth)>=0){
		wdstix++;
		if(*sname == '$') continue;//skip $xxx symbols
	if(strlen(sname)==0){sytab.wd2grst(wdstix,0);continue;}//no symbol
// if a subpart symbol do not add to symbol table mark in trans as minus
	if(type==10){
	sytab.wd2grst(wdstix,-wdstix); // mark the translation as subpart
//cout<<"name "<<sname<<" "<<wdstix<<endl; //** debug
		continue;
		}//if

//              check if WD symbol in grammar symbol table 
//       if not $xxx

	if(in=LOOKST(sname)){
//              Symbol is also in grammar symbol table check that types agree
//              If symbol appears in grammar only as a
//              literal, use type from WD symbol table
		if(!STTYPE(in)) SETSTTYPE(in,type);
		else {
//                       Symbol appears in WD only as a literal,
//                       use type from grammar symbol table
			if(type){ 
				if(STTYPE(in) != (type))
  *coutP<<" *** symbol "<<sname<<" has different types in GRAMMAR and WD"<<endl;
				} //if type
			} // else
		}//if in gr dict
	else {
//                   Symbol not in grammar symbol table, add it
		in=sytab.putst(sname);
		SETSTTYPE(in,type);
		int addr = gcons(0,HEAD,in);
		SETSTADDR(in,addr);
		}//else
	sytab.wd2grst(wdstix,in); // mark the translation
//cout<<"name "<<sname<<" "<<wdstix<<" in "<<in<<endl; //degug
#if 0
//                        Fix up address fields of symbol and literal
//                        heads to point to WD symbol table entry
//       (THIS FIX DOES NOT WORK FOR LOCAL SYMBOLS APPEARING
//       MORE THAN ONCE IN THE GRAMMAR)
	if(STADDR(in)) CAR(STADDR(in))=in;
	if(STREFC(in)) CAR(STREFC(in))=in;
	sname=rsname;
#endif
	}//while read record
	return ;
}//end of func
