/* M E D I C A L  L A N G U A G E  P R O C E S S I N G, LLC
   (c) 2005 All rights reserved.
   Read Terms of Use at http://mlp-xml.sourceforge.net.
   Contact medical_language_processing@gmail.com
*/
/*
***********************************************************************
    PLIST prints the list pointed to by LSTPTR in LITHP format.  The
    list structure is output as a continuous stream of characters.

    PLIST with PRETTY=TRUE ('PRETTY-PRINT LIST") also prints the list 
    pointed to by LSTPTR,  but with appropriate indentation to facilitate 
    reading the list.
***********************************************************************
*/

#define TRUE 1
#define FALSE 0
#include <iostream.h>
#include <fstream.h>
#include <iomanip.h>
#include "common.fcm"
#include "lispdefs.fcm"
#include "symtab.h"
#include <string.h>
extern SymbTable sytab;
extern void fill(const char*), prnt(void), decout(int);
extern char * dec(int,int);
extern void plistg(int,int,int,int);
extern void printfld(int);
extern int getprcol(int);
extern void setindent(int,int);
extern void setFillUnit(int);
extern void resetFillUnit();
static int colpos;

void plist(int lstptr, int pretty, int outUnit){
	plistg(lstptr,pretty, 0, outUnit);
	return;
}

void plistnn(int lstptr,int pretty, int outUnit){
	plistg(lstptr,pretty, 1, outUnit);
	return;
}

void plistg(int lstptr,int pretty, int type, int outUnit){
#define KPLIM 600
	int pos,ifld, kp, posstk[KPLIM],sktstk[KPLIM];
	int frstel, skount;

	setFillUnit(outUnit);
	if(!lstptr) {
		printfld(lstptr);
		if(type == 0) prnt();
		resetFillUnit();
		return;
		}

	if(ATOMP(lstptr)){
		printfld(lstptr);
		if(type == 0) prnt();
		resetFillUnit();
		return;
		}

	pos=lstptr;
	kp=0;
	colpos=0;

while(1){
int brc=-1;
L300:
	while(1){
if(brc==-1){
brc=2;
	if(pretty){
//            save current print column (for pretty printing)
		skount=colpos;
		frstel=TRUE;
		}
	fill("("); //     output (
} //if brc=-1 goto L100
else {

//                        Get next word
	brc = pos = CDR(pos);
	if(brc !=0) {
		if(ATOMP(pos)) brc=1;
		else brc=2;
		}
if(brc != 2){
if(brc == 1){
//			 symbol in CDR field
		fill(" . "); // output .(period)
		printfld(pos); // print symbol
}//if brc == 1
		
//                              at end of list
	fill(")"); // output ")"

//         if this is top level list, flush buffer and return
	if(kp<=0){
		if(type == 0) prnt();
		resetFillUnit();
		return;
		}

//		 else get previous positon from stack
	pos=posstk[--kp];
	if(pretty)skount=sktstk[kp];
	if(pos<0) {//else goto L200;
		pos=-pos;
		fill("]"); //output "]"
		continue;
		}//if new pos<0

}// if brc == 0 or 1

if(brc ==2){
//				not at end of list
		if(pretty){
			frstel=FALSE;
//    if pretty-printing, flush line and reset the column cntr
			if(getprcol(PRUNIT)!= skount){ prnt();fill("      "); }
			}//if pretty
		fill(" "); // output space
//                              3. go back for next word
}// brc == 2
}//else// brc != -1
if(brc ==2){
	if(!(ifld=CAR(pos))) {//    extract address
		printfld(ifld); //0 address field, print  NIL
		}// null CAR

	else {

//             stack current position and pursue lower level list
	if(!ATOMP(ifld)) break; //goto L120;

	printfld(ifld);// field points to symbol, print it

//  For atomic address, save print column after printing atom (FOR PRETTY-PRINT)
	if(pretty && frstel) skount=getprcol(outUnit);
		}//else
	}//if

//				Analyze special field
	if((ifld = CSR(pos))) {//if null print nothing goto L300;
		fill(" ["); // output "["

//             if field does not point to HEAD, stack current
//             position and pursue lower level list
	if(!ATOMP(ifld)) {pos=-pos;break;}
		printfld(ifld); // else print field
		fill("]"); // output ]
		}//if
	}//while;
	if(kp>=KPLIM) { 
        	prnt();
*coutP<<"*** List circular or too deeply nested, cannot be printed"<<endl;
		resetFillUnit();
		return;
		}
	posstk[kp++]=pos;
	if(pretty)sktstk[kp-1]=skount;
	pos=ifld;
	}//while
}

// ------------------------------------------------------------

//                      Print Field
void printfld(int ifld){
	if(!ifld){
		fill(" NIL");//0 address field, print  NIL
		return;
		}
	char * nameP;
	char litnam[60], * litnamP=litnam;
	if((CSR(ifld)&NONAM)){ //print number of unnamed head
		fill("*");
		decout(CAR(ifld));
		return;
		}

	if((CSR(ifld)&CNSTBT)==0){//not a constant
//                       B. print symbol name or literal
        	if((CSR(ifld)&LTOMIC)){ 
{
	int 	kfld=ifld;
        	*(litnamP++) ='\'';

	do{
		nameP=STNAME(CAR(kfld));
		while(*nameP !='\0'){
//   if an embedded apostrophe in literal make two apostrophes
			if(*nameP == '\'') *(litnamP++) = '\''; 
			*(litnamP++) = *(nameP++);
			}// while

		if(!(kfld=CDR(kfld)))break;
		*litnamP++ = '_';
		}while(1);

        *litnamP++ = '\'';
        *litnamP++ = '\0';
        fill(litnam);
}
		}//if LTOMIC
	else fill(STNAME(CAR(ifld)));
	return;
	}

		decout(CDR(ifld)); //  print numeric symbol
	return;
}
